<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/dataset_service.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1.DatasetService.SearchDataItems].
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.SearchDataItemsRequest</code>
 */
class SearchDataItemsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the Dataset from which to search DataItems.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $dataset = '';
    /**
     * The resource name of a SavedQuery(annotation set in UI).
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     * All of the search will be done in the context of this SavedQuery.
     *
     * Generated from protobuf field <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = {</code>
     * @deprecated
     */
    protected $saved_query = '';
    /**
     * The resource name of a DataLabelingJob.
     * Format:
     * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     * If this field is set, all of the search will be done in the context of
     * this DataLabelingJob.
     *
     * Generated from protobuf field <code>string data_labeling_job = 3;</code>
     */
    private $data_labeling_job = '';
    /**
     * An expression for filtering the DataItem that will be returned.
     *   * `data_item_id` - for = or !=.
     *   * `labeled` - for = or !=.
     *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *     have at least one annotation with annotation_spec_id =
     *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     * For example:
     * * `data_item=1`
     * * `has_annotation(5)`
     *
     * Generated from protobuf field <code>string data_item_filter = 4;</code>
     */
    private $data_item_filter = '';
    /**
     * An expression for filtering the Annotations that will be returned per
     * DataItem.
     *   * `annotation_spec_id` - for = or !=.
     *
     * Generated from protobuf field <code>string annotations_filter = 5 [deprecated = true];</code>
     * @deprecated
     */
    protected $annotations_filter = '';
    /**
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     *
     * Generated from protobuf field <code>repeated string annotation_filters = 11;</code>
     */
    private $annotation_filters;
    /**
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1.DataItemView] to read.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    private $field_mask = null;
    /**
     * If set, only up to this many of Annotations will be returned per
     * DataItemView. The maximum value is 1000. If not set, the maximum value will
     * be used.
     *
     * Generated from protobuf field <code>int32 annotations_limit = 7;</code>
     */
    private $annotations_limit = 0;
    /**
     * Requested page size. Server may return fewer results than requested.
     * Default and maximum page size is 100.
     *
     * Generated from protobuf field <code>int32 page_size = 8;</code>
     */
    private $page_size = 0;
    /**
     * A comma-separated list of fields to order by, sorted in ascending order.
     * Use "desc" after a field name for descending.
     *
     * Generated from protobuf field <code>string order_by = 9 [deprecated = true];</code>
     * @deprecated
     */
    protected $order_by = '';
    /**
     * A token identifying a page of results for the server to return
     * Typically obtained via
     * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1.SearchDataItemsResponse.next_page_token]
     * of the previous
     * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1.DatasetService.SearchDataItems]
     * call.
     *
     * Generated from protobuf field <code>string page_token = 10;</code>
     */
    private $page_token = '';
    protected $order;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $order_by_data_item
     *           A comma-separated list of data item fields to order by, sorted in
     *           ascending order. Use "desc" after a field name for descending.
     *     @type \Google\Cloud\AIPlatform\V1\SearchDataItemsRequest\OrderByAnnotation $order_by_annotation
     *           Expression that allows ranking results based on annotation's property.
     *     @type string $dataset
     *           Required. The resource name of the Dataset from which to search DataItems.
     *           Format:
     *           `projects/{project}/locations/{location}/datasets/{dataset}`
     *     @type string $saved_query
     *           The resource name of a SavedQuery(annotation set in UI).
     *           Format:
     *           `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     *           All of the search will be done in the context of this SavedQuery.
     *     @type string $data_labeling_job
     *           The resource name of a DataLabelingJob.
     *           Format:
     *           `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     *           If this field is set, all of the search will be done in the context of
     *           this DataLabelingJob.
     *     @type string $data_item_filter
     *           An expression for filtering the DataItem that will be returned.
     *             * `data_item_id` - for = or !=.
     *             * `labeled` - for = or !=.
     *             * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *               have at least one annotation with annotation_spec_id =
     *               `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     *           For example:
     *           * `data_item=1`
     *           * `has_annotation(5)`
     *     @type string $annotations_filter
     *           An expression for filtering the Annotations that will be returned per
     *           DataItem.
     *             * `annotation_spec_id` - for = or !=.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $annotation_filters
     *           An expression that specifies what Annotations will be returned per
     *           DataItem. Annotations satisfied either of the conditions will be returned.
     *             * `annotation_spec_id` - for = or !=.
     *           Must specify `saved_query_id=` - saved query id that annotations should
     *           belong to.
     *     @type \Google\Protobuf\FieldMask $field_mask
     *           Mask specifying which fields of
     *           [DataItemView][google.cloud.aiplatform.v1.DataItemView] to read.
     *     @type int $annotations_limit
     *           If set, only up to this many of Annotations will be returned per
     *           DataItemView. The maximum value is 1000. If not set, the maximum value will
     *           be used.
     *     @type int $page_size
     *           Requested page size. Server may return fewer results than requested.
     *           Default and maximum page size is 100.
     *     @type string $order_by
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *     @type string $page_token
     *           A token identifying a page of results for the server to return
     *           Typically obtained via
     *           [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1.SearchDataItemsResponse.next_page_token]
     *           of the previous
     *           [DatasetService.SearchDataItems][google.cloud.aiplatform.v1.DatasetService.SearchDataItems]
     *           call.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\DatasetService::initOnce();
        parent::__construct($data);
    }

    /**
     * A comma-separated list of data item fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending.
     *
     * Generated from protobuf field <code>string order_by_data_item = 12;</code>
     * @return string
     */
    public function getOrderByDataItem()
    {
        return $this->readOneof(12);
    }

    public function hasOrderByDataItem()
    {
        return $this->hasOneof(12);
    }

    /**
     * A comma-separated list of data item fields to order by, sorted in
     * ascending order. Use "desc" after a field name for descending.
     *
     * Generated from protobuf field <code>string order_by_data_item = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderByDataItem($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Expression that allows ranking results based on annotation's property.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;</code>
     * @return \Google\Cloud\AIPlatform\V1\SearchDataItemsRequest\OrderByAnnotation|null
     */
    public function getOrderByAnnotation()
    {
        return $this->readOneof(13);
    }

    public function hasOrderByAnnotation()
    {
        return $this->hasOneof(13);
    }

    /**
     * Expression that allows ranking results based on annotation's property.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SearchDataItemsRequest.OrderByAnnotation order_by_annotation = 13;</code>
     * @param \Google\Cloud\AIPlatform\V1\SearchDataItemsRequest\OrderByAnnotation $var
     * @return $this
     */
    public function setOrderByAnnotation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\SearchDataItemsRequest\OrderByAnnotation::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * Required. The resource name of the Dataset from which to search DataItems.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getDataset()
    {
        return $this->dataset;
    }

    /**
     * Required. The resource name of the Dataset from which to search DataItems.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setDataset($var)
    {
        GPBUtil::checkString($var, True);
        $this->dataset = $var;

        return $this;
    }

    /**
     * The resource name of a SavedQuery(annotation set in UI).
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     * All of the search will be done in the context of this SavedQuery.
     *
     * Generated from protobuf field <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = {</code>
     * @return string
     * @deprecated
     */
    public function getSavedQuery()
    {
        @trigger_error('saved_query is deprecated.', E_USER_DEPRECATED);
        return $this->saved_query;
    }

    /**
     * The resource name of a SavedQuery(annotation set in UI).
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
     * All of the search will be done in the context of this SavedQuery.
     *
     * Generated from protobuf field <code>string saved_query = 2 [deprecated = true, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setSavedQuery($var)
    {
        @trigger_error('saved_query is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->saved_query = $var;

        return $this;
    }

    /**
     * The resource name of a DataLabelingJob.
     * Format:
     * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     * If this field is set, all of the search will be done in the context of
     * this DataLabelingJob.
     *
     * Generated from protobuf field <code>string data_labeling_job = 3;</code>
     * @return string
     */
    public function getDataLabelingJob()
    {
        return $this->data_labeling_job;
    }

    /**
     * The resource name of a DataLabelingJob.
     * Format:
     * `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
     * If this field is set, all of the search will be done in the context of
     * this DataLabelingJob.
     *
     * Generated from protobuf field <code>string data_labeling_job = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDataLabelingJob($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_labeling_job = $var;

        return $this;
    }

    /**
     * An expression for filtering the DataItem that will be returned.
     *   * `data_item_id` - for = or !=.
     *   * `labeled` - for = or !=.
     *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *     have at least one annotation with annotation_spec_id =
     *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     * For example:
     * * `data_item=1`
     * * `has_annotation(5)`
     *
     * Generated from protobuf field <code>string data_item_filter = 4;</code>
     * @return string
     */
    public function getDataItemFilter()
    {
        return $this->data_item_filter;
    }

    /**
     * An expression for filtering the DataItem that will be returned.
     *   * `data_item_id` - for = or !=.
     *   * `labeled` - for = or !=.
     *   * `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that
     *     have at least one annotation with annotation_spec_id =
     *     `ANNOTATION_SPEC_ID` in the context of SavedQuery or DataLabelingJob.
     * For example:
     * * `data_item=1`
     * * `has_annotation(5)`
     *
     * Generated from protobuf field <code>string data_item_filter = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDataItemFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_item_filter = $var;

        return $this;
    }

    /**
     * An expression for filtering the Annotations that will be returned per
     * DataItem.
     *   * `annotation_spec_id` - for = or !=.
     *
     * Generated from protobuf field <code>string annotations_filter = 5 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getAnnotationsFilter()
    {
        @trigger_error('annotations_filter is deprecated.', E_USER_DEPRECATED);
        return $this->annotations_filter;
    }

    /**
     * An expression for filtering the Annotations that will be returned per
     * DataItem.
     *   * `annotation_spec_id` - for = or !=.
     *
     * Generated from protobuf field <code>string annotations_filter = 5 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setAnnotationsFilter($var)
    {
        @trigger_error('annotations_filter is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->annotations_filter = $var;

        return $this;
    }

    /**
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     *
     * Generated from protobuf field <code>repeated string annotation_filters = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAnnotationFilters()
    {
        return $this->annotation_filters;
    }

    /**
     * An expression that specifies what Annotations will be returned per
     * DataItem. Annotations satisfied either of the conditions will be returned.
     *   * `annotation_spec_id` - for = or !=.
     * Must specify `saved_query_id=` - saved query id that annotations should
     * belong to.
     *
     * Generated from protobuf field <code>repeated string annotation_filters = 11;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAnnotationFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotation_filters = $arr;

        return $this;
    }

    /**
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1.DataItemView] to read.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask field_mask = 6;</code>
     * @return \Google\Protobuf\FieldMask|null
     */
    public function getFieldMask()
    {
        return $this->field_mask;
    }

    public function hasFieldMask()
    {
        return isset($this->field_mask);
    }

    public function clearFieldMask()
    {
        unset($this->field_mask);
    }

    /**
     * Mask specifying which fields of
     * [DataItemView][google.cloud.aiplatform.v1.DataItemView] to read.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask field_mask = 6;</code>
     * @param \Google\Protobuf\FieldMask $var
     * @return $this
     */
    public function setFieldMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\FieldMask::class);
        $this->field_mask = $var;

        return $this;
    }

    /**
     * If set, only up to this many of Annotations will be returned per
     * DataItemView. The maximum value is 1000. If not set, the maximum value will
     * be used.
     *
     * Generated from protobuf field <code>int32 annotations_limit = 7;</code>
     * @return int
     */
    public function getAnnotationsLimit()
    {
        return $this->annotations_limit;
    }

    /**
     * If set, only up to this many of Annotations will be returned per
     * DataItemView. The maximum value is 1000. If not set, the maximum value will
     * be used.
     *
     * Generated from protobuf field <code>int32 annotations_limit = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setAnnotationsLimit($var)
    {
        GPBUtil::checkInt32($var);
        $this->annotations_limit = $var;

        return $this;
    }

    /**
     * Requested page size. Server may return fewer results than requested.
     * Default and maximum page size is 100.
     *
     * Generated from protobuf field <code>int32 page_size = 8;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Requested page size. Server may return fewer results than requested.
     * Default and maximum page size is 100.
     *
     * Generated from protobuf field <code>int32 page_size = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * A comma-separated list of fields to order by, sorted in ascending order.
     * Use "desc" after a field name for descending.
     *
     * Generated from protobuf field <code>string order_by = 9 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getOrderBy()
    {
        @trigger_error('order_by is deprecated.', E_USER_DEPRECATED);
        return $this->order_by;
    }

    /**
     * A comma-separated list of fields to order by, sorted in ascending order.
     * Use "desc" after a field name for descending.
     *
     * Generated from protobuf field <code>string order_by = 9 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setOrderBy($var)
    {
        @trigger_error('order_by is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * A token identifying a page of results for the server to return
     * Typically obtained via
     * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1.SearchDataItemsResponse.next_page_token]
     * of the previous
     * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1.DatasetService.SearchDataItems]
     * call.
     *
     * Generated from protobuf field <code>string page_token = 10;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A token identifying a page of results for the server to return
     * Typically obtained via
     * [SearchDataItemsResponse.next_page_token][google.cloud.aiplatform.v1.SearchDataItemsResponse.next_page_token]
     * of the previous
     * [DatasetService.SearchDataItems][google.cloud.aiplatform.v1.DatasetService.SearchDataItems]
     * call.
     *
     * Generated from protobuf field <code>string page_token = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrder()
    {
        return $this->whichOneof("order");
    }

}

