<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/baremetalsolution/v2/baremetalsolution.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BareMetalSolution\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BareMetalSolution\V2\CreateNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\CreateProvisioningConfigRequest;
use Google\Cloud\BareMetalSolution\V2\CreateSSHKeyRequest;
use Google\Cloud\BareMetalSolution\V2\CreateVolumeSnapshotRequest;
use Google\Cloud\BareMetalSolution\V2\DeleteNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\DeleteSSHKeyRequest;
use Google\Cloud\BareMetalSolution\V2\DeleteVolumeSnapshotRequest;
use Google\Cloud\BareMetalSolution\V2\DetachLunRequest;
use Google\Cloud\BareMetalSolution\V2\DisableInteractiveSerialConsoleRequest;
use Google\Cloud\BareMetalSolution\V2\EnableInteractiveSerialConsoleRequest;
use Google\Cloud\BareMetalSolution\V2\EvictLunRequest;
use Google\Cloud\BareMetalSolution\V2\EvictVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\GetInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\GetLunRequest;
use Google\Cloud\BareMetalSolution\V2\GetNetworkRequest;
use Google\Cloud\BareMetalSolution\V2\GetNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\GetProvisioningConfigRequest;
use Google\Cloud\BareMetalSolution\V2\GetVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\GetVolumeSnapshotRequest;
use Google\Cloud\BareMetalSolution\V2\Instance;
use Google\Cloud\BareMetalSolution\V2\ListInstancesRequest;
use Google\Cloud\BareMetalSolution\V2\ListInstancesResponse;
use Google\Cloud\BareMetalSolution\V2\ListLunsRequest;
use Google\Cloud\BareMetalSolution\V2\ListLunsResponse;
use Google\Cloud\BareMetalSolution\V2\ListNetworkUsageRequest;
use Google\Cloud\BareMetalSolution\V2\ListNetworkUsageResponse;
use Google\Cloud\BareMetalSolution\V2\ListNetworksRequest;
use Google\Cloud\BareMetalSolution\V2\ListNetworksResponse;
use Google\Cloud\BareMetalSolution\V2\ListNfsSharesRequest;
use Google\Cloud\BareMetalSolution\V2\ListNfsSharesResponse;
use Google\Cloud\BareMetalSolution\V2\ListOSImagesRequest;
use Google\Cloud\BareMetalSolution\V2\ListOSImagesResponse;
use Google\Cloud\BareMetalSolution\V2\ListProvisioningQuotasRequest;
use Google\Cloud\BareMetalSolution\V2\ListProvisioningQuotasResponse;
use Google\Cloud\BareMetalSolution\V2\ListSSHKeysRequest;
use Google\Cloud\BareMetalSolution\V2\ListSSHKeysResponse;
use Google\Cloud\BareMetalSolution\V2\ListVolumeSnapshotsRequest;
use Google\Cloud\BareMetalSolution\V2\ListVolumeSnapshotsResponse;
use Google\Cloud\BareMetalSolution\V2\ListVolumesRequest;
use Google\Cloud\BareMetalSolution\V2\ListVolumesResponse;
use Google\Cloud\BareMetalSolution\V2\Lun;
use Google\Cloud\BareMetalSolution\V2\Network;
use Google\Cloud\BareMetalSolution\V2\NfsShare;
use Google\Cloud\BareMetalSolution\V2\ProvisioningConfig;
use Google\Cloud\BareMetalSolution\V2\RenameInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\RenameNetworkRequest;
use Google\Cloud\BareMetalSolution\V2\RenameNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\RenameVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\ResetInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\ResizeVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\RestoreVolumeSnapshotRequest;
use Google\Cloud\BareMetalSolution\V2\SSHKey;
use Google\Cloud\BareMetalSolution\V2\StartInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\StopInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\SubmitProvisioningConfigRequest;
use Google\Cloud\BareMetalSolution\V2\SubmitProvisioningConfigResponse;
use Google\Cloud\BareMetalSolution\V2\UpdateInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\UpdateNetworkRequest;
use Google\Cloud\BareMetalSolution\V2\UpdateNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\UpdateProvisioningConfigRequest;
use Google\Cloud\BareMetalSolution\V2\UpdateVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\Volume;
use Google\Cloud\BareMetalSolution\V2\VolumeSnapshot;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Performs management operations on Bare Metal Solution servers.
 *
 * The `baremetalsolution.googleapis.com` service provides management
 * capabilities for Bare Metal Solution servers. To access the API methods, you
 * must assign Bare Metal Solution IAM roles containing the desired permissions
 * to your staff in your Google Cloud project. You must also enable the Bare
 * Metal Solution API. Once enabled, the methods act
 * upon specific servers in your Bare Metal Solution environment.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $bareMetalSolutionClient = new BareMetalSolutionClient();
 * try {
 *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
 *     $nfsShare = new NfsShare();
 *     $operationResponse = $bareMetalSolutionClient->createNfsShare($formattedParent, $nfsShare);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $bareMetalSolutionClient->createNfsShare($formattedParent, $nfsShare);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'createNfsShare');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $bareMetalSolutionClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\BareMetalSolution\V2\Client\BareMetalSolutionClient} to use the
 * new surface.
 */
class BareMetalSolutionGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.baremetalsolution.v2.BareMetalSolution';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'baremetalsolution.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $instanceNameTemplate;

    private static $instanceConfigNameTemplate;

    private static $interconnectAttachmentNameTemplate;

    private static $locationNameTemplate;

    private static $lunNameTemplate;

    private static $nFSShareNameTemplate;

    private static $networkNameTemplate;

    private static $networkConfigNameTemplate;

    private static $provisioningConfigNameTemplate;

    private static $serverNetworkTemplateNameTemplate;

    private static $sshKeyNameTemplate;

    private static $volumeNameTemplate;

    private static $volumeConfigNameTemplate;

    private static $volumeSnapshotNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/bare_metal_solution_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/bare_metal_solution_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/bare_metal_solution_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/bare_metal_solution_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getInstanceNameTemplate()
    {
        if (self::$instanceNameTemplate == null) {
            self::$instanceNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/instances/{instance}'
            );
        }

        return self::$instanceNameTemplate;
    }

    private static function getInstanceConfigNameTemplate()
    {
        if (self::$instanceConfigNameTemplate == null) {
            self::$instanceConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/instanceConfigs/{instance_config}'
            );
        }

        return self::$instanceConfigNameTemplate;
    }

    private static function getInterconnectAttachmentNameTemplate()
    {
        if (self::$interconnectAttachmentNameTemplate == null) {
            self::$interconnectAttachmentNameTemplate = new PathTemplate(
                'projects/{project}/regions/{region}/interconnectAttachments/{interconnect_attachment}'
            );
        }

        return self::$interconnectAttachmentNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getLunNameTemplate()
    {
        if (self::$lunNameTemplate == null) {
            self::$lunNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/volumes/{volume}/luns/{lun}'
            );
        }

        return self::$lunNameTemplate;
    }

    private static function getNFSShareNameTemplate()
    {
        if (self::$nFSShareNameTemplate == null) {
            self::$nFSShareNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/nfsShares/{nfs_share}'
            );
        }

        return self::$nFSShareNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/networks/{network}'
            );
        }

        return self::$networkNameTemplate;
    }

    private static function getNetworkConfigNameTemplate()
    {
        if (self::$networkConfigNameTemplate == null) {
            self::$networkConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/networkConfigs/{network_config}'
            );
        }

        return self::$networkConfigNameTemplate;
    }

    private static function getProvisioningConfigNameTemplate()
    {
        if (self::$provisioningConfigNameTemplate == null) {
            self::$provisioningConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/provisioningConfigs/{provisioning_config}'
            );
        }

        return self::$provisioningConfigNameTemplate;
    }

    private static function getServerNetworkTemplateNameTemplate()
    {
        if (self::$serverNetworkTemplateNameTemplate == null) {
            self::$serverNetworkTemplateNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/serverNetworkTemplate/{server_network_template}'
            );
        }

        return self::$serverNetworkTemplateNameTemplate;
    }

    private static function getSshKeyNameTemplate()
    {
        if (self::$sshKeyNameTemplate == null) {
            self::$sshKeyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/sshKeys/{ssh_key}'
            );
        }

        return self::$sshKeyNameTemplate;
    }

    private static function getVolumeNameTemplate()
    {
        if (self::$volumeNameTemplate == null) {
            self::$volumeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/volumes/{volume}'
            );
        }

        return self::$volumeNameTemplate;
    }

    private static function getVolumeConfigNameTemplate()
    {
        if (self::$volumeConfigNameTemplate == null) {
            self::$volumeConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/volumeConfigs/{volume_config}'
            );
        }

        return self::$volumeConfigNameTemplate;
    }

    private static function getVolumeSnapshotNameTemplate()
    {
        if (self::$volumeSnapshotNameTemplate == null) {
            self::$volumeSnapshotNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}'
            );
        }

        return self::$volumeSnapshotNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'instance' => self::getInstanceNameTemplate(),
                'instanceConfig' => self::getInstanceConfigNameTemplate(),
                'interconnectAttachment' => self::getInterconnectAttachmentNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'lun' => self::getLunNameTemplate(),
                'nFSShare' => self::getNFSShareNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'networkConfig' => self::getNetworkConfigNameTemplate(),
                'provisioningConfig' => self::getProvisioningConfigNameTemplate(),
                'serverNetworkTemplate' => self::getServerNetworkTemplateNameTemplate(),
                'sshKey' => self::getSshKeyNameTemplate(),
                'volume' => self::getVolumeNameTemplate(),
                'volumeConfig' => self::getVolumeConfigNameTemplate(),
                'volumeSnapshot' => self::getVolumeSnapshotNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName($project, $location, $instance)
    {
        return self::getInstanceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * instance_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instanceConfig
     *
     * @return string The formatted instance_config resource.
     */
    public static function instanceConfigName(
        $project,
        $location,
        $instanceConfig
    ) {
        return self::getInstanceConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance_config' => $instanceConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * interconnect_attachment resource.
     *
     * @param string $project
     * @param string $region
     * @param string $interconnectAttachment
     *
     * @return string The formatted interconnect_attachment resource.
     */
    public static function interconnectAttachmentName(
        $project,
        $region,
        $interconnectAttachment
    ) {
        return self::getInterconnectAttachmentNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'interconnect_attachment' => $interconnectAttachment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a lun
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     * @param string $lun
     *
     * @return string The formatted lun resource.
     */
    public static function lunName($project, $location, $volume, $lun)
    {
        return self::getLunNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
            'lun' => $lun,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a nfs_share
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $nfsShare
     *
     * @return string The formatted nfs_share resource.
     */
    public static function nFSShareName($project, $location, $nfsShare)
    {
        return self::getNFSShareNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'nfs_share' => $nfsShare,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $location, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * network_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $networkConfig
     *
     * @return string The formatted network_config resource.
     */
    public static function networkConfigName(
        $project,
        $location,
        $networkConfig
    ) {
        return self::getNetworkConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'network_config' => $networkConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * provisioning_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $provisioningConfig
     *
     * @return string The formatted provisioning_config resource.
     */
    public static function provisioningConfigName(
        $project,
        $location,
        $provisioningConfig
    ) {
        return self::getProvisioningConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'provisioning_config' => $provisioningConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * server_network_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serverNetworkTemplate
     *
     * @return string The formatted server_network_template resource.
     */
    public static function serverNetworkTemplateName(
        $project,
        $location,
        $serverNetworkTemplate
    ) {
        return self::getServerNetworkTemplateNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'server_network_template' => $serverNetworkTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ssh_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $sshKey
     *
     * @return string The formatted ssh_key resource.
     */
    public static function sshKeyName($project, $location, $sshKey)
    {
        return self::getSshKeyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'ssh_key' => $sshKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a volume
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     *
     * @return string The formatted volume resource.
     */
    public static function volumeName($project, $location, $volume)
    {
        return self::getVolumeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volumeConfig
     *
     * @return string The formatted volume_config resource.
     */
    public static function volumeConfigName($project, $location, $volumeConfig)
    {
        return self::getVolumeConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'volume_config' => $volumeConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_snapshot resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     * @param string $snapshot
     *
     * @return string The formatted volume_snapshot resource.
     */
    public static function volumeSnapshotName(
        $project,
        $location,
        $volume,
        $snapshot
    ) {
        return self::getVolumeSnapshotNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
            'snapshot' => $snapshot,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     * - instanceConfig: projects/{project}/locations/{location}/instanceConfigs/{instance_config}
     * - interconnectAttachment: projects/{project}/regions/{region}/interconnectAttachments/{interconnect_attachment}
     * - location: projects/{project}/locations/{location}
     * - lun: projects/{project}/locations/{location}/volumes/{volume}/luns/{lun}
     * - nFSShare: projects/{project}/locations/{location}/nfsShares/{nfs_share}
     * - network: projects/{project}/locations/{location}/networks/{network}
     * - networkConfig: projects/{project}/locations/{location}/networkConfigs/{network_config}
     * - provisioningConfig: projects/{project}/locations/{location}/provisioningConfigs/{provisioning_config}
     * - serverNetworkTemplate: projects/{project}/locations/{location}/serverNetworkTemplate/{server_network_template}
     * - sshKey: projects/{project}/locations/{location}/sshKeys/{ssh_key}
     * - volume: projects/{project}/locations/{location}/volumes/{volume}
     * - volumeConfig: projects/{project}/locations/{location}/volumeConfigs/{volume_config}
     * - volumeSnapshot: projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'baremetalsolution.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Create an NFS share.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     $nfsShare = new NfsShare();
     *     $operationResponse = $bareMetalSolutionClient->createNfsShare($formattedParent, $nfsShare);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->createNfsShare($formattedParent, $nfsShare);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'createNfsShare');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The parent project and location.
     * @param NfsShare $nfsShare     Required. The NfsShare to create.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createNfsShare($parent, $nfsShare, array $optionalArgs = [])
    {
        $request = new CreateNfsShareRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setNfsShare($nfsShare);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateNfsShare',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create new ProvisioningConfig.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     $provisioningConfig = new ProvisioningConfig();
     *     $response = $bareMetalSolutionClient->createProvisioningConfig($formattedParent, $provisioningConfig);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string             $parent             Required. The parent project and location containing the
     *                                               ProvisioningConfig.
     * @param ProvisioningConfig $provisioningConfig Required. The ProvisioningConfig to create.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type string $email
     *           Optional. Email provided to send a confirmation with provisioning config
     *           to.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\ProvisioningConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function createProvisioningConfig(
        $parent,
        $provisioningConfig,
        array $optionalArgs = []
    ) {
        $request = new CreateProvisioningConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setProvisioningConfig($provisioningConfig);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['email'])) {
            $request->setEmail($optionalArgs['email']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateProvisioningConfig',
            ProvisioningConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Register a public SSH key in the specified project for use with the
     * interactive serial console feature.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     $sshKey = new SSHKey();
     *     $sshKeyId = 'ssh_key_id';
     *     $response = $bareMetalSolutionClient->createSSHKey($formattedParent, $sshKey, $sshKeyId);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent containing the SSH keys.
     * @param SSHKey $sshKey       Required. The SSH key to register.
     * @param string $sshKeyId     Required. The ID to use for the key, which will become the final component
     *                             of the key's resource name.
     *
     *                             This value must match the regex:
     *                             [a-zA-Z0-9&#64;.\-_]{1,64}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\SSHKey
     *
     * @throws ApiException if the remote call fails
     */
    public function createSSHKey(
        $parent,
        $sshKey,
        $sshKeyId,
        array $optionalArgs = []
    ) {
        $request = new CreateSSHKeyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSshKey($sshKey);
        $request->setSshKeyId($sshKeyId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateSSHKey',
            SSHKey::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Takes a snapshot of a boot volume.
     * Returns INVALID_ARGUMENT if called for a non-boot volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     $volumeSnapshot = new VolumeSnapshot();
     *     $response = $bareMetalSolutionClient->createVolumeSnapshot($formattedParent, $volumeSnapshot);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string         $parent         Required. The volume to snapshot.
     * @param VolumeSnapshot $volumeSnapshot Required. The snapshot to create.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\VolumeSnapshot
     *
     * @throws ApiException if the remote call fails
     */
    public function createVolumeSnapshot(
        $parent,
        $volumeSnapshot,
        array $optionalArgs = []
    ) {
        $request = new CreateVolumeSnapshotRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setVolumeSnapshot($volumeSnapshot);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateVolumeSnapshot',
            VolumeSnapshot::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Delete an NFS share. The underlying volume is automatically deleted.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->nFSShareName('[PROJECT]', '[LOCATION]', '[NFS_SHARE]');
     *     $operationResponse = $bareMetalSolutionClient->deleteNfsShare($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->deleteNfsShare($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'deleteNfsShare');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the NFS share to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteNfsShare($name, array $optionalArgs = [])
    {
        $request = new DeleteNfsShareRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteNfsShare',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a public SSH key registered in the specified project.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->sshKeyName('[PROJECT]', '[LOCATION]', '[SSH_KEY]');
     *     $bareMetalSolutionClient->deleteSSHKey($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the SSH key to delete.
     *                             Currently, the only valid value for the location is "global".
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSSHKey($name, array $optionalArgs = [])
    {
        $request = new DeleteSSHKeyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteSSHKey',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a volume snapshot.
     * Returns INVALID_ARGUMENT if called for a non-boot volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->volumeSnapshotName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[SNAPSHOT]');
     *     $bareMetalSolutionClient->deleteVolumeSnapshot($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the snapshot to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteVolumeSnapshot($name, array $optionalArgs = [])
    {
        $request = new DeleteVolumeSnapshotRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteVolumeSnapshot',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Detach LUN from Instance.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedInstance = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $formattedLun = $bareMetalSolutionClient->lunName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[LUN]');
     *     $operationResponse = $bareMetalSolutionClient->detachLun($formattedInstance, $formattedLun);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->detachLun($formattedInstance, $formattedLun);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'detachLun');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $instance     Required. Name of the instance.
     * @param string $lun          Required. Name of the Lun to detach.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $skipReboot
     *           If true, performs lun unmapping without instance reboot.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function detachLun($instance, $lun, array $optionalArgs = [])
    {
        $request = new DetachLunRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setLun($lun);
        $requestParamHeaders['instance'] = $instance;
        if (isset($optionalArgs['skipReboot'])) {
            $request->setSkipReboot($optionalArgs['skipReboot']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DetachLun',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Disable the interactive serial console feature on an instance.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $operationResponse = $bareMetalSolutionClient->disableInteractiveSerialConsole($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->disableInteractiveSerialConsole($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'disableInteractiveSerialConsole');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function disableInteractiveSerialConsole(
        $name,
        array $optionalArgs = []
    ) {
        $request = new DisableInteractiveSerialConsoleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DisableInteractiveSerialConsole',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Enable the interactive serial console feature on an instance.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $operationResponse = $bareMetalSolutionClient->enableInteractiveSerialConsole($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->enableInteractiveSerialConsole($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'enableInteractiveSerialConsole');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function enableInteractiveSerialConsole(
        $name,
        array $optionalArgs = []
    ) {
        $request = new EnableInteractiveSerialConsoleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'EnableInteractiveSerialConsole',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Skips lun's cooloff and deletes it now.
     * Lun must be in cooloff state.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->lunName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[LUN]');
     *     $operationResponse = $bareMetalSolutionClient->evictLun($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->evictLun($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'evictLun');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the lun.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function evictLun($name, array $optionalArgs = [])
    {
        $request = new EvictLunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'EvictLun',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Skips volume's cooloff and deletes it now.
     * Volume must be in cooloff state.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     $operationResponse = $bareMetalSolutionClient->evictVolume($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->evictVolume($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'evictVolume');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Volume.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function evictVolume($name, array $optionalArgs = [])
    {
        $request = new EvictVolumeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'EvictVolume',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Get details about a single server.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $response = $bareMetalSolutionClient->getInstance($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\Instance
     *
     * @throws ApiException if the remote call fails
     */
    public function getInstance($name, array $optionalArgs = [])
    {
        $request = new GetInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetInstance',
            Instance::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get details of a single storage logical unit number(LUN).
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->lunName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[LUN]');
     *     $response = $bareMetalSolutionClient->getLun($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\Lun
     *
     * @throws ApiException if the remote call fails
     */
    public function getLun($name, array $optionalArgs = [])
    {
        $request = new GetLunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLun',
            Lun::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get details of a single network.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->networkName('[PROJECT]', '[LOCATION]', '[NETWORK]');
     *     $response = $bareMetalSolutionClient->getNetwork($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\Network
     *
     * @throws ApiException if the remote call fails
     */
    public function getNetwork($name, array $optionalArgs = [])
    {
        $request = new GetNetworkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNetwork',
            Network::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get details of a single NFS share.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->nFSShareName('[PROJECT]', '[LOCATION]', '[NFS_SHARE]');
     *     $response = $bareMetalSolutionClient->getNfsShare($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\NfsShare
     *
     * @throws ApiException if the remote call fails
     */
    public function getNfsShare($name, array $optionalArgs = [])
    {
        $request = new GetNfsShareRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNfsShare',
            NfsShare::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get ProvisioningConfig by name.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->provisioningConfigName('[PROJECT]', '[LOCATION]', '[PROVISIONING_CONFIG]');
     *     $response = $bareMetalSolutionClient->getProvisioningConfig($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the ProvisioningConfig.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\ProvisioningConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getProvisioningConfig($name, array $optionalArgs = [])
    {
        $request = new GetProvisioningConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetProvisioningConfig',
            ProvisioningConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get details of a single storage volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     $response = $bareMetalSolutionClient->getVolume($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\Volume
     *
     * @throws ApiException if the remote call fails
     */
    public function getVolume($name, array $optionalArgs = [])
    {
        $request = new GetVolumeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetVolume',
            Volume::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified snapshot resource.
     * Returns INVALID_ARGUMENT if called for a non-boot volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->volumeSnapshotName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[SNAPSHOT]');
     *     $response = $bareMetalSolutionClient->getVolumeSnapshot($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the snapshot.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\VolumeSnapshot
     *
     * @throws ApiException if the remote call fails
     */
    public function getVolumeSnapshot($name, array $optionalArgs = [])
    {
        $request = new GetVolumeSnapshotRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetVolumeSnapshot',
            VolumeSnapshot::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * List servers in a given project and location.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listInstances($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listInstances($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListInstancesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           List filter.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInstances($parent, array $optionalArgs = [])
    {
        $request = new ListInstancesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListInstances',
            $optionalArgs,
            ListInstancesResponse::class,
            $request
        );
    }

    /**
     * List storage volume luns for given storage volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listLuns($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listLuns($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListLunsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLuns($parent, array $optionalArgs = [])
    {
        $request = new ListLunsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLuns',
            $optionalArgs,
            ListLunsResponse::class,
            $request
        );
    }

    /**
     * List all Networks (and used IPs for each Network) in the vendor account
     * associated with the specified project.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedLocation = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $bareMetalSolutionClient->listNetworkUsage($formattedLocation);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $location     Required. Parent value (project and location).
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\ListNetworkUsageResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNetworkUsage($location, array $optionalArgs = [])
    {
        $request = new ListNetworkUsageRequest();
        $requestParamHeaders = [];
        $request->setLocation($location);
        $requestParamHeaders['location'] = $location;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ListNetworkUsage',
            ListNetworkUsageResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * List network in a given project and location.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listNetworks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listNetworks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListNetworksRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           List filter.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNetworks($parent, array $optionalArgs = [])
    {
        $request = new ListNetworksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNetworks',
            $optionalArgs,
            ListNetworksResponse::class,
            $request
        );
    }

    /**
     * List NFS shares.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listNfsShares($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listNfsShares($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListNfsSharesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           List filter.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNfsShares($parent, array $optionalArgs = [])
    {
        $request = new ListNfsSharesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNfsShares',
            $optionalArgs,
            ListNfsSharesResponse::class,
            $request
        );
    }

    /**
     * Retrieves the list of OS images which are currently approved.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listOSImages($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listOSImages($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListProvisioningQuotasRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listOSImages($parent, array $optionalArgs = [])
    {
        $request = new ListOSImagesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListOSImages',
            $optionalArgs,
            ListOSImagesResponse::class,
            $request
        );
    }

    /**
     * List the budget details to provision resources on a given project.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listProvisioningQuotas($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listProvisioningQuotas($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListProvisioningQuotasRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProvisioningQuotas($parent, array $optionalArgs = [])
    {
        $request = new ListProvisioningQuotasRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListProvisioningQuotas',
            $optionalArgs,
            ListProvisioningQuotasResponse::class,
            $request
        );
    }

    /**
     * Lists the public SSH keys registered for the specified project.
     * These SSH keys are used only for the interactive serial console feature.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listSSHKeys($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listSSHKeys($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent containing the SSH keys.
     *                             Currently, the only valid value for the location is "global".
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSSHKeys($parent, array $optionalArgs = [])
    {
        $request = new ListSSHKeysRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSSHKeys',
            $optionalArgs,
            ListSSHKeysResponse::class,
            $request
        );
    }

    /**
     * Retrieves the list of snapshots for the specified volume.
     * Returns a response with an empty list of snapshots if called
     * for a non-boot volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listVolumeSnapshots($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listVolumeSnapshots($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListVolumesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVolumeSnapshots($parent, array $optionalArgs = [])
    {
        $request = new ListVolumeSnapshotsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListVolumeSnapshots',
            $optionalArgs,
            ListVolumeSnapshotsResponse::class,
            $request
        );
    }

    /**
     * List storage volumes in a given project and location.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listVolumes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listVolumes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListVolumesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           List filter.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVolumes($parent, array $optionalArgs = [])
    {
        $request = new ListVolumesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListVolumes',
            $optionalArgs,
            ListVolumesResponse::class,
            $request
        );
    }

    /**
     * RenameInstance sets a new name for an instance.
     * Use with caution, previous names become immediately invalidated.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $newInstanceId = 'new_instance_id';
     *     $response = $bareMetalSolutionClient->renameInstance($formattedName, $newInstanceId);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name          Required. The `name` field is used to identify the instance.
     *                              Format: projects/{project}/locations/{location}/instances/{instance}
     * @param string $newInstanceId Required. The new `id` of the instance.
     * @param array  $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\Instance
     *
     * @throws ApiException if the remote call fails
     */
    public function renameInstance(
        $name,
        $newInstanceId,
        array $optionalArgs = []
    ) {
        $request = new RenameInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setNewInstanceId($newInstanceId);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RenameInstance',
            Instance::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * RenameNetwork sets a new name for a network.
     * Use with caution, previous names become immediately invalidated.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->networkName('[PROJECT]', '[LOCATION]', '[NETWORK]');
     *     $newNetworkId = 'new_network_id';
     *     $response = $bareMetalSolutionClient->renameNetwork($formattedName, $newNetworkId);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The `name` field is used to identify the network.
     *                             Format: projects/{project}/locations/{location}/networks/{network}
     * @param string $newNetworkId Required. The new `id` of the network.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\Network
     *
     * @throws ApiException if the remote call fails
     */
    public function renameNetwork(
        $name,
        $newNetworkId,
        array $optionalArgs = []
    ) {
        $request = new RenameNetworkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setNewNetworkId($newNetworkId);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RenameNetwork',
            Network::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * RenameNfsShare sets a new name for an nfsshare.
     * Use with caution, previous names become immediately invalidated.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->nFSShareName('[PROJECT]', '[LOCATION]', '[NFS_SHARE]');
     *     $newNfsshareId = 'new_nfsshare_id';
     *     $response = $bareMetalSolutionClient->renameNfsShare($formattedName, $newNfsshareId);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name          Required. The `name` field is used to identify the nfsshare.
     *                              Format: projects/{project}/locations/{location}/nfsshares/{nfsshare}
     * @param string $newNfsshareId Required. The new `id` of the nfsshare.
     * @param array  $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\NfsShare
     *
     * @throws ApiException if the remote call fails
     */
    public function renameNfsShare(
        $name,
        $newNfsshareId,
        array $optionalArgs = []
    ) {
        $request = new RenameNfsShareRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setNewNfsshareId($newNfsshareId);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RenameNfsShare',
            NfsShare::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * RenameVolume sets a new name for a volume.
     * Use with caution, previous names become immediately invalidated.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     $newVolumeId = 'new_volume_id';
     *     $response = $bareMetalSolutionClient->renameVolume($formattedName, $newVolumeId);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The `name` field is used to identify the volume.
     *                             Format: projects/{project}/locations/{location}/volumes/{volume}
     * @param string $newVolumeId  Required. The new `id` of the volume.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\Volume
     *
     * @throws ApiException if the remote call fails
     */
    public function renameVolume($name, $newVolumeId, array $optionalArgs = [])
    {
        $request = new RenameVolumeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setNewVolumeId($newVolumeId);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RenameVolume',
            Volume::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Perform an ungraceful, hard reset on a server. Equivalent to shutting the
     * power off and then turning it back on.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $operationResponse = $bareMetalSolutionClient->resetInstance($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->resetInstance($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'resetInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resetInstance($name, array $optionalArgs = [])
    {
        $request = new ResetInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ResetInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Emergency Volume resize.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedVolume = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     $operationResponse = $bareMetalSolutionClient->resizeVolume($formattedVolume);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->resizeVolume($formattedVolume);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'resizeVolume');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $volume       Required. Volume to resize.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $sizeGib
     *           New Volume size, in GiB.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resizeVolume($volume, array $optionalArgs = [])
    {
        $request = new ResizeVolumeRequest();
        $requestParamHeaders = [];
        $request->setVolume($volume);
        $requestParamHeaders['volume'] = $volume;
        if (isset($optionalArgs['sizeGib'])) {
            $request->setSizeGib($optionalArgs['sizeGib']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ResizeVolume',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Uses the specified snapshot to restore its parent volume.
     * Returns INVALID_ARGUMENT if called for a non-boot volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedVolumeSnapshot = $bareMetalSolutionClient->volumeSnapshotName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[SNAPSHOT]');
     *     $operationResponse = $bareMetalSolutionClient->restoreVolumeSnapshot($formattedVolumeSnapshot);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->restoreVolumeSnapshot($formattedVolumeSnapshot);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'restoreVolumeSnapshot');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $volumeSnapshot Required. Name of the snapshot which will be used to restore its parent
     *                               volume.
     * @param array  $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function restoreVolumeSnapshot(
        $volumeSnapshot,
        array $optionalArgs = []
    ) {
        $request = new RestoreVolumeSnapshotRequest();
        $requestParamHeaders = [];
        $request->setVolumeSnapshot($volumeSnapshot);
        $requestParamHeaders['volume_snapshot'] = $volumeSnapshot;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'RestoreVolumeSnapshot',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Starts a server that was shutdown.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $operationResponse = $bareMetalSolutionClient->startInstance($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->startInstance($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'startInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startInstance($name, array $optionalArgs = [])
    {
        $request = new StartInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'StartInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Stop a running server.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $operationResponse = $bareMetalSolutionClient->stopInstance($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->stopInstance($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'stopInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function stopInstance($name, array $optionalArgs = [])
    {
        $request = new StopInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'StopInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Submit a provisiong configuration for a given project.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     $provisioningConfig = new ProvisioningConfig();
     *     $response = $bareMetalSolutionClient->submitProvisioningConfig($formattedParent, $provisioningConfig);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string             $parent             Required. The parent project and location containing the
     *                                               ProvisioningConfig.
     * @param ProvisioningConfig $provisioningConfig Required. The ProvisioningConfig to create.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type string $email
     *           Optional. Email provided to send a confirmation with provisioning config
     *           to.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\SubmitProvisioningConfigResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function submitProvisioningConfig(
        $parent,
        $provisioningConfig,
        array $optionalArgs = []
    ) {
        $request = new SubmitProvisioningConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setProvisioningConfig($provisioningConfig);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['email'])) {
            $request->setEmail($optionalArgs['email']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SubmitProvisioningConfig',
            SubmitProvisioningConfigResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Update details of a single server.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $instance = new Instance();
     *     $operationResponse = $bareMetalSolutionClient->updateInstance($instance);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->updateInstance($instance);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'updateInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param Instance $instance     Required. The server to update.
     *
     *                               The `name` field is used to identify the instance to update.
     *                               Format: projects/{project}/locations/{location}/instances/{instance}
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to update.
     *           The currently supported fields are:
     *           `labels`
     *           `hyperthreading_enabled`
     *           `os_image`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateInstance($instance, array $optionalArgs = [])
    {
        $request = new UpdateInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $requestParamHeaders['instance.name'] = $instance->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update details of a single network.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $network = new Network();
     *     $operationResponse = $bareMetalSolutionClient->updateNetwork($network);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->updateNetwork($network);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'updateNetwork');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param Network $network      Required. The network to update.
     *
     *                              The `name` field is used to identify the instance to update.
     *                              Format: projects/{project}/locations/{location}/networks/{network}
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to update.
     *           The only currently supported fields are:
     *           `labels`, `reservations`, `vrf.vlan_attachments`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateNetwork($network, array $optionalArgs = [])
    {
        $request = new UpdateNetworkRequest();
        $requestParamHeaders = [];
        $request->setNetwork($network);
        $requestParamHeaders['network.name'] = $network->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateNetwork',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update details of a single NFS share.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $nfsShare = new NfsShare();
     *     $operationResponse = $bareMetalSolutionClient->updateNfsShare($nfsShare);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->updateNfsShare($nfsShare);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'updateNfsShare');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param NfsShare $nfsShare     Required. The NFS share to update.
     *
     *                               The `name` field is used to identify the NFS share to update.
     *                               Format: projects/{project}/locations/{location}/nfsShares/{nfs_share}
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to update.
     *           The only currently supported fields are:
     *           `labels`
     *           `allowed_clients`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateNfsShare($nfsShare, array $optionalArgs = [])
    {
        $request = new UpdateNfsShareRequest();
        $requestParamHeaders = [];
        $request->setNfsShare($nfsShare);
        $requestParamHeaders['nfs_share.name'] = $nfsShare->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateNfsShare',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update existing ProvisioningConfig.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $provisioningConfig = new ProvisioningConfig();
     *     $updateMask = new FieldMask();
     *     $response = $bareMetalSolutionClient->updateProvisioningConfig($provisioningConfig, $updateMask);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param ProvisioningConfig $provisioningConfig Required. The ProvisioningConfig to update.
     * @param FieldMask          $updateMask         Required. The list of fields to update.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type string $email
     *           Optional. Email provided to send a confirmation with provisioning config
     *           to.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BareMetalSolution\V2\ProvisioningConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateProvisioningConfig(
        $provisioningConfig,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateProvisioningConfigRequest();
        $requestParamHeaders = [];
        $request->setProvisioningConfig($provisioningConfig);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'provisioning_config.name'
        ] = $provisioningConfig->getName();
        if (isset($optionalArgs['email'])) {
            $request->setEmail($optionalArgs['email']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateProvisioningConfig',
            ProvisioningConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Update details of a single storage volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $volume = new Volume();
     *     $operationResponse = $bareMetalSolutionClient->updateVolume($volume);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->updateVolume($volume);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'updateVolume');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param Volume $volume       Required. The volume to update.
     *
     *                             The `name` field is used to identify the volume to update.
     *                             Format: projects/{project}/locations/{location}/volumes/{volume}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to update.
     *           The only currently supported fields are:
     *           'labels'
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateVolume($volume, array $optionalArgs = [])
    {
        $request = new UpdateVolumeRequest();
        $requestParamHeaders = [];
        $request->setVolume($volume);
        $requestParamHeaders['volume.name'] = $volume->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateVolume',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $response = $bareMetalSolutionClient->getLocation();
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
