<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/batch/v1/volume.proto

namespace Google\Cloud\Batch\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Volume describes a volume and parameters for it to be mounted to a VM.
 *
 * Generated from protobuf message <code>google.cloud.batch.v1.Volume</code>
 */
class Volume extends \Google\Protobuf\Internal\Message
{
    /**
     * The mount path for the volume, e.g. /mnt/disks/share.
     *
     * Generated from protobuf field <code>string mount_path = 4;</code>
     */
    private $mount_path = '';
    /**
     * For Google Cloud Storage (GCS), mount options are the options supported by
     * the gcsfuse tool (https://github.com/GoogleCloudPlatform/gcsfuse).
     * For existing persistent disks, mount options provided by the
     * mount command (https://man7.org/linux/man-pages/man8/mount.8.html) except
     * writing are supported. This is due to restrictions of multi-writer mode
     * (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * For other attached disks and Network File System (NFS), mount options are
     * these supported by the mount command
     * (https://man7.org/linux/man-pages/man8/mount.8.html).
     *
     * Generated from protobuf field <code>repeated string mount_options = 5;</code>
     */
    private $mount_options;
    protected $source;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Batch\V1\NFS $nfs
     *           A Network File System (NFS) volume. For example, a
     *           Filestore file share.
     *     @type \Google\Cloud\Batch\V1\GCS $gcs
     *           A Google Cloud Storage (GCS) volume.
     *     @type string $device_name
     *           Device name of an attached disk volume, which should align with a
     *           device_name specified by
     *           job.allocation_policy.instances[0].policy.disks[i].device_name or
     *           defined by the given instance template in
     *           job.allocation_policy.instances[0].instance_template.
     *     @type string $mount_path
     *           The mount path for the volume, e.g. /mnt/disks/share.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $mount_options
     *           For Google Cloud Storage (GCS), mount options are the options supported by
     *           the gcsfuse tool (https://github.com/GoogleCloudPlatform/gcsfuse).
     *           For existing persistent disks, mount options provided by the
     *           mount command (https://man7.org/linux/man-pages/man8/mount.8.html) except
     *           writing are supported. This is due to restrictions of multi-writer mode
     *           (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     *           For other attached disks and Network File System (NFS), mount options are
     *           these supported by the mount command
     *           (https://man7.org/linux/man-pages/man8/mount.8.html).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Batch\V1\Volume::initOnce();
        parent::__construct($data);
    }

    /**
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     * @return \Google\Cloud\Batch\V1\NFS|null
     */
    public function getNfs()
    {
        return $this->readOneof(1);
    }

    public function hasNfs()
    {
        return $this->hasOneof(1);
    }

    /**
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     * @param \Google\Cloud\Batch\V1\NFS $var
     * @return $this
     */
    public function setNfs($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\NFS::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * A Google Cloud Storage (GCS) volume.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     * @return \Google\Cloud\Batch\V1\GCS|null
     */
    public function getGcs()
    {
        return $this->readOneof(3);
    }

    public function hasGcs()
    {
        return $this->hasOneof(3);
    }

    /**
     * A Google Cloud Storage (GCS) volume.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     * @param \Google\Cloud\Batch\V1\GCS $var
     * @return $this
     */
    public function setGcs($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\GCS::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Device name of an attached disk volume, which should align with a
     * device_name specified by
     * job.allocation_policy.instances[0].policy.disks[i].device_name or
     * defined by the given instance template in
     * job.allocation_policy.instances[0].instance_template.
     *
     * Generated from protobuf field <code>string device_name = 6;</code>
     * @return string
     */
    public function getDeviceName()
    {
        return $this->readOneof(6);
    }

    public function hasDeviceName()
    {
        return $this->hasOneof(6);
    }

    /**
     * Device name of an attached disk volume, which should align with a
     * device_name specified by
     * job.allocation_policy.instances[0].policy.disks[i].device_name or
     * defined by the given instance template in
     * job.allocation_policy.instances[0].instance_template.
     *
     * Generated from protobuf field <code>string device_name = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDeviceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * The mount path for the volume, e.g. /mnt/disks/share.
     *
     * Generated from protobuf field <code>string mount_path = 4;</code>
     * @return string
     */
    public function getMountPath()
    {
        return $this->mount_path;
    }

    /**
     * The mount path for the volume, e.g. /mnt/disks/share.
     *
     * Generated from protobuf field <code>string mount_path = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setMountPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->mount_path = $var;

        return $this;
    }

    /**
     * For Google Cloud Storage (GCS), mount options are the options supported by
     * the gcsfuse tool (https://github.com/GoogleCloudPlatform/gcsfuse).
     * For existing persistent disks, mount options provided by the
     * mount command (https://man7.org/linux/man-pages/man8/mount.8.html) except
     * writing are supported. This is due to restrictions of multi-writer mode
     * (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * For other attached disks and Network File System (NFS), mount options are
     * these supported by the mount command
     * (https://man7.org/linux/man-pages/man8/mount.8.html).
     *
     * Generated from protobuf field <code>repeated string mount_options = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMountOptions()
    {
        return $this->mount_options;
    }

    /**
     * For Google Cloud Storage (GCS), mount options are the options supported by
     * the gcsfuse tool (https://github.com/GoogleCloudPlatform/gcsfuse).
     * For existing persistent disks, mount options provided by the
     * mount command (https://man7.org/linux/man-pages/man8/mount.8.html) except
     * writing are supported. This is due to restrictions of multi-writer mode
     * (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * For other attached disks and Network File System (NFS), mount options are
     * these supported by the mount command
     * (https://man7.org/linux/man-pages/man8/mount.8.html).
     *
     * Generated from protobuf field <code>repeated string mount_options = 5;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMountOptions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->mount_options = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

}

