<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/connection/v1/connection.proto

namespace Google\Cloud\BigQuery\Connection\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Connection properties specific to Cloud Spanner.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.connection.v1.CloudSpannerProperties</code>
 */
class CloudSpannerProperties extends \Google\Protobuf\Internal\Message
{
    /**
     * Cloud Spanner database in the form `project/instance/database'
     *
     * Generated from protobuf field <code>string database = 1;</code>
     */
    private $database = '';
    /**
     * If parallelism should be used when reading from Cloud Spanner
     *
     * Generated from protobuf field <code>bool use_parallelism = 2;</code>
     */
    private $use_parallelism = false;
    /**
     * Allows setting max parallelism per query when executing on Spanner
     * independent compute resources. If unspecified, default values of
     * parallelism are chosen that are dependent on the Cloud Spanner instance
     * configuration.
     * REQUIRES: `use_parallelism` must be set.
     * REQUIRES: Either `use_data_boost` or `use_serverless_analytics` must be
     * set.
     *
     * Generated from protobuf field <code>int32 max_parallelism = 5;</code>
     */
    private $max_parallelism = 0;
    /**
     * If the serverless analytics service should be used to read data from Cloud
     * Spanner.
     * Note: `use_parallelism` must be set when using serverless analytics.
     *
     * Generated from protobuf field <code>bool use_serverless_analytics = 3;</code>
     */
    private $use_serverless_analytics = false;
    /**
     * If set, the request will be executed via Spanner independent compute
     * resources.
     * REQUIRES: `use_parallelism` must be set.
     * NOTE: `use_serverless_analytics` will be deprecated. Prefer
     * `use_data_boost` over `use_serverless_analytics`.
     *
     * Generated from protobuf field <code>bool use_data_boost = 6;</code>
     */
    private $use_data_boost = false;
    /**
     * Optional. Cloud Spanner database role for fine-grained access control.
     * The Cloud Spanner admin should have provisioned the database role with
     * appropriate permissions, such as `SELECT` and `INSERT`. Other users should
     * only use roles provided by their Cloud Spanner admins.
     * For more details, see [About fine-grained access control]
     * (https://cloud.google.com/spanner/docs/fgac-about).
     * REQUIRES: The database role name must start with a letter, and can only
     * contain letters, numbers, and underscores.
     *
     * Generated from protobuf field <code>string database_role = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $database_role = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $database
     *           Cloud Spanner database in the form `project/instance/database'
     *     @type bool $use_parallelism
     *           If parallelism should be used when reading from Cloud Spanner
     *     @type int $max_parallelism
     *           Allows setting max parallelism per query when executing on Spanner
     *           independent compute resources. If unspecified, default values of
     *           parallelism are chosen that are dependent on the Cloud Spanner instance
     *           configuration.
     *           REQUIRES: `use_parallelism` must be set.
     *           REQUIRES: Either `use_data_boost` or `use_serverless_analytics` must be
     *           set.
     *     @type bool $use_serverless_analytics
     *           If the serverless analytics service should be used to read data from Cloud
     *           Spanner.
     *           Note: `use_parallelism` must be set when using serverless analytics.
     *     @type bool $use_data_boost
     *           If set, the request will be executed via Spanner independent compute
     *           resources.
     *           REQUIRES: `use_parallelism` must be set.
     *           NOTE: `use_serverless_analytics` will be deprecated. Prefer
     *           `use_data_boost` over `use_serverless_analytics`.
     *     @type string $database_role
     *           Optional. Cloud Spanner database role for fine-grained access control.
     *           The Cloud Spanner admin should have provisioned the database role with
     *           appropriate permissions, such as `SELECT` and `INSERT`. Other users should
     *           only use roles provided by their Cloud Spanner admins.
     *           For more details, see [About fine-grained access control]
     *           (https://cloud.google.com/spanner/docs/fgac-about).
     *           REQUIRES: The database role name must start with a letter, and can only
     *           contain letters, numbers, and underscores.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Connection\V1\Connection::initOnce();
        parent::__construct($data);
    }

    /**
     * Cloud Spanner database in the form `project/instance/database'
     *
     * Generated from protobuf field <code>string database = 1;</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Cloud Spanner database in the form `project/instance/database'
     *
     * Generated from protobuf field <code>string database = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * If parallelism should be used when reading from Cloud Spanner
     *
     * Generated from protobuf field <code>bool use_parallelism = 2;</code>
     * @return bool
     */
    public function getUseParallelism()
    {
        return $this->use_parallelism;
    }

    /**
     * If parallelism should be used when reading from Cloud Spanner
     *
     * Generated from protobuf field <code>bool use_parallelism = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseParallelism($var)
    {
        GPBUtil::checkBool($var);
        $this->use_parallelism = $var;

        return $this;
    }

    /**
     * Allows setting max parallelism per query when executing on Spanner
     * independent compute resources. If unspecified, default values of
     * parallelism are chosen that are dependent on the Cloud Spanner instance
     * configuration.
     * REQUIRES: `use_parallelism` must be set.
     * REQUIRES: Either `use_data_boost` or `use_serverless_analytics` must be
     * set.
     *
     * Generated from protobuf field <code>int32 max_parallelism = 5;</code>
     * @return int
     */
    public function getMaxParallelism()
    {
        return $this->max_parallelism;
    }

    /**
     * Allows setting max parallelism per query when executing on Spanner
     * independent compute resources. If unspecified, default values of
     * parallelism are chosen that are dependent on the Cloud Spanner instance
     * configuration.
     * REQUIRES: `use_parallelism` must be set.
     * REQUIRES: Either `use_data_boost` or `use_serverless_analytics` must be
     * set.
     *
     * Generated from protobuf field <code>int32 max_parallelism = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxParallelism($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_parallelism = $var;

        return $this;
    }

    /**
     * If the serverless analytics service should be used to read data from Cloud
     * Spanner.
     * Note: `use_parallelism` must be set when using serverless analytics.
     *
     * Generated from protobuf field <code>bool use_serverless_analytics = 3;</code>
     * @return bool
     */
    public function getUseServerlessAnalytics()
    {
        return $this->use_serverless_analytics;
    }

    /**
     * If the serverless analytics service should be used to read data from Cloud
     * Spanner.
     * Note: `use_parallelism` must be set when using serverless analytics.
     *
     * Generated from protobuf field <code>bool use_serverless_analytics = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseServerlessAnalytics($var)
    {
        GPBUtil::checkBool($var);
        $this->use_serverless_analytics = $var;

        return $this;
    }

    /**
     * If set, the request will be executed via Spanner independent compute
     * resources.
     * REQUIRES: `use_parallelism` must be set.
     * NOTE: `use_serverless_analytics` will be deprecated. Prefer
     * `use_data_boost` over `use_serverless_analytics`.
     *
     * Generated from protobuf field <code>bool use_data_boost = 6;</code>
     * @return bool
     */
    public function getUseDataBoost()
    {
        return $this->use_data_boost;
    }

    /**
     * If set, the request will be executed via Spanner independent compute
     * resources.
     * REQUIRES: `use_parallelism` must be set.
     * NOTE: `use_serverless_analytics` will be deprecated. Prefer
     * `use_data_boost` over `use_serverless_analytics`.
     *
     * Generated from protobuf field <code>bool use_data_boost = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseDataBoost($var)
    {
        GPBUtil::checkBool($var);
        $this->use_data_boost = $var;

        return $this;
    }

    /**
     * Optional. Cloud Spanner database role for fine-grained access control.
     * The Cloud Spanner admin should have provisioned the database role with
     * appropriate permissions, such as `SELECT` and `INSERT`. Other users should
     * only use roles provided by their Cloud Spanner admins.
     * For more details, see [About fine-grained access control]
     * (https://cloud.google.com/spanner/docs/fgac-about).
     * REQUIRES: The database role name must start with a letter, and can only
     * contain letters, numbers, and underscores.
     *
     * Generated from protobuf field <code>string database_role = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDatabaseRole()
    {
        return $this->database_role;
    }

    /**
     * Optional. Cloud Spanner database role for fine-grained access control.
     * The Cloud Spanner admin should have provisioned the database role with
     * appropriate permissions, such as `SELECT` and `INSERT`. Other users should
     * only use roles provided by their Cloud Spanner admins.
     * For more details, see [About fine-grained access control]
     * (https://cloud.google.com/spanner/docs/fgac-about).
     * REQUIRES: The database role name must start with a letter, and can only
     * contain letters, numbers, and underscores.
     *
     * Generated from protobuf field <code>string database_role = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabaseRole($var)
    {
        GPBUtil::checkString($var, True);
        $this->database_role = $var;

        return $this;
    }

}

