<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/storage/v1/storage.proto

namespace Google\Cloud\BigQuery\Storage\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for `CreateReadSession`.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.storage.v1.CreateReadSessionRequest</code>
 */
class CreateReadSessionRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The request project that owns the session, in the form of
     * `projects/{project_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. Session to be created.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ReadSession read_session = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $read_session = null;
    /**
     * Max initial number of streams. If unset or zero, the server will
     * provide a value of streams so as to produce reasonable throughput. Must be
     * non-negative. The number of streams may be lower than the requested number,
     * depending on the amount parallelism that is reasonable for the table.
     * There is a default system max limit of 1,000.
     * This must be greater than or equal to preferred_min_stream_count.
     * Typically, clients should either leave this unset to let the system to
     * determine an upper bound OR set this a size for the maximum "units of work"
     * it can gracefully handle.
     *
     * Generated from protobuf field <code>int32 max_stream_count = 3;</code>
     */
    private $max_stream_count = 0;
    /**
     * The minimum preferred stream count. This parameter can be used to inform
     * the service that there is a desired lower bound on the number of streams.
     * This is typically a target parallelism of the client (e.g. a Spark
     * cluster with N-workers would set this to a low multiple of N to ensure
     * good cluster utilization).
     * The system will make a best effort to provide at least this number of
     * streams, but in some cases might provide less.
     *
     * Generated from protobuf field <code>int32 preferred_min_stream_count = 4;</code>
     */
    private $preferred_min_stream_count = 0;

    /**
     * @param string                                        $parent         Required. The request project that owns the session, in the form of
     *                                                                      `projects/{project_id}`. Please see
     *                                                                      {@see BigQueryReadClient::projectName()} for help formatting this field.
     * @param \Google\Cloud\BigQuery\Storage\V1\ReadSession $readSession    Required. Session to be created.
     * @param int                                           $maxStreamCount Max initial number of streams. If unset or zero, the server will
     *                                                                      provide a value of streams so as to produce reasonable throughput. Must be
     *                                                                      non-negative. The number of streams may be lower than the requested number,
     *                                                                      depending on the amount parallelism that is reasonable for the table.
     *                                                                      There is a default system max limit of 1,000.
     *
     *                                                                      This must be greater than or equal to preferred_min_stream_count.
     *                                                                      Typically, clients should either leave this unset to let the system to
     *                                                                      determine an upper bound OR set this a size for the maximum "units of work"
     *                                                                      it can gracefully handle.
     *
     * @return \Google\Cloud\BigQuery\Storage\V1\CreateReadSessionRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\BigQuery\Storage\V1\ReadSession $readSession, int $maxStreamCount): self
    {
        return (new self())
            ->setParent($parent)
            ->setReadSession($readSession)
            ->setMaxStreamCount($maxStreamCount);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The request project that owns the session, in the form of
     *           `projects/{project_id}`.
     *     @type \Google\Cloud\BigQuery\Storage\V1\ReadSession $read_session
     *           Required. Session to be created.
     *     @type int $max_stream_count
     *           Max initial number of streams. If unset or zero, the server will
     *           provide a value of streams so as to produce reasonable throughput. Must be
     *           non-negative. The number of streams may be lower than the requested number,
     *           depending on the amount parallelism that is reasonable for the table.
     *           There is a default system max limit of 1,000.
     *           This must be greater than or equal to preferred_min_stream_count.
     *           Typically, clients should either leave this unset to let the system to
     *           determine an upper bound OR set this a size for the maximum "units of work"
     *           it can gracefully handle.
     *     @type int $preferred_min_stream_count
     *           The minimum preferred stream count. This parameter can be used to inform
     *           the service that there is a desired lower bound on the number of streams.
     *           This is typically a target parallelism of the client (e.g. a Spark
     *           cluster with N-workers would set this to a low multiple of N to ensure
     *           good cluster utilization).
     *           The system will make a best effort to provide at least this number of
     *           streams, but in some cases might provide less.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Storage\V1\Storage::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The request project that owns the session, in the form of
     * `projects/{project_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The request project that owns the session, in the form of
     * `projects/{project_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. Session to be created.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ReadSession read_session = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\ReadSession|null
     */
    public function getReadSession()
    {
        return $this->read_session;
    }

    public function hasReadSession()
    {
        return isset($this->read_session);
    }

    public function clearReadSession()
    {
        unset($this->read_session);
    }

    /**
     * Required. Session to be created.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ReadSession read_session = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\ReadSession $var
     * @return $this
     */
    public function setReadSession($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\ReadSession::class);
        $this->read_session = $var;

        return $this;
    }

    /**
     * Max initial number of streams. If unset or zero, the server will
     * provide a value of streams so as to produce reasonable throughput. Must be
     * non-negative. The number of streams may be lower than the requested number,
     * depending on the amount parallelism that is reasonable for the table.
     * There is a default system max limit of 1,000.
     * This must be greater than or equal to preferred_min_stream_count.
     * Typically, clients should either leave this unset to let the system to
     * determine an upper bound OR set this a size for the maximum "units of work"
     * it can gracefully handle.
     *
     * Generated from protobuf field <code>int32 max_stream_count = 3;</code>
     * @return int
     */
    public function getMaxStreamCount()
    {
        return $this->max_stream_count;
    }

    /**
     * Max initial number of streams. If unset or zero, the server will
     * provide a value of streams so as to produce reasonable throughput. Must be
     * non-negative. The number of streams may be lower than the requested number,
     * depending on the amount parallelism that is reasonable for the table.
     * There is a default system max limit of 1,000.
     * This must be greater than or equal to preferred_min_stream_count.
     * Typically, clients should either leave this unset to let the system to
     * determine an upper bound OR set this a size for the maximum "units of work"
     * it can gracefully handle.
     *
     * Generated from protobuf field <code>int32 max_stream_count = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxStreamCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_stream_count = $var;

        return $this;
    }

    /**
     * The minimum preferred stream count. This parameter can be used to inform
     * the service that there is a desired lower bound on the number of streams.
     * This is typically a target parallelism of the client (e.g. a Spark
     * cluster with N-workers would set this to a low multiple of N to ensure
     * good cluster utilization).
     * The system will make a best effort to provide at least this number of
     * streams, but in some cases might provide less.
     *
     * Generated from protobuf field <code>int32 preferred_min_stream_count = 4;</code>
     * @return int
     */
    public function getPreferredMinStreamCount()
    {
        return $this->preferred_min_stream_count;
    }

    /**
     * The minimum preferred stream count. This parameter can be used to inform
     * the service that there is a desired lower bound on the number of streams.
     * This is typically a target parallelism of the client (e.g. a Spark
     * cluster with N-workers would set this to a low multiple of N to ensure
     * good cluster utilization).
     * The system will make a best effort to provide at least this number of
     * streams, but in some cases might provide less.
     *
     * Generated from protobuf field <code>int32 preferred_min_stream_count = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setPreferredMinStreamCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->preferred_min_stream_count = $var;

        return $this;
    }

}

