<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v1/cloudbuild.proto

namespace Google\Cloud\Build\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Artifacts produced by a build that should be uploaded upon
 * successful completion of all build steps.
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v1.Artifacts</code>
 */
class Artifacts extends \Google\Protobuf\Internal\Message
{
    /**
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated string images = 1;</code>
     */
    private $images;
    /**
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    private $objects = null;
    /**
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;</code>
     */
    private $maven_artifacts;
    /**
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * The build service account credentials will be used to perform the upload.
     * If any objects fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;</code>
     */
    private $python_packages;
    /**
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     * If any packages fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     */
    private $npm_packages;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $images
     *           A list of images to be pushed upon the successful completion of all build
     *           steps.
     *           The images will be pushed using the builder service account's credentials.
     *           The digests of the pushed images will be stored in the Build resource's
     *           results field.
     *           If any of the images fail to be pushed, the build is marked FAILURE.
     *     @type \Google\Cloud\Build\V1\Artifacts\ArtifactObjects $objects
     *           A list of objects to be uploaded to Cloud Storage upon successful
     *           completion of all build steps.
     *           Files in the workspace matching specified paths globs will be uploaded to
     *           the specified Cloud Storage location using the builder service account's
     *           credentials.
     *           The location and generation of the uploaded objects will be stored in the
     *           Build resource's results field.
     *           If any objects fail to be pushed, the build is marked FAILURE.
     *     @type array<\Google\Cloud\Build\V1\Artifacts\MavenArtifact>|\Google\Protobuf\Internal\RepeatedField $maven_artifacts
     *           A list of Maven artifacts to be uploaded to Artifact Registry upon
     *           successful completion of all build steps.
     *           Artifacts in the workspace matching specified paths globs will be uploaded
     *           to the specified Artifact Registry repository using the builder service
     *           account's credentials.
     *           If any artifacts fail to be pushed, the build is marked FAILURE.
     *     @type array<\Google\Cloud\Build\V1\Artifacts\PythonPackage>|\Google\Protobuf\Internal\RepeatedField $python_packages
     *           A list of Python packages to be uploaded to Artifact Registry upon
     *           successful completion of all build steps.
     *           The build service account credentials will be used to perform the upload.
     *           If any objects fail to be pushed, the build is marked FAILURE.
     *     @type array<\Google\Cloud\Build\V1\Artifacts\NpmPackage>|\Google\Protobuf\Internal\RepeatedField $npm_packages
     *           A list of npm packages to be uploaded to Artifact Registry upon
     *           successful completion of all build steps.
     *           Npm packages in the specified paths will be uploaded
     *           to the specified Artifact Registry repository using the builder service
     *           account's credentials.
     *           If any packages fail to be pushed, the build is marked FAILURE.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudbuild\V1\Cloudbuild::initOnce();
        parent::__construct($data);
    }

    /**
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated string images = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getImages()
    {
        return $this->images;
    }

    /**
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated string images = 1;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setImages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->images = $arr;

        return $this;
    }

    /**
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     * @return \Google\Cloud\Build\V1\Artifacts\ArtifactObjects|null
     */
    public function getObjects()
    {
        return $this->objects;
    }

    public function hasObjects()
    {
        return isset($this->objects);
    }

    public function clearObjects()
    {
        unset($this->objects);
    }

    /**
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     * @param \Google\Cloud\Build\V1\Artifacts\ArtifactObjects $var
     * @return $this
     */
    public function setObjects($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V1\Artifacts\ArtifactObjects::class);
        $this->objects = $var;

        return $this;
    }

    /**
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMavenArtifacts()
    {
        return $this->maven_artifacts;
    }

    /**
     * A list of Maven artifacts to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * Artifacts in the workspace matching specified paths globs will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     * If any artifacts fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.MavenArtifact maven_artifacts = 3;</code>
     * @param array<\Google\Cloud\Build\V1\Artifacts\MavenArtifact>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMavenArtifacts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Build\V1\Artifacts\MavenArtifact::class);
        $this->maven_artifacts = $arr;

        return $this;
    }

    /**
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * The build service account credentials will be used to perform the upload.
     * If any objects fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPythonPackages()
    {
        return $this->python_packages;
    }

    /**
     * A list of Python packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * The build service account credentials will be used to perform the upload.
     * If any objects fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.PythonPackage python_packages = 5;</code>
     * @param array<\Google\Cloud\Build\V1\Artifacts\PythonPackage>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPythonPackages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Build\V1\Artifacts\PythonPackage::class);
        $this->python_packages = $arr;

        return $this;
    }

    /**
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     * If any packages fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNpmPackages()
    {
        return $this->npm_packages;
    }

    /**
     * A list of npm packages to be uploaded to Artifact Registry upon
     * successful completion of all build steps.
     * Npm packages in the specified paths will be uploaded
     * to the specified Artifact Registry repository using the builder service
     * account's credentials.
     * If any packages fail to be pushed, the build is marked FAILURE.
     *
     * Generated from protobuf field <code>repeated .google.devtools.cloudbuild.v1.Artifacts.NpmPackage npm_packages = 6;</code>
     * @param array<\Google\Cloud\Build\V1\Artifacts\NpmPackage>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNpmPackages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Build\V1\Artifacts\NpmPackage::class);
        $this->npm_packages = $arr;

        return $this;
    }

}

