<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/compute/v1/compute.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Compute\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Compute\V1\AccessConfig;
use Google\Cloud\Compute\V1\AddAccessConfigInstanceRequest;
use Google\Cloud\Compute\V1\AddResourcePoliciesInstanceRequest;
use Google\Cloud\Compute\V1\AggregatedListInstancesRequest;
use Google\Cloud\Compute\V1\AttachDiskInstanceRequest;
use Google\Cloud\Compute\V1\AttachedDisk;
use Google\Cloud\Compute\V1\BulkInsertInstanceRequest;
use Google\Cloud\Compute\V1\BulkInsertInstanceResource;
use Google\Cloud\Compute\V1\DeleteAccessConfigInstanceRequest;
use Google\Cloud\Compute\V1\DeleteInstanceRequest;
use Google\Cloud\Compute\V1\DetachDiskInstanceRequest;
use Google\Cloud\Compute\V1\DisplayDevice;
use Google\Cloud\Compute\V1\GetEffectiveFirewallsInstanceRequest;
use Google\Cloud\Compute\V1\GetGuestAttributesInstanceRequest;
use Google\Cloud\Compute\V1\GetIamPolicyInstanceRequest;
use Google\Cloud\Compute\V1\GetInstanceRequest;
use Google\Cloud\Compute\V1\GetScreenshotInstanceRequest;
use Google\Cloud\Compute\V1\GetSerialPortOutputInstanceRequest;
use Google\Cloud\Compute\V1\GetShieldedInstanceIdentityInstanceRequest;
use Google\Cloud\Compute\V1\GuestAttributes;
use Google\Cloud\Compute\V1\InsertInstanceRequest;
use Google\Cloud\Compute\V1\Instance;
use Google\Cloud\Compute\V1\InstanceAggregatedList;
use Google\Cloud\Compute\V1\InstanceList;
use Google\Cloud\Compute\V1\InstanceListReferrers;
use Google\Cloud\Compute\V1\InstancesAddResourcePoliciesRequest;
use Google\Cloud\Compute\V1\InstancesGetEffectiveFirewallsResponse;
use Google\Cloud\Compute\V1\InstancesRemoveResourcePoliciesRequest;
use Google\Cloud\Compute\V1\InstancesSetLabelsRequest;
use Google\Cloud\Compute\V1\InstancesSetMachineResourcesRequest;
use Google\Cloud\Compute\V1\InstancesSetMachineTypeRequest;
use Google\Cloud\Compute\V1\InstancesSetMinCpuPlatformRequest;
use Google\Cloud\Compute\V1\InstancesSetNameRequest;
use Google\Cloud\Compute\V1\InstancesSetServiceAccountRequest;
use Google\Cloud\Compute\V1\InstancesStartWithEncryptionKeyRequest;
use Google\Cloud\Compute\V1\ListInstancesRequest;
use Google\Cloud\Compute\V1\ListReferrersInstancesRequest;
use Google\Cloud\Compute\V1\Metadata;
use Google\Cloud\Compute\V1\NetworkInterface;
use Google\Cloud\Compute\V1\Operation;
use Google\Cloud\Compute\V1\Policy;
use Google\Cloud\Compute\V1\RemoveResourcePoliciesInstanceRequest;
use Google\Cloud\Compute\V1\ResetInstanceRequest;
use Google\Cloud\Compute\V1\ResumeInstanceRequest;
use Google\Cloud\Compute\V1\Scheduling;
use Google\Cloud\Compute\V1\Screenshot;
use Google\Cloud\Compute\V1\SendDiagnosticInterruptInstanceRequest;
use Google\Cloud\Compute\V1\SendDiagnosticInterruptInstanceResponse;
use Google\Cloud\Compute\V1\SerialPortOutput;
use Google\Cloud\Compute\V1\SetDeletionProtectionInstanceRequest;
use Google\Cloud\Compute\V1\SetDiskAutoDeleteInstanceRequest;
use Google\Cloud\Compute\V1\SetIamPolicyInstanceRequest;
use Google\Cloud\Compute\V1\SetLabelsInstanceRequest;
use Google\Cloud\Compute\V1\SetMachineResourcesInstanceRequest;
use Google\Cloud\Compute\V1\SetMachineTypeInstanceRequest;
use Google\Cloud\Compute\V1\SetMetadataInstanceRequest;
use Google\Cloud\Compute\V1\SetMinCpuPlatformInstanceRequest;
use Google\Cloud\Compute\V1\SetNameInstanceRequest;
use Google\Cloud\Compute\V1\SetSchedulingInstanceRequest;
use Google\Cloud\Compute\V1\SetServiceAccountInstanceRequest;
use Google\Cloud\Compute\V1\SetShieldedInstanceIntegrityPolicyInstanceRequest;
use Google\Cloud\Compute\V1\SetTagsInstanceRequest;
use Google\Cloud\Compute\V1\ShieldedInstanceConfig;
use Google\Cloud\Compute\V1\ShieldedInstanceIdentity;
use Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy;
use Google\Cloud\Compute\V1\SimulateMaintenanceEventInstanceRequest;
use Google\Cloud\Compute\V1\StartInstanceRequest;
use Google\Cloud\Compute\V1\StartWithEncryptionKeyInstanceRequest;
use Google\Cloud\Compute\V1\StopInstanceRequest;
use Google\Cloud\Compute\V1\SuspendInstanceRequest;
use Google\Cloud\Compute\V1\Tags;
use Google\Cloud\Compute\V1\TestIamPermissionsInstanceRequest;
use Google\Cloud\Compute\V1\TestPermissionsRequest;
use Google\Cloud\Compute\V1\TestPermissionsResponse;
use Google\Cloud\Compute\V1\UpdateAccessConfigInstanceRequest;
use Google\Cloud\Compute\V1\UpdateDisplayDeviceInstanceRequest;
use Google\Cloud\Compute\V1\UpdateInstanceRequest;
use Google\Cloud\Compute\V1\UpdateNetworkInterfaceInstanceRequest;
use Google\Cloud\Compute\V1\UpdateShieldedInstanceConfigInstanceRequest;
use Google\Cloud\Compute\V1\ZoneOperationsClient;
use Google\Cloud\Compute\V1\ZoneSetPolicyRequest;

/**
 * Service Description: The Instances API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $instancesClient = new InstancesClient();
 * try {
 *     $accessConfigResource = new AccessConfig();
 *     $instance = 'instance';
 *     $networkInterface = 'network_interface';
 *     $project = 'project';
 *     $zone = 'zone';
 *     $operationResponse = $instancesClient->addAccessConfig($accessConfigResource, $instance, $networkInterface, $project, $zone);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         // if creating/modifying, retrieve the target resource
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $instancesClient->addAccessConfig($accessConfigResource, $instance, $networkInterface, $project, $zone);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'addAccessConfig');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         // if creating/modifying, retrieve the target resource
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $instancesClient->close();
 * }
 * ```
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Compute\V1\Client\InstancesClient} to use the new surface.
 */
class InstancesGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.compute.v1.Instances';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'compute.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/compute',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/instances_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/instances_descriptor_config.php',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
                'useJwtAccessWithScope' => false,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/instances_rest_client_config.php',
                ],
            ],
            'operationsClientClass' => ZoneOperationsClient::class,
        ];
    }

    /** Implements GapicClientTrait::defaultTransport. */
    private static function defaultTransport()
    {
        return 'rest';
    }

    /** Implements GapicClientTrait::getSupportedTransports. */
    private static function getSupportedTransports()
    {
        return [
            'rest',
        ];
    }

    /**
     * Return an ZoneOperationsClient object with the same endpoint as $this.
     *
     * @return ZoneOperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /** Return the default longrunning operation descriptor config. */
    private function getDefaultOperationDescriptor()
    {
        return [
            'additionalArgumentMethods' => [
                'getProject',
                'getZone',
            ],
            'getOperationMethod' => 'get',
            'cancelOperationMethod' => null,
            'deleteOperationMethod' => 'delete',
            'operationErrorCodeMethod' => 'getHttpErrorStatusCode',
            'operationErrorMessageMethod' => 'getHttpErrorMessage',
            'operationNameMethod' => 'getName',
            'operationStatusMethod' => 'getStatus',
            'operationStatusDoneValue' => \Google\Cloud\Compute\V1\Operation\Status::DONE,
        ];
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : $this->getDefaultOperationDescriptor();
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'compute.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. At the moment, supports only
     *           `rest`. *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\RestTransport::build()} method for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Adds an access config to an instance's network interface.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $accessConfigResource = new AccessConfig();
     *     $instance = 'instance';
     *     $networkInterface = 'network_interface';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->addAccessConfig($accessConfigResource, $instance, $networkInterface, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->addAccessConfig($accessConfigResource, $instance, $networkInterface, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'addAccessConfig');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param AccessConfig $accessConfigResource The body resource for this request
     * @param string       $instance             The instance name for this request.
     * @param string       $networkInterface     The name of the network interface to add to this instance.
     * @param string       $project              Project ID for this request.
     * @param string       $zone                 The name of the zone for this request.
     * @param array        $optionalArgs         {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function addAccessConfig($accessConfigResource, $instance, $networkInterface, $project, $zone, array $optionalArgs = [])
    {
        $request = new AddAccessConfigInstanceRequest();
        $requestParamHeaders = [];
        $request->setAccessConfigResource($accessConfigResource);
        $request->setInstance($instance);
        $request->setNetworkInterface($networkInterface);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('AddAccessConfig', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Adds existing resource policies to an instance. You can only add one policy right now which will be applied to this instance for scheduling live migrations.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesAddResourcePoliciesRequestResource = new InstancesAddResourcePoliciesRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->addResourcePolicies($instance, $instancesAddResourcePoliciesRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->addResourcePolicies($instance, $instancesAddResourcePoliciesRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'addResourcePolicies');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                              $instance                                    The instance name for this request.
     * @param InstancesAddResourcePoliciesRequest $instancesAddResourcePoliciesRequestResource The body resource for this request
     * @param string                              $project                                     Project ID for this request.
     * @param string                              $zone                                        The name of the zone for this request.
     * @param array                               $optionalArgs                                {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function addResourcePolicies($instance, $instancesAddResourcePoliciesRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new AddResourcePoliciesInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesAddResourcePoliciesRequestResource($instancesAddResourcePoliciesRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('AddResourcePolicies', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Retrieves an aggregated list of all of the instances in your project across all regions and zones. The performance of this method degrades when a filter is specified on a project that has a very large number of instances.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $project = 'project';
     *     // Iterate over pages of elements
     *     $pagedResponse = $instancesClient->aggregatedList($project);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $key => $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $instancesClient->aggregatedList($project);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $project      Project ID for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
     *     @type bool $includeAllScopes
     *           Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
     *     @type int $maxResults
     *           The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type bool $returnPartialSuccess
     *           Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function aggregatedList($project, array $optionalArgs = [])
    {
        $request = new AggregatedListInstancesRequest();
        $requestParamHeaders = [];
        $request->setProject($project);
        $requestParamHeaders['project'] = $project;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['includeAllScopes'])) {
            $request->setIncludeAllScopes($optionalArgs['includeAllScopes']);
        }

        if (isset($optionalArgs['maxResults'])) {
            $request->setMaxResults($optionalArgs['maxResults']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['returnPartialSuccess'])) {
            $request->setReturnPartialSuccess($optionalArgs['returnPartialSuccess']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('AggregatedList', $optionalArgs, InstanceAggregatedList::class, $request);
    }

    /**
     * Attaches an existing Disk resource to an instance. You must first create the disk before you can attach it. It is not possible to create and attach a disk at the same time. For more information, read Adding a persistent disk to your instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $attachedDiskResource = new AttachedDisk();
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->attachDisk($attachedDiskResource, $instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->attachDisk($attachedDiskResource, $instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'attachDisk');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param AttachedDisk $attachedDiskResource The body resource for this request
     * @param string       $instance             The instance name for this request.
     * @param string       $project              Project ID for this request.
     * @param string       $zone                 The name of the zone for this request.
     * @param array        $optionalArgs         {
     *     Optional.
     *
     *     @type bool $forceAttach
     *           Whether to force attach the regional disk even if it's currently attached to another instance. If you try to force attach a zonal disk to an instance, you will receive an error.
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function attachDisk($attachedDiskResource, $instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new AttachDiskInstanceRequest();
        $requestParamHeaders = [];
        $request->setAttachedDiskResource($attachedDiskResource);
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['forceAttach'])) {
            $request->setForceAttach($optionalArgs['forceAttach']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('AttachDisk', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Creates multiple instances. Count specifies the number of instances to create. For more information, see About bulk creation of VMs.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $bulkInsertInstanceResourceResource = new BulkInsertInstanceResource();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->bulkInsert($bulkInsertInstanceResourceResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->bulkInsert($bulkInsertInstanceResourceResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'bulkInsert');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param BulkInsertInstanceResource $bulkInsertInstanceResourceResource The body resource for this request
     * @param string                     $project                            Project ID for this request.
     * @param string                     $zone                               The name of the zone for this request.
     * @param array                      $optionalArgs                       {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function bulkInsert($bulkInsertInstanceResourceResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new BulkInsertInstanceRequest();
        $requestParamHeaders = [];
        $request->setBulkInsertInstanceResourceResource($bulkInsertInstanceResourceResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('BulkInsert', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Deletes the specified Instance resource. For more information, see Deleting an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->delete($instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->delete($instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'delete');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance resource to delete.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function delete($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new DeleteInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('Delete', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Deletes an access config from an instance's network interface.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $accessConfig = 'access_config';
     *     $instance = 'instance';
     *     $networkInterface = 'network_interface';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->deleteAccessConfig($accessConfig, $instance, $networkInterface, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->deleteAccessConfig($accessConfig, $instance, $networkInterface, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'deleteAccessConfig');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $accessConfig     The name of the access config to delete.
     * @param string $instance         The instance name for this request.
     * @param string $networkInterface The name of the network interface.
     * @param string $project          Project ID for this request.
     * @param string $zone             The name of the zone for this request.
     * @param array  $optionalArgs     {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAccessConfig($accessConfig, $instance, $networkInterface, $project, $zone, array $optionalArgs = [])
    {
        $request = new DeleteAccessConfigInstanceRequest();
        $requestParamHeaders = [];
        $request->setAccessConfig($accessConfig);
        $request->setInstance($instance);
        $request->setNetworkInterface($networkInterface);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteAccessConfig', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Detaches a disk from an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $deviceName = 'device_name';
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->detachDisk($deviceName, $instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->detachDisk($deviceName, $instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'detachDisk');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $deviceName   The device name of the disk to detach. Make a get() request on the instance to view currently attached disks and device names.
     * @param string $instance     Instance name for this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function detachDisk($deviceName, $instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new DetachDiskInstanceRequest();
        $requestParamHeaders = [];
        $request->setDeviceName($deviceName);
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DetachDisk', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Returns the specified Instance resource.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $response = $instancesClient->get($instance, $project, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance resource to return.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\Instance
     *
     * @throws ApiException if the remote call fails
     */
    public function get($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new GetInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('Get', Instance::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns effective firewalls applied to an interface of the instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $networkInterface = 'network_interface';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $response = $instancesClient->getEffectiveFirewalls($instance, $networkInterface, $project, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance         Name of the instance scoping this request.
     * @param string $networkInterface The name of the network interface to get the effective firewalls.
     * @param string $project          Project ID for this request.
     * @param string $zone             The name of the zone for this request.
     * @param array  $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\InstancesGetEffectiveFirewallsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function getEffectiveFirewalls($instance, $networkInterface, $project, $zone, array $optionalArgs = [])
    {
        $request = new GetEffectiveFirewallsInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setNetworkInterface($networkInterface);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEffectiveFirewalls', InstancesGetEffectiveFirewallsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the specified guest attributes entry.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $response = $instancesClient->getGuestAttributes($instance, $project, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance scoping this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $queryPath
     *           Specifies the guest attributes path to be queried.
     *     @type string $variableKey
     *           Specifies the key for the guest attributes entry.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\GuestAttributes
     *
     * @throws ApiException if the remote call fails
     */
    public function getGuestAttributes($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new GetGuestAttributesInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['queryPath'])) {
            $request->setQueryPath($optionalArgs['queryPath']);
        }

        if (isset($optionalArgs['variableKey'])) {
            $request->setVariableKey($optionalArgs['variableKey']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetGuestAttributes', GuestAttributes::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the access control policy for a resource. May be empty if no such policy or resource exists.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $project = 'project';
     *     $resource = 'resource';
     *     $zone = 'zone';
     *     $response = $instancesClient->getIamPolicy($project, $resource, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $project      Project ID for this request.
     * @param string $resource     Name or id of the resource for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $optionsRequestedPolicyVersion
     *           Requested IAM Policy version.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($project, $resource, $zone, array $optionalArgs = [])
    {
        $request = new GetIamPolicyInstanceRequest();
        $requestParamHeaders = [];
        $request->setProject($project);
        $request->setResource($resource);
        $request->setZone($zone);
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['resource'] = $resource;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['optionsRequestedPolicyVersion'])) {
            $request->setOptionsRequestedPolicyVersion($optionalArgs['optionsRequestedPolicyVersion']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetIamPolicy', Policy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the screenshot from the specified instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $response = $instancesClient->getScreenshot($instance, $project, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance scoping this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\Screenshot
     *
     * @throws ApiException if the remote call fails
     */
    public function getScreenshot($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new GetScreenshotInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetScreenshot', Screenshot::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the last 1 MB of serial port output from the specified instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $response = $instancesClient->getSerialPortOutput($instance, $project, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance for this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $port
     *           Specifies which COM or serial port to retrieve data from.
     *     @type int $start
     *           Specifies the starting byte position of the output to return. To start with the first byte of output to the specified port, omit this field or set it to `0`. If the output for that byte position is available, this field matches the `start` parameter sent with the request. If the amount of serial console output exceeds the size of the buffer (1 MB), the oldest output is discarded and is no longer available. If the requested start position refers to discarded output, the start position is adjusted to the oldest output still available, and the adjusted start position is returned as the `start` property value. You can also provide a negative start position, which translates to the most recent number of bytes written to the serial port. For example, -3 is interpreted as the most recent 3 bytes written to the serial console.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\SerialPortOutput
     *
     * @throws ApiException if the remote call fails
     */
    public function getSerialPortOutput($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new GetSerialPortOutputInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['port'])) {
            $request->setPort($optionalArgs['port']);
        }

        if (isset($optionalArgs['start'])) {
            $request->setStart($optionalArgs['start']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSerialPortOutput', SerialPortOutput::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns the Shielded Instance Identity of an instance
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $response = $instancesClient->getShieldedInstanceIdentity($instance, $project, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name or id of the instance scoping this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\ShieldedInstanceIdentity
     *
     * @throws ApiException if the remote call fails
     */
    public function getShieldedInstanceIdentity($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new GetShieldedInstanceIdentityInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetShieldedInstanceIdentity', ShieldedInstanceIdentity::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an instance resource in the specified project using the data included in the request.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instanceResource = new Instance();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->insert($instanceResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->insert($instanceResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'insert');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param Instance $instanceResource The body resource for this request
     * @param string   $project          Project ID for this request.
     * @param string   $zone             The name of the zone for this request.
     * @param array    $optionalArgs     {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type string $sourceInstanceTemplate
     *           Specifies instance template to create the instance. This field is optional. It can be a full or partial URL. For example, the following are all valid URLs to an instance template: - https://www.googleapis.com/compute/v1/projects/project /global/instanceTemplates/instanceTemplate - projects/project/global/instanceTemplates/instanceTemplate - global/instanceTemplates/instanceTemplate
     *     @type string $sourceMachineImage
     *           Specifies the machine image to use to create the instance. This field is optional. It can be a full or partial URL. For example, the following are all valid URLs to a machine image: - https://www.googleapis.com/compute/v1/projects/project/global/global /machineImages/machineImage - projects/project/global/global/machineImages/machineImage - global/machineImages/machineImage
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function insert($instanceResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new InsertInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstanceResource($instanceResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['sourceInstanceTemplate'])) {
            $request->setSourceInstanceTemplate($optionalArgs['sourceInstanceTemplate']);
        }

        if (isset($optionalArgs['sourceMachineImage'])) {
            $request->setSourceMachineImage($optionalArgs['sourceMachineImage']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('Insert', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Retrieves the list of instances contained within the specified zone.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $project = 'project';
     *     $zone = 'zone';
     *     // Iterate over pages of elements
     *     $pagedResponse = $instancesClient->list($project, $zone);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $instancesClient->list($project, $zone);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
     *     @type int $maxResults
     *           The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type bool $returnPartialSuccess
     *           Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function list($project, $zone, array $optionalArgs = [])
    {
        $request = new ListInstancesRequest();
        $requestParamHeaders = [];
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['maxResults'])) {
            $request->setMaxResults($optionalArgs['maxResults']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['returnPartialSuccess'])) {
            $request->setReturnPartialSuccess($optionalArgs['returnPartialSuccess']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('List', $optionalArgs, InstanceList::class, $request);
    }

    /**
     * Retrieves a list of resources that refer to the VM instance specified in the request. For example, if the VM instance is part of a managed or unmanaged instance group, the referrers list includes the instance group. For more information, read Viewing referrers to VM instances.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     // Iterate over pages of elements
     *     $pagedResponse = $instancesClient->listReferrers($instance, $project, $zone);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $instancesClient->listReferrers($instance, $project, $zone);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the target instance scoping this request, or '-' if the request should span over all instances in the container.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
     *     @type int $maxResults
     *           The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type bool $returnPartialSuccess
     *           Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listReferrers($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new ListReferrersInstancesRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['maxResults'])) {
            $request->setMaxResults($optionalArgs['maxResults']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['returnPartialSuccess'])) {
            $request->setReturnPartialSuccess($optionalArgs['returnPartialSuccess']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListReferrers', $optionalArgs, InstanceListReferrers::class, $request);
    }

    /**
     * Removes resource policies from an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesRemoveResourcePoliciesRequestResource = new InstancesRemoveResourcePoliciesRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->removeResourcePolicies($instance, $instancesRemoveResourcePoliciesRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->removeResourcePolicies($instance, $instancesRemoveResourcePoliciesRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'removeResourcePolicies');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                                 $instance                                       The instance name for this request.
     * @param InstancesRemoveResourcePoliciesRequest $instancesRemoveResourcePoliciesRequestResource The body resource for this request
     * @param string                                 $project                                        Project ID for this request.
     * @param string                                 $zone                                           The name of the zone for this request.
     * @param array                                  $optionalArgs                                   {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function removeResourcePolicies($instance, $instancesRemoveResourcePoliciesRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new RemoveResourcePoliciesInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesRemoveResourcePoliciesRequestResource($instancesRemoveResourcePoliciesRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RemoveResourcePolicies', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Performs a reset on the instance. This is a hard reset. The VM does not do a graceful shutdown. For more information, see Resetting an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->reset($instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->reset($instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'reset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance scoping this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function reset($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new ResetInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('Reset', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Resumes an instance that was suspended using the instances().suspend method.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->resume($instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->resume($instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'resume');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance resource to resume.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resume($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new ResumeInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('Resume', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sends diagnostic interrupt to the instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $response = $instancesClient->sendDiagnosticInterrupt($instance, $project, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance scoping this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\SendDiagnosticInterruptInstanceResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function sendDiagnosticInterrupt($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new SendDiagnosticInterruptInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SendDiagnosticInterrupt', SendDiagnosticInterruptInstanceResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Sets deletion protection on the instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $project = 'project';
     *     $resource = 'resource';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setDeletionProtection($project, $resource, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setDeletionProtection($project, $resource, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setDeletionProtection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $project      Project ID for this request.
     * @param string $resource     Name or id of the resource for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $deletionProtection
     *           Whether the resource should be protected against deletion.
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setDeletionProtection($project, $resource, $zone, array $optionalArgs = [])
    {
        $request = new SetDeletionProtectionInstanceRequest();
        $requestParamHeaders = [];
        $request->setProject($project);
        $request->setResource($resource);
        $request->setZone($zone);
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['resource'] = $resource;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['deletionProtection'])) {
            $request->setDeletionProtection($optionalArgs['deletionProtection']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetDeletionProtection', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sets the auto-delete flag for a disk attached to an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $autoDelete = false;
     *     $deviceName = 'device_name';
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setDiskAutoDelete($autoDelete, $deviceName, $instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setDiskAutoDelete($autoDelete, $deviceName, $instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setDiskAutoDelete');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param bool   $autoDelete   Whether to auto-delete the disk when the instance is deleted.
     * @param string $deviceName   The device name of the disk to modify. Make a get() request on the instance to view currently attached disks and device names.
     * @param string $instance     The instance name for this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setDiskAutoDelete($autoDelete, $deviceName, $instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new SetDiskAutoDeleteInstanceRequest();
        $requestParamHeaders = [];
        $request->setAutoDelete($autoDelete);
        $request->setDeviceName($deviceName);
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetDiskAutoDelete', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $project = 'project';
     *     $resource = 'resource';
     *     $zone = 'zone';
     *     $zoneSetPolicyRequestResource = new ZoneSetPolicyRequest();
     *     $response = $instancesClient->setIamPolicy($project, $resource, $zone, $zoneSetPolicyRequestResource);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string               $project                      Project ID for this request.
     * @param string               $resource                     Name or id of the resource for this request.
     * @param string               $zone                         The name of the zone for this request.
     * @param ZoneSetPolicyRequest $zoneSetPolicyRequestResource The body resource for this request
     * @param array                $optionalArgs                 {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($project, $resource, $zone, $zoneSetPolicyRequestResource, array $optionalArgs = [])
    {
        $request = new SetIamPolicyInstanceRequest();
        $requestParamHeaders = [];
        $request->setProject($project);
        $request->setResource($resource);
        $request->setZone($zone);
        $request->setZoneSetPolicyRequestResource($zoneSetPolicyRequestResource);
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['resource'] = $resource;
        $requestParamHeaders['zone'] = $zone;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SetIamPolicy', Policy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Sets labels on an instance. To learn more about labels, read the Labeling Resources documentation.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesSetLabelsRequestResource = new InstancesSetLabelsRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setLabels($instance, $instancesSetLabelsRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setLabels($instance, $instancesSetLabelsRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setLabels');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                    $instance                          Name of the instance scoping this request.
     * @param InstancesSetLabelsRequest $instancesSetLabelsRequestResource The body resource for this request
     * @param string                    $project                           Project ID for this request.
     * @param string                    $zone                              The name of the zone for this request.
     * @param array                     $optionalArgs                      {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setLabels($instance, $instancesSetLabelsRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new SetLabelsInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesSetLabelsRequestResource($instancesSetLabelsRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetLabels', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Changes the number and/or type of accelerator for a stopped instance to the values specified in the request.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesSetMachineResourcesRequestResource = new InstancesSetMachineResourcesRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setMachineResources($instance, $instancesSetMachineResourcesRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setMachineResources($instance, $instancesSetMachineResourcesRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setMachineResources');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                              $instance                                    Name of the instance scoping this request.
     * @param InstancesSetMachineResourcesRequest $instancesSetMachineResourcesRequestResource The body resource for this request
     * @param string                              $project                                     Project ID for this request.
     * @param string                              $zone                                        The name of the zone for this request.
     * @param array                               $optionalArgs                                {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setMachineResources($instance, $instancesSetMachineResourcesRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new SetMachineResourcesInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesSetMachineResourcesRequestResource($instancesSetMachineResourcesRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetMachineResources', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Changes the machine type for a stopped instance to the machine type specified in the request.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesSetMachineTypeRequestResource = new InstancesSetMachineTypeRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setMachineType($instance, $instancesSetMachineTypeRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setMachineType($instance, $instancesSetMachineTypeRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setMachineType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                         $instance                               Name of the instance scoping this request.
     * @param InstancesSetMachineTypeRequest $instancesSetMachineTypeRequestResource The body resource for this request
     * @param string                         $project                                Project ID for this request.
     * @param string                         $zone                                   The name of the zone for this request.
     * @param array                          $optionalArgs                           {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setMachineType($instance, $instancesSetMachineTypeRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new SetMachineTypeInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesSetMachineTypeRequestResource($instancesSetMachineTypeRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetMachineType', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sets metadata for the specified instance to the data included in the request.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $metadataResource = new Metadata();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setMetadata($instance, $metadataResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setMetadata($instance, $metadataResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setMetadata');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string   $instance         Name of the instance scoping this request.
     * @param Metadata $metadataResource The body resource for this request
     * @param string   $project          Project ID for this request.
     * @param string   $zone             The name of the zone for this request.
     * @param array    $optionalArgs     {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setMetadata($instance, $metadataResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new SetMetadataInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setMetadataResource($metadataResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetMetadata', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Changes the minimum CPU platform that this instance should use. This method can only be called on a stopped instance. For more information, read Specifying a Minimum CPU Platform.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesSetMinCpuPlatformRequestResource = new InstancesSetMinCpuPlatformRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setMinCpuPlatform($instance, $instancesSetMinCpuPlatformRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setMinCpuPlatform($instance, $instancesSetMinCpuPlatformRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setMinCpuPlatform');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                            $instance                                  Name of the instance scoping this request.
     * @param InstancesSetMinCpuPlatformRequest $instancesSetMinCpuPlatformRequestResource The body resource for this request
     * @param string                            $project                                   Project ID for this request.
     * @param string                            $zone                                      The name of the zone for this request.
     * @param array                             $optionalArgs                              {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setMinCpuPlatform($instance, $instancesSetMinCpuPlatformRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new SetMinCpuPlatformInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesSetMinCpuPlatformRequestResource($instancesSetMinCpuPlatformRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetMinCpuPlatform', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sets name of an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesSetNameRequestResource = new InstancesSetNameRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setName($instance, $instancesSetNameRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setName($instance, $instancesSetNameRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setName');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                  $instance                        The instance name for this request.
     * @param InstancesSetNameRequest $instancesSetNameRequestResource The body resource for this request
     * @param string                  $project                         Project ID for this request.
     * @param string                  $zone                            The name of the zone for this request.
     * @param array                   $optionalArgs                    {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setName($instance, $instancesSetNameRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new SetNameInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesSetNameRequestResource($instancesSetNameRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetName', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sets an instance's scheduling options. You can only call this method on a stopped instance, that is, a VM instance that is in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states. For more information about setting scheduling options for a VM, see Set VM host maintenance policy.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $schedulingResource = new Scheduling();
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setScheduling($instance, $project, $schedulingResource, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setScheduling($instance, $project, $schedulingResource, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setScheduling');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string     $instance           Instance name for this request.
     * @param string     $project            Project ID for this request.
     * @param Scheduling $schedulingResource The body resource for this request
     * @param string     $zone               The name of the zone for this request.
     * @param array      $optionalArgs       {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setScheduling($instance, $project, $schedulingResource, $zone, array $optionalArgs = [])
    {
        $request = new SetSchedulingInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setSchedulingResource($schedulingResource);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetScheduling', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sets the service account on the instance. For more information, read Changing the service account and access scopes for an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesSetServiceAccountRequestResource = new InstancesSetServiceAccountRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setServiceAccount($instance, $instancesSetServiceAccountRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setServiceAccount($instance, $instancesSetServiceAccountRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setServiceAccount');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                            $instance                                  Name of the instance resource to start.
     * @param InstancesSetServiceAccountRequest $instancesSetServiceAccountRequestResource The body resource for this request
     * @param string                            $project                                   Project ID for this request.
     * @param string                            $zone                                      The name of the zone for this request.
     * @param array                             $optionalArgs                              {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setServiceAccount($instance, $instancesSetServiceAccountRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new SetServiceAccountInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesSetServiceAccountRequestResource($instancesSetServiceAccountRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetServiceAccount', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sets the Shielded Instance integrity policy for an instance. You can only use this method on a running instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $shieldedInstanceIntegrityPolicyResource = new ShieldedInstanceIntegrityPolicy();
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setShieldedInstanceIntegrityPolicy($instance, $project, $shieldedInstanceIntegrityPolicyResource, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setShieldedInstanceIntegrityPolicy($instance, $project, $shieldedInstanceIntegrityPolicyResource, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setShieldedInstanceIntegrityPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                          $instance                                Name or id of the instance scoping this request.
     * @param string                          $project                                 Project ID for this request.
     * @param ShieldedInstanceIntegrityPolicy $shieldedInstanceIntegrityPolicyResource The body resource for this request
     * @param string                          $zone                                    The name of the zone for this request.
     * @param array                           $optionalArgs                            {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setShieldedInstanceIntegrityPolicy($instance, $project, $shieldedInstanceIntegrityPolicyResource, $zone, array $optionalArgs = [])
    {
        $request = new SetShieldedInstanceIntegrityPolicyInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setShieldedInstanceIntegrityPolicyResource($shieldedInstanceIntegrityPolicyResource);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetShieldedInstanceIntegrityPolicy', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Sets network tags for the specified instance to the data included in the request.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $tagsResource = new Tags();
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->setTags($instance, $project, $tagsResource, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->setTags($instance, $project, $tagsResource, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'setTags');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance scoping this request.
     * @param string $project      Project ID for this request.
     * @param Tags   $tagsResource The body resource for this request
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function setTags($instance, $project, $tagsResource, $zone, array $optionalArgs = [])
    {
        $request = new SetTagsInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setTagsResource($tagsResource);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SetTags', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Simulates a host maintenance event on a VM. For more information, see Simulate a host maintenance event.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->simulateMaintenanceEvent($instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->simulateMaintenanceEvent($instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'simulateMaintenanceEvent');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance scoping this request.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function simulateMaintenanceEvent($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new SimulateMaintenanceEventInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SimulateMaintenanceEvent', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->start($instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->start($instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'start');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance resource to start.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function start($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new StartInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('Start', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instancesStartWithEncryptionKeyRequestResource = new InstancesStartWithEncryptionKeyRequest();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->startWithEncryptionKey($instance, $instancesStartWithEncryptionKeyRequestResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->startWithEncryptionKey($instance, $instancesStartWithEncryptionKeyRequestResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'startWithEncryptionKey');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                                 $instance                                       Name of the instance resource to start.
     * @param InstancesStartWithEncryptionKeyRequest $instancesStartWithEncryptionKeyRequestResource The body resource for this request
     * @param string                                 $project                                        Project ID for this request.
     * @param string                                 $zone                                           The name of the zone for this request.
     * @param array                                  $optionalArgs                                   {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startWithEncryptionKey($instance, $instancesStartWithEncryptionKeyRequestResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new StartWithEncryptionKeyInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstancesStartWithEncryptionKeyRequestResource($instancesStartWithEncryptionKeyRequestResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('StartWithEncryptionKey', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time. Stopped instances do not incur VM usage charges while they are stopped. However, resources that the VM is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted. For more information, see Stopping an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->stop($instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->stop($instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'stop');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance resource to stop.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $discardLocalSsd
     *           If true, discard the contents of any attached localSSD partitions. Default value is false.
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function stop($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new StopInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['discardLocalSsd'])) {
            $request->setDiscardLocalSsd($optionalArgs['discardLocalSsd']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('Stop', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * This method suspends a running instance, saving its state to persistent storage, and allows you to resume the instance at a later time. Suspended instances have no compute costs (cores or RAM), and incur only storage charges for the saved VM memory and localSSD data. Any charged resources the virtual machine was using, such as persistent disks and static IP addresses, will continue to be charged while the instance is suspended. For more information, see Suspending and resuming an instance.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->suspend($instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->suspend($instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'suspend');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string $instance     Name of the instance resource to suspend.
     * @param string $project      Project ID for this request.
     * @param string $zone         The name of the zone for this request.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $discardLocalSsd
     *           If true, discard the contents of any attached localSSD partitions. Default value is false.
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function suspend($instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new SuspendInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['discardLocalSsd'])) {
            $request->setDiscardLocalSsd($optionalArgs['discardLocalSsd']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('Suspend', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $project = 'project';
     *     $resource = 'resource';
     *     $testPermissionsRequestResource = new TestPermissionsRequest();
     *     $zone = 'zone';
     *     $response = $instancesClient->testIamPermissions($project, $resource, $testPermissionsRequestResource, $zone);
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                 $project                        Project ID for this request.
     * @param string                 $resource                       Name or id of the resource for this request.
     * @param TestPermissionsRequest $testPermissionsRequestResource The body resource for this request
     * @param string                 $zone                           The name of the zone for this request.
     * @param array                  $optionalArgs                   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Compute\V1\TestPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions($project, $resource, $testPermissionsRequestResource, $zone, array $optionalArgs = [])
    {
        $request = new TestIamPermissionsInstanceRequest();
        $requestParamHeaders = [];
        $request->setProject($project);
        $request->setResource($resource);
        $request->setTestPermissionsRequestResource($testPermissionsRequestResource);
        $request->setZone($zone);
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['resource'] = $resource;
        $requestParamHeaders['zone'] = $zone;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('TestIamPermissions', TestPermissionsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an instance only if the necessary resources are available. This method can update only a specific set of instance properties. See Updating a running instance for a list of updatable instance properties.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $instanceResource = new Instance();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->update($instance, $instanceResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->update($instance, $instanceResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'update');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string   $instance         Name of the instance resource to update.
     * @param Instance $instanceResource The body resource for this request
     * @param string   $project          Project ID for this request.
     * @param string   $zone             The name of the zone for this request.
     * @param array    $optionalArgs     {
     *     Optional.
     *
     *     @type string $minimalAction
     *           Specifies the action to take when updating an instance even if the updated properties do not require it. If not specified, then Compute Engine acts based on the minimum action that the updated properties require.
     *           Check the MinimalAction enum for the list of possible values.
     *     @type string $mostDisruptiveAllowedAction
     *           Specifies the most disruptive action that can be taken on the instance as part of the update. Compute Engine returns an error if the instance properties require a more disruptive action as part of the instance update. Valid options from lowest to highest are NO_EFFECT, REFRESH, and RESTART.
     *           Check the MostDisruptiveAllowedAction enum for the list of possible values.
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function update($instance, $instanceResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new UpdateInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setInstanceResource($instanceResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['minimalAction'])) {
            $request->setMinimalAction($optionalArgs['minimalAction']);
        }

        if (isset($optionalArgs['mostDisruptiveAllowedAction'])) {
            $request->setMostDisruptiveAllowedAction($optionalArgs['mostDisruptiveAllowedAction']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('Update', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Updates the specified access config from an instance's network interface with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $accessConfigResource = new AccessConfig();
     *     $instance = 'instance';
     *     $networkInterface = 'network_interface';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->updateAccessConfig($accessConfigResource, $instance, $networkInterface, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->updateAccessConfig($accessConfigResource, $instance, $networkInterface, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'updateAccessConfig');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param AccessConfig $accessConfigResource The body resource for this request
     * @param string       $instance             The instance name for this request.
     * @param string       $networkInterface     The name of the network interface where the access config is attached.
     * @param string       $project              Project ID for this request.
     * @param string       $zone                 The name of the zone for this request.
     * @param array        $optionalArgs         {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAccessConfig($accessConfigResource, $instance, $networkInterface, $project, $zone, array $optionalArgs = [])
    {
        $request = new UpdateAccessConfigInstanceRequest();
        $requestParamHeaders = [];
        $request->setAccessConfigResource($accessConfigResource);
        $request->setInstance($instance);
        $request->setNetworkInterface($networkInterface);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateAccessConfig', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Updates the Display config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $displayDeviceResource = new DisplayDevice();
     *     $instance = 'instance';
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->updateDisplayDevice($displayDeviceResource, $instance, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->updateDisplayDevice($displayDeviceResource, $instance, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'updateDisplayDevice');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param DisplayDevice $displayDeviceResource The body resource for this request
     * @param string        $instance              Name of the instance scoping this request.
     * @param string        $project               Project ID for this request.
     * @param string        $zone                  The name of the zone for this request.
     * @param array         $optionalArgs          {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDisplayDevice($displayDeviceResource, $instance, $project, $zone, array $optionalArgs = [])
    {
        $request = new UpdateDisplayDeviceInstanceRequest();
        $requestParamHeaders = [];
        $request->setDisplayDeviceResource($displayDeviceResource);
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateDisplayDevice', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Updates an instance's network interface. This method can only update an interface's alias IP range and attached network. See Modifying alias IP ranges for an existing instance for instructions on changing alias IP ranges. See Migrating a VM between networks for instructions on migrating an interface. This method follows PATCH semantics.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $networkInterface = 'network_interface';
     *     $networkInterfaceResource = new NetworkInterface();
     *     $project = 'project';
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->updateNetworkInterface($instance, $networkInterface, $networkInterfaceResource, $project, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->updateNetworkInterface($instance, $networkInterface, $networkInterfaceResource, $project, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'updateNetworkInterface');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string           $instance                 The instance name for this request.
     * @param string           $networkInterface         The name of the network interface to update.
     * @param NetworkInterface $networkInterfaceResource The body resource for this request
     * @param string           $project                  Project ID for this request.
     * @param string           $zone                     The name of the zone for this request.
     * @param array            $optionalArgs             {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateNetworkInterface($instance, $networkInterface, $networkInterfaceResource, $project, $zone, array $optionalArgs = [])
    {
        $request = new UpdateNetworkInterfaceInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setNetworkInterface($networkInterface);
        $request->setNetworkInterfaceResource($networkInterfaceResource);
        $request->setProject($project);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateNetworkInterface', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }

    /**
     * Updates the Shielded Instance config for an instance. You can only use this method on a stopped instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Sample code:
     * ```
     * $instancesClient = new InstancesClient();
     * try {
     *     $instance = 'instance';
     *     $project = 'project';
     *     $shieldedInstanceConfigResource = new ShieldedInstanceConfig();
     *     $zone = 'zone';
     *     $operationResponse = $instancesClient->updateShieldedInstanceConfig($instance, $project, $shieldedInstanceConfigResource, $zone);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $instancesClient->updateShieldedInstanceConfig($instance, $project, $shieldedInstanceConfigResource, $zone);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $instancesClient->resumeOperation($operationName, 'updateShieldedInstanceConfig');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // if creating/modifying, retrieve the target resource
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $instancesClient->close();
     * }
     * ```
     *
     * @param string                 $instance                       Name or id of the instance scoping this request.
     * @param string                 $project                        Project ID for this request.
     * @param ShieldedInstanceConfig $shieldedInstanceConfigResource The body resource for this request
     * @param string                 $zone                           The name of the zone for this request.
     * @param array                  $optionalArgs                   {
     *     Optional.
     *
     *     @type string $requestId
     *           An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateShieldedInstanceConfig($instance, $project, $shieldedInstanceConfigResource, $zone, array $optionalArgs = [])
    {
        $request = new UpdateShieldedInstanceConfigInstanceRequest();
        $requestParamHeaders = [];
        $request->setInstance($instance);
        $request->setProject($project);
        $request->setShieldedInstanceConfigResource($shieldedInstanceConfigResource);
        $request->setZone($zone);
        $requestParamHeaders['instance'] = $instance;
        $requestParamHeaders['project'] = $project;
        $requestParamHeaders['zone'] = $zone;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateShieldedInstanceConfig', $optionalArgs, $request, $this->getOperationsClient(), null, Operation::class)->wait();
    }
}
