<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * GPUSharingConfig represents the GPU sharing configuration for Hardware
 * Accelerators.
 *
 * Generated from protobuf message <code>google.container.v1.GPUSharingConfig</code>
 */
class GPUSharingConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The max number of containers that can share a physical GPU.
     *
     * Generated from protobuf field <code>int64 max_shared_clients_per_gpu = 1;</code>
     */
    private $max_shared_clients_per_gpu = 0;
    /**
     * The type of GPU sharing strategy to enable on the GPU node.
     *
     * Generated from protobuf field <code>optional .google.container.v1.GPUSharingConfig.GPUSharingStrategy gpu_sharing_strategy = 2;</code>
     */
    private $gpu_sharing_strategy = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $max_shared_clients_per_gpu
     *           The max number of containers that can share a physical GPU.
     *     @type int $gpu_sharing_strategy
     *           The type of GPU sharing strategy to enable on the GPU node.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The max number of containers that can share a physical GPU.
     *
     * Generated from protobuf field <code>int64 max_shared_clients_per_gpu = 1;</code>
     * @return int|string
     */
    public function getMaxSharedClientsPerGpu()
    {
        return $this->max_shared_clients_per_gpu;
    }

    /**
     * The max number of containers that can share a physical GPU.
     *
     * Generated from protobuf field <code>int64 max_shared_clients_per_gpu = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMaxSharedClientsPerGpu($var)
    {
        GPBUtil::checkInt64($var);
        $this->max_shared_clients_per_gpu = $var;

        return $this;
    }

    /**
     * The type of GPU sharing strategy to enable on the GPU node.
     *
     * Generated from protobuf field <code>optional .google.container.v1.GPUSharingConfig.GPUSharingStrategy gpu_sharing_strategy = 2;</code>
     * @return int
     */
    public function getGpuSharingStrategy()
    {
        return isset($this->gpu_sharing_strategy) ? $this->gpu_sharing_strategy : 0;
    }

    public function hasGpuSharingStrategy()
    {
        return isset($this->gpu_sharing_strategy);
    }

    public function clearGpuSharingStrategy()
    {
        unset($this->gpu_sharing_strategy);
    }

    /**
     * The type of GPU sharing strategy to enable on the GPU node.
     *
     * Generated from protobuf field <code>optional .google.container.v1.GPUSharingConfig.GPUSharingStrategy gpu_sharing_strategy = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setGpuSharingStrategy($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\GPUSharingConfig\GPUSharingStrategy::class);
        $this->gpu_sharing_strategy = $var;

        return $this;
    }

}

