<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/resources.proto

namespace Google\Cloud\Dataplex\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Action represents an issue requiring administrator action for resolution.
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.Action</code>
 */
class Action extends \Google\Protobuf\Internal\Message
{
    /**
     * The category of issue associated with the action.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.Category category = 1;</code>
     */
    private $category = 0;
    /**
     * Detailed description of the issue requiring action.
     *
     * Generated from protobuf field <code>string issue = 2;</code>
     */
    private $issue = '';
    /**
     * The time that the issue was detected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp detect_time = 4;</code>
     */
    private $detect_time = null;
    /**
     * Output only. The relative resource name of the action, of the form:
     * `projects/{project}/locations/{location}/lakes/{lake}/actions/{action}`
     * `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/{action}`
     * `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}/actions/{action}`.
     *
     * Generated from protobuf field <code>string name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $name = '';
    /**
     * Output only. The relative resource name of the lake, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     *
     * Generated from protobuf field <code>string lake = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $lake = '';
    /**
     * Output only. The relative resource name of the zone, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     *
     * Generated from protobuf field <code>string zone = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $zone = '';
    /**
     * Output only. The relative resource name of the asset, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
     *
     * Generated from protobuf field <code>string asset = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $asset = '';
    /**
     * The list of data locations associated with this action. Cloud Storage
     * locations are represented as URI paths(E.g.
     * `gs://bucket/table1/year=2020/month=Jan/`). BigQuery locations refer to
     * resource names(E.g.
     * `bigquery.googleapis.com/projects/project-id/datasets/dataset-id`).
     *
     * Generated from protobuf field <code>repeated string data_locations = 9;</code>
     */
    private $data_locations;
    protected $details;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $category
     *           The category of issue associated with the action.
     *     @type string $issue
     *           Detailed description of the issue requiring action.
     *     @type \Google\Protobuf\Timestamp $detect_time
     *           The time that the issue was detected.
     *     @type string $name
     *           Output only. The relative resource name of the action, of the form:
     *           `projects/{project}/locations/{location}/lakes/{lake}/actions/{action}`
     *           `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/{action}`
     *           `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}/actions/{action}`.
     *     @type string $lake
     *           Output only. The relative resource name of the lake, of the form:
     *           `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     *     @type string $zone
     *           Output only. The relative resource name of the zone, of the form:
     *           `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     *     @type string $asset
     *           Output only. The relative resource name of the asset, of the form:
     *           `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $data_locations
     *           The list of data locations associated with this action. Cloud Storage
     *           locations are represented as URI paths(E.g.
     *           `gs://bucket/table1/year=2020/month=Jan/`). BigQuery locations refer to
     *           resource names(E.g.
     *           `bigquery.googleapis.com/projects/project-id/datasets/dataset-id`).
     *     @type \Google\Cloud\Dataplex\V1\Action\InvalidDataFormat $invalid_data_format
     *           Details for issues related to invalid or unsupported data formats.
     *     @type \Google\Cloud\Dataplex\V1\Action\IncompatibleDataSchema $incompatible_data_schema
     *           Details for issues related to incompatible schemas detected within data.
     *     @type \Google\Cloud\Dataplex\V1\Action\InvalidDataPartition $invalid_data_partition
     *           Details for issues related to invalid or unsupported data partition
     *           structure.
     *     @type \Google\Cloud\Dataplex\V1\Action\MissingData $missing_data
     *           Details for issues related to absence of data within managed resources.
     *     @type \Google\Cloud\Dataplex\V1\Action\MissingResource $missing_resource
     *           Details for issues related to absence of a managed resource.
     *     @type \Google\Cloud\Dataplex\V1\Action\UnauthorizedResource $unauthorized_resource
     *           Details for issues related to lack of permissions to access data
     *           resources.
     *     @type \Google\Cloud\Dataplex\V1\Action\FailedSecurityPolicyApply $failed_security_policy_apply
     *           Details for issues related to applying security policy.
     *     @type \Google\Cloud\Dataplex\V1\Action\InvalidDataOrganization $invalid_data_organization
     *           Details for issues related to invalid data arrangement.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The category of issue associated with the action.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.Category category = 1;</code>
     * @return int
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * The category of issue associated with the action.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.Category category = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setCategory($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataplex\V1\Action\Category::class);
        $this->category = $var;

        return $this;
    }

    /**
     * Detailed description of the issue requiring action.
     *
     * Generated from protobuf field <code>string issue = 2;</code>
     * @return string
     */
    public function getIssue()
    {
        return $this->issue;
    }

    /**
     * Detailed description of the issue requiring action.
     *
     * Generated from protobuf field <code>string issue = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setIssue($var)
    {
        GPBUtil::checkString($var, True);
        $this->issue = $var;

        return $this;
    }

    /**
     * The time that the issue was detected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp detect_time = 4;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDetectTime()
    {
        return $this->detect_time;
    }

    public function hasDetectTime()
    {
        return isset($this->detect_time);
    }

    public function clearDetectTime()
    {
        unset($this->detect_time);
    }

    /**
     * The time that the issue was detected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp detect_time = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDetectTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->detect_time = $var;

        return $this;
    }

    /**
     * Output only. The relative resource name of the action, of the form:
     * `projects/{project}/locations/{location}/lakes/{lake}/actions/{action}`
     * `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/{action}`
     * `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}/actions/{action}`.
     *
     * Generated from protobuf field <code>string name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The relative resource name of the action, of the form:
     * `projects/{project}/locations/{location}/lakes/{lake}/actions/{action}`
     * `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/{action}`
     * `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}/actions/{action}`.
     *
     * Generated from protobuf field <code>string name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The relative resource name of the lake, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     *
     * Generated from protobuf field <code>string lake = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getLake()
    {
        return $this->lake;
    }

    /**
     * Output only. The relative resource name of the lake, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     *
     * Generated from protobuf field <code>string lake = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setLake($var)
    {
        GPBUtil::checkString($var, True);
        $this->lake = $var;

        return $this;
    }

    /**
     * Output only. The relative resource name of the zone, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     *
     * Generated from protobuf field <code>string zone = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * Output only. The relative resource name of the zone, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
     *
     * Generated from protobuf field <code>string zone = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

    /**
     * Output only. The relative resource name of the asset, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
     *
     * Generated from protobuf field <code>string asset = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAsset()
    {
        return $this->asset;
    }

    /**
     * Output only. The relative resource name of the asset, of the form:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
     *
     * Generated from protobuf field <code>string asset = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAsset($var)
    {
        GPBUtil::checkString($var, True);
        $this->asset = $var;

        return $this;
    }

    /**
     * The list of data locations associated with this action. Cloud Storage
     * locations are represented as URI paths(E.g.
     * `gs://bucket/table1/year=2020/month=Jan/`). BigQuery locations refer to
     * resource names(E.g.
     * `bigquery.googleapis.com/projects/project-id/datasets/dataset-id`).
     *
     * Generated from protobuf field <code>repeated string data_locations = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDataLocations()
    {
        return $this->data_locations;
    }

    /**
     * The list of data locations associated with this action. Cloud Storage
     * locations are represented as URI paths(E.g.
     * `gs://bucket/table1/year=2020/month=Jan/`). BigQuery locations refer to
     * resource names(E.g.
     * `bigquery.googleapis.com/projects/project-id/datasets/dataset-id`).
     *
     * Generated from protobuf field <code>repeated string data_locations = 9;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDataLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->data_locations = $arr;

        return $this;
    }

    /**
     * Details for issues related to invalid or unsupported data formats.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.InvalidDataFormat invalid_data_format = 10;</code>
     * @return \Google\Cloud\Dataplex\V1\Action\InvalidDataFormat|null
     */
    public function getInvalidDataFormat()
    {
        return $this->readOneof(10);
    }

    public function hasInvalidDataFormat()
    {
        return $this->hasOneof(10);
    }

    /**
     * Details for issues related to invalid or unsupported data formats.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.InvalidDataFormat invalid_data_format = 10;</code>
     * @param \Google\Cloud\Dataplex\V1\Action\InvalidDataFormat $var
     * @return $this
     */
    public function setInvalidDataFormat($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Action\InvalidDataFormat::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Details for issues related to incompatible schemas detected within data.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.IncompatibleDataSchema incompatible_data_schema = 11;</code>
     * @return \Google\Cloud\Dataplex\V1\Action\IncompatibleDataSchema|null
     */
    public function getIncompatibleDataSchema()
    {
        return $this->readOneof(11);
    }

    public function hasIncompatibleDataSchema()
    {
        return $this->hasOneof(11);
    }

    /**
     * Details for issues related to incompatible schemas detected within data.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.IncompatibleDataSchema incompatible_data_schema = 11;</code>
     * @param \Google\Cloud\Dataplex\V1\Action\IncompatibleDataSchema $var
     * @return $this
     */
    public function setIncompatibleDataSchema($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Action\IncompatibleDataSchema::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Details for issues related to invalid or unsupported data partition
     * structure.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.InvalidDataPartition invalid_data_partition = 12;</code>
     * @return \Google\Cloud\Dataplex\V1\Action\InvalidDataPartition|null
     */
    public function getInvalidDataPartition()
    {
        return $this->readOneof(12);
    }

    public function hasInvalidDataPartition()
    {
        return $this->hasOneof(12);
    }

    /**
     * Details for issues related to invalid or unsupported data partition
     * structure.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.InvalidDataPartition invalid_data_partition = 12;</code>
     * @param \Google\Cloud\Dataplex\V1\Action\InvalidDataPartition $var
     * @return $this
     */
    public function setInvalidDataPartition($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Action\InvalidDataPartition::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Details for issues related to absence of data within managed resources.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.MissingData missing_data = 13;</code>
     * @return \Google\Cloud\Dataplex\V1\Action\MissingData|null
     */
    public function getMissingData()
    {
        return $this->readOneof(13);
    }

    public function hasMissingData()
    {
        return $this->hasOneof(13);
    }

    /**
     * Details for issues related to absence of data within managed resources.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.MissingData missing_data = 13;</code>
     * @param \Google\Cloud\Dataplex\V1\Action\MissingData $var
     * @return $this
     */
    public function setMissingData($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Action\MissingData::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * Details for issues related to absence of a managed resource.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.MissingResource missing_resource = 14;</code>
     * @return \Google\Cloud\Dataplex\V1\Action\MissingResource|null
     */
    public function getMissingResource()
    {
        return $this->readOneof(14);
    }

    public function hasMissingResource()
    {
        return $this->hasOneof(14);
    }

    /**
     * Details for issues related to absence of a managed resource.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.MissingResource missing_resource = 14;</code>
     * @param \Google\Cloud\Dataplex\V1\Action\MissingResource $var
     * @return $this
     */
    public function setMissingResource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Action\MissingResource::class);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * Details for issues related to lack of permissions to access data
     * resources.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.UnauthorizedResource unauthorized_resource = 15;</code>
     * @return \Google\Cloud\Dataplex\V1\Action\UnauthorizedResource|null
     */
    public function getUnauthorizedResource()
    {
        return $this->readOneof(15);
    }

    public function hasUnauthorizedResource()
    {
        return $this->hasOneof(15);
    }

    /**
     * Details for issues related to lack of permissions to access data
     * resources.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.UnauthorizedResource unauthorized_resource = 15;</code>
     * @param \Google\Cloud\Dataplex\V1\Action\UnauthorizedResource $var
     * @return $this
     */
    public function setUnauthorizedResource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Action\UnauthorizedResource::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * Details for issues related to applying security policy.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.FailedSecurityPolicyApply failed_security_policy_apply = 21;</code>
     * @return \Google\Cloud\Dataplex\V1\Action\FailedSecurityPolicyApply|null
     */
    public function getFailedSecurityPolicyApply()
    {
        return $this->readOneof(21);
    }

    public function hasFailedSecurityPolicyApply()
    {
        return $this->hasOneof(21);
    }

    /**
     * Details for issues related to applying security policy.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.FailedSecurityPolicyApply failed_security_policy_apply = 21;</code>
     * @param \Google\Cloud\Dataplex\V1\Action\FailedSecurityPolicyApply $var
     * @return $this
     */
    public function setFailedSecurityPolicyApply($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Action\FailedSecurityPolicyApply::class);
        $this->writeOneof(21, $var);

        return $this;
    }

    /**
     * Details for issues related to invalid data arrangement.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.InvalidDataOrganization invalid_data_organization = 22;</code>
     * @return \Google\Cloud\Dataplex\V1\Action\InvalidDataOrganization|null
     */
    public function getInvalidDataOrganization()
    {
        return $this->readOneof(22);
    }

    public function hasInvalidDataOrganization()
    {
        return $this->hasOneof(22);
    }

    /**
     * Details for issues related to invalid data arrangement.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Action.InvalidDataOrganization invalid_data_organization = 22;</code>
     * @param \Google\Cloud\Dataplex\V1\Action\InvalidDataOrganization $var
     * @return $this
     */
    public function setInvalidDataOrganization($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Action\InvalidDataOrganization::class);
        $this->writeOneof(22, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getDetails()
    {
        return $this->whichOneof("details");
    }

}

