<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datastream/v1/datastream.proto

namespace Google\Cloud\Datastream\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for creating a stream.
 *
 * Generated from protobuf message <code>google.cloud.datastream.v1.CreateStreamRequest</code>
 */
class CreateStreamRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent that owns the collection of streams.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. The stream identifier.
     *
     * Generated from protobuf field <code>string stream_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $stream_id = '';
    /**
     * Required. The stream resource to create.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.Stream stream = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $stream = null;
    /**
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $request_id = '';
    /**
     * Optional. Only validate the stream, but don't create any resources.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $validate_only = false;
    /**
     * Optional. Create the stream without validating it.
     *
     * Generated from protobuf field <code>bool force = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $force = false;

    /**
     * @param string                             $parent   Required. The parent that owns the collection of streams. Please see
     *                                                     {@see DatastreamClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\Datastream\V1\Stream $stream   Required. The stream resource to create.
     * @param string                             $streamId Required. The stream identifier.
     *
     * @return \Google\Cloud\Datastream\V1\CreateStreamRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Datastream\V1\Stream $stream, string $streamId): self
    {
        return (new self())
            ->setParent($parent)
            ->setStream($stream)
            ->setStreamId($streamId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent that owns the collection of streams.
     *     @type string $stream_id
     *           Required. The stream identifier.
     *     @type \Google\Cloud\Datastream\V1\Stream $stream
     *           Required. The stream resource to create.
     *     @type string $request_id
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validate_only
     *           Optional. Only validate the stream, but don't create any resources.
     *           The default is false.
     *     @type bool $force
     *           Optional. Create the stream without validating it.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datastream\V1\Datastream::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent that owns the collection of streams.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent that owns the collection of streams.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The stream identifier.
     *
     * Generated from protobuf field <code>string stream_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getStreamId()
    {
        return $this->stream_id;
    }

    /**
     * Required. The stream identifier.
     *
     * Generated from protobuf field <code>string stream_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setStreamId($var)
    {
        GPBUtil::checkString($var, True);
        $this->stream_id = $var;

        return $this;
    }

    /**
     * Required. The stream resource to create.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.Stream stream = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Datastream\V1\Stream|null
     */
    public function getStream()
    {
        return $this->stream;
    }

    public function hasStream()
    {
        return isset($this->stream);
    }

    public function clearStream()
    {
        unset($this->stream);
    }

    /**
     * Required. The stream resource to create.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.Stream stream = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Datastream\V1\Stream $var
     * @return $this
     */
    public function setStream($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastream\V1\Stream::class);
        $this->stream = $var;

        return $this;
    }

    /**
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

    /**
     * Optional. Only validate the stream, but don't create any resources.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * Optional. Only validate the stream, but don't create any resources.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

    /**
     * Optional. Create the stream without validating it.
     *
     * Generated from protobuf field <code>bool force = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getForce()
    {
        return $this->force;
    }

    /**
     * Optional. Create the stream without validating it.
     *
     * Generated from protobuf field <code>bool force = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setForce($var)
    {
        GPBUtil::checkBool($var);
        $this->force = $var;

        return $this;
    }

}

