<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/document.proto

namespace Google\Cloud\Dialogflow\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [Documents.ReloadDocument][google.cloud.dialogflow.v2.Documents.ReloadDocument].
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.v2.ReloadDocumentRequest</code>
 */
class ReloadDocumentRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the document to reload.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $name = '';
    /**
     * Optional. Whether to import custom metadata from Google Cloud Storage.
     * Only valid when the document source is Google Cloud Storage URI.
     *
     * Generated from protobuf field <code>bool import_gcs_custom_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $import_gcs_custom_metadata = false;
    /**
     * Optional. When enabled, the reload request is to apply partial update to
     * the smart messaging allowlist.
     *
     * Generated from protobuf field <code>bool smart_messaging_partial_update = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $smart_messaging_partial_update = false;
    protected $source;

    /**
     * @param string $name       Required. The name of the document to reload.
     *                           Format: `projects/<Project ID>/locations/<Location
     *                           ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`
     *                           Please see {@see DocumentsClient::documentName()} for help formatting this field.
     * @param string $contentUri Optional. The path of gcs source file for reloading document content. For
     *                           now, only gcs uri is supported.
     *
     *                           For documents stored in Google Cloud Storage, these URIs must have
     *                           the form `gs://<bucket-name>/<object-name>`.
     *
     * @return \Google\Cloud\Dialogflow\V2\ReloadDocumentRequest
     *
     * @experimental
     */
    public static function build(string $name, string $contentUri): self
    {
        return (new self())
            ->setName($name)
            ->setContentUri($contentUri);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The name of the document to reload.
     *           Format: `projects/<Project ID>/locations/<Location
     *           ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`
     *     @type string $content_uri
     *           Optional. The path of gcs source file for reloading document content. For
     *           now, only gcs uri is supported.
     *           For documents stored in Google Cloud Storage, these URIs must have
     *           the form `gs://<bucket-name>/<object-name>`.
     *     @type bool $import_gcs_custom_metadata
     *           Optional. Whether to import custom metadata from Google Cloud Storage.
     *           Only valid when the document source is Google Cloud Storage URI.
     *     @type bool $smart_messaging_partial_update
     *           Optional. When enabled, the reload request is to apply partial update to
     *           the smart messaging allowlist.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\V2\Document::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the document to reload.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The name of the document to reload.
     * Format: `projects/<Project ID>/locations/<Location
     * ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The path of gcs source file for reloading document content. For
     * now, only gcs uri is supported.
     * For documents stored in Google Cloud Storage, these URIs must have
     * the form `gs://<bucket-name>/<object-name>`.
     *
     * Generated from protobuf field <code>string content_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getContentUri()
    {
        return $this->readOneof(3);
    }

    public function hasContentUri()
    {
        return $this->hasOneof(3);
    }

    /**
     * Optional. The path of gcs source file for reloading document content. For
     * now, only gcs uri is supported.
     * For documents stored in Google Cloud Storage, these URIs must have
     * the form `gs://<bucket-name>/<object-name>`.
     *
     * Generated from protobuf field <code>string content_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setContentUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Optional. Whether to import custom metadata from Google Cloud Storage.
     * Only valid when the document source is Google Cloud Storage URI.
     *
     * Generated from protobuf field <code>bool import_gcs_custom_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getImportGcsCustomMetadata()
    {
        return $this->import_gcs_custom_metadata;
    }

    /**
     * Optional. Whether to import custom metadata from Google Cloud Storage.
     * Only valid when the document source is Google Cloud Storage URI.
     *
     * Generated from protobuf field <code>bool import_gcs_custom_metadata = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setImportGcsCustomMetadata($var)
    {
        GPBUtil::checkBool($var);
        $this->import_gcs_custom_metadata = $var;

        return $this;
    }

    /**
     * Optional. When enabled, the reload request is to apply partial update to
     * the smart messaging allowlist.
     *
     * Generated from protobuf field <code>bool smart_messaging_partial_update = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getSmartMessagingPartialUpdate()
    {
        return $this->smart_messaging_partial_update;
    }

    /**
     * Optional. When enabled, the reload request is to apply partial update to
     * the smart messaging allowlist.
     *
     * Generated from protobuf field <code>bool smart_messaging_partial_update = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setSmartMessagingPartialUpdate($var)
    {
        GPBUtil::checkBool($var);
        $this->smart_messaging_partial_update = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

}

