<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/participant.proto

namespace Google\Cloud\Dialogflow\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The top-level message returned from the `StreamingAnalyzeContent` method.
 * Multiple response messages can be returned in order:
 * 1.  If the input was set to streaming audio, the first one or more messages
 *     contain `recognition_result`. Each `recognition_result` represents a more
 *     complete transcript of what the user said. The last `recognition_result`
 *     has `is_final` set to `true`.
 * 2.  In virtual agent stage: if `enable_partial_automated_agent_reply` is
 *     true, the following N (currently 1 <= N <= 4) messages
 *     contain `automated_agent_reply` and optionally `reply_audio`
 *     returned by the virtual agent. The first (N-1)
 *     `automated_agent_reply`s will have `automated_agent_reply_type` set to
 *     `PARTIAL`. The last `automated_agent_reply` has
 *     `automated_agent_reply_type` set to `FINAL`.
 *     If `enable_partial_automated_agent_reply` is not enabled, response stream
 *     only contains the final reply.
 *     In human assist stage: the following N (N >= 1) messages contain
 *     `human_agent_suggestion_results`, `end_user_suggestion_results` or
 *     `message`.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.v2.StreamingAnalyzeContentResponse</code>
 */
class StreamingAnalyzeContentResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * The result of speech recognition.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.StreamingRecognitionResult recognition_result = 1;</code>
     */
    private $recognition_result = null;
    /**
     * The output text content.
     * This field is set if an automated agent responded with a text for the user.
     *
     * Generated from protobuf field <code>string reply_text = 2;</code>
     */
    private $reply_text = '';
    /**
     * The audio data bytes encoded as specified in the request.
     * This field is set if:
     *  - The `reply_audio_config` field is specified in the request.
     *  - The automated agent, which this output comes from, responded with audio.
     *    In such case, the `reply_audio.config` field contains settings used to
     *    synthesize the speech.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.OutputAudio reply_audio = 3;</code>
     */
    private $reply_audio = null;
    /**
     * Only set if a Dialogflow automated agent has responded.
     * Note that: [AutomatedAgentReply.detect_intent_response.output_audio][]
     * and [AutomatedAgentReply.detect_intent_response.output_audio_config][]
     * are always empty, use
     * [reply_audio][google.cloud.dialogflow.v2.StreamingAnalyzeContentResponse.reply_audio]
     * instead.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.AutomatedAgentReply automated_agent_reply = 4;</code>
     */
    private $automated_agent_reply = null;
    /**
     * Message analyzed by CCAI.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Message message = 6;</code>
     */
    private $message = null;
    /**
     * The suggestions for most recent human agent. The order is the same as
     * [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
     * of
     * [HumanAgentAssistantConfig.human_agent_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.human_agent_suggestion_config].
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.v2.SuggestionResult human_agent_suggestion_results = 7;</code>
     */
    private $human_agent_suggestion_results;
    /**
     * The suggestions for end user. The order is the same as
     * [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
     * of
     * [HumanAgentAssistantConfig.end_user_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.end_user_suggestion_config].
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.v2.SuggestionResult end_user_suggestion_results = 8;</code>
     */
    private $end_user_suggestion_results;
    /**
     * Indicates the parameters of DTMF.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.DtmfParameters dtmf_parameters = 10;</code>
     */
    private $dtmf_parameters = null;
    /**
     * Debugging info that would get populated when
     * `StreamingAnalyzeContentRequest.enable_debugging_info` is set to true.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.CloudConversationDebuggingInfo debugging_info = 11;</code>
     */
    private $debugging_info = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Dialogflow\V2\StreamingRecognitionResult $recognition_result
     *           The result of speech recognition.
     *     @type string $reply_text
     *           The output text content.
     *           This field is set if an automated agent responded with a text for the user.
     *     @type \Google\Cloud\Dialogflow\V2\OutputAudio $reply_audio
     *           The audio data bytes encoded as specified in the request.
     *           This field is set if:
     *            - The `reply_audio_config` field is specified in the request.
     *            - The automated agent, which this output comes from, responded with audio.
     *              In such case, the `reply_audio.config` field contains settings used to
     *              synthesize the speech.
     *           In some scenarios, multiple output audio fields may be present in the
     *           response structure. In these cases, only the top-most-level audio output
     *           has content.
     *     @type \Google\Cloud\Dialogflow\V2\AutomatedAgentReply $automated_agent_reply
     *           Only set if a Dialogflow automated agent has responded.
     *           Note that: [AutomatedAgentReply.detect_intent_response.output_audio][]
     *           and [AutomatedAgentReply.detect_intent_response.output_audio_config][]
     *           are always empty, use
     *           [reply_audio][google.cloud.dialogflow.v2.StreamingAnalyzeContentResponse.reply_audio]
     *           instead.
     *     @type \Google\Cloud\Dialogflow\V2\Message $message
     *           Message analyzed by CCAI.
     *     @type array<\Google\Cloud\Dialogflow\V2\SuggestionResult>|\Google\Protobuf\Internal\RepeatedField $human_agent_suggestion_results
     *           The suggestions for most recent human agent. The order is the same as
     *           [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
     *           of
     *           [HumanAgentAssistantConfig.human_agent_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.human_agent_suggestion_config].
     *     @type array<\Google\Cloud\Dialogflow\V2\SuggestionResult>|\Google\Protobuf\Internal\RepeatedField $end_user_suggestion_results
     *           The suggestions for end user. The order is the same as
     *           [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
     *           of
     *           [HumanAgentAssistantConfig.end_user_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.end_user_suggestion_config].
     *     @type \Google\Cloud\Dialogflow\V2\DtmfParameters $dtmf_parameters
     *           Indicates the parameters of DTMF.
     *     @type \Google\Cloud\Dialogflow\V2\CloudConversationDebuggingInfo $debugging_info
     *           Debugging info that would get populated when
     *           `StreamingAnalyzeContentRequest.enable_debugging_info` is set to true.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\V2\Participant::initOnce();
        parent::__construct($data);
    }

    /**
     * The result of speech recognition.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.StreamingRecognitionResult recognition_result = 1;</code>
     * @return \Google\Cloud\Dialogflow\V2\StreamingRecognitionResult|null
     */
    public function getRecognitionResult()
    {
        return $this->recognition_result;
    }

    public function hasRecognitionResult()
    {
        return isset($this->recognition_result);
    }

    public function clearRecognitionResult()
    {
        unset($this->recognition_result);
    }

    /**
     * The result of speech recognition.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.StreamingRecognitionResult recognition_result = 1;</code>
     * @param \Google\Cloud\Dialogflow\V2\StreamingRecognitionResult $var
     * @return $this
     */
    public function setRecognitionResult($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\V2\StreamingRecognitionResult::class);
        $this->recognition_result = $var;

        return $this;
    }

    /**
     * The output text content.
     * This field is set if an automated agent responded with a text for the user.
     *
     * Generated from protobuf field <code>string reply_text = 2;</code>
     * @return string
     */
    public function getReplyText()
    {
        return $this->reply_text;
    }

    /**
     * The output text content.
     * This field is set if an automated agent responded with a text for the user.
     *
     * Generated from protobuf field <code>string reply_text = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setReplyText($var)
    {
        GPBUtil::checkString($var, True);
        $this->reply_text = $var;

        return $this;
    }

    /**
     * The audio data bytes encoded as specified in the request.
     * This field is set if:
     *  - The `reply_audio_config` field is specified in the request.
     *  - The automated agent, which this output comes from, responded with audio.
     *    In such case, the `reply_audio.config` field contains settings used to
     *    synthesize the speech.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.OutputAudio reply_audio = 3;</code>
     * @return \Google\Cloud\Dialogflow\V2\OutputAudio|null
     */
    public function getReplyAudio()
    {
        return $this->reply_audio;
    }

    public function hasReplyAudio()
    {
        return isset($this->reply_audio);
    }

    public function clearReplyAudio()
    {
        unset($this->reply_audio);
    }

    /**
     * The audio data bytes encoded as specified in the request.
     * This field is set if:
     *  - The `reply_audio_config` field is specified in the request.
     *  - The automated agent, which this output comes from, responded with audio.
     *    In such case, the `reply_audio.config` field contains settings used to
     *    synthesize the speech.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.OutputAudio reply_audio = 3;</code>
     * @param \Google\Cloud\Dialogflow\V2\OutputAudio $var
     * @return $this
     */
    public function setReplyAudio($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\V2\OutputAudio::class);
        $this->reply_audio = $var;

        return $this;
    }

    /**
     * Only set if a Dialogflow automated agent has responded.
     * Note that: [AutomatedAgentReply.detect_intent_response.output_audio][]
     * and [AutomatedAgentReply.detect_intent_response.output_audio_config][]
     * are always empty, use
     * [reply_audio][google.cloud.dialogflow.v2.StreamingAnalyzeContentResponse.reply_audio]
     * instead.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.AutomatedAgentReply automated_agent_reply = 4;</code>
     * @return \Google\Cloud\Dialogflow\V2\AutomatedAgentReply|null
     */
    public function getAutomatedAgentReply()
    {
        return $this->automated_agent_reply;
    }

    public function hasAutomatedAgentReply()
    {
        return isset($this->automated_agent_reply);
    }

    public function clearAutomatedAgentReply()
    {
        unset($this->automated_agent_reply);
    }

    /**
     * Only set if a Dialogflow automated agent has responded.
     * Note that: [AutomatedAgentReply.detect_intent_response.output_audio][]
     * and [AutomatedAgentReply.detect_intent_response.output_audio_config][]
     * are always empty, use
     * [reply_audio][google.cloud.dialogflow.v2.StreamingAnalyzeContentResponse.reply_audio]
     * instead.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.AutomatedAgentReply automated_agent_reply = 4;</code>
     * @param \Google\Cloud\Dialogflow\V2\AutomatedAgentReply $var
     * @return $this
     */
    public function setAutomatedAgentReply($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\V2\AutomatedAgentReply::class);
        $this->automated_agent_reply = $var;

        return $this;
    }

    /**
     * Message analyzed by CCAI.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Message message = 6;</code>
     * @return \Google\Cloud\Dialogflow\V2\Message|null
     */
    public function getMessage()
    {
        return $this->message;
    }

    public function hasMessage()
    {
        return isset($this->message);
    }

    public function clearMessage()
    {
        unset($this->message);
    }

    /**
     * Message analyzed by CCAI.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.Message message = 6;</code>
     * @param \Google\Cloud\Dialogflow\V2\Message $var
     * @return $this
     */
    public function setMessage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\V2\Message::class);
        $this->message = $var;

        return $this;
    }

    /**
     * The suggestions for most recent human agent. The order is the same as
     * [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
     * of
     * [HumanAgentAssistantConfig.human_agent_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.human_agent_suggestion_config].
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.v2.SuggestionResult human_agent_suggestion_results = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHumanAgentSuggestionResults()
    {
        return $this->human_agent_suggestion_results;
    }

    /**
     * The suggestions for most recent human agent. The order is the same as
     * [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
     * of
     * [HumanAgentAssistantConfig.human_agent_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.human_agent_suggestion_config].
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.v2.SuggestionResult human_agent_suggestion_results = 7;</code>
     * @param array<\Google\Cloud\Dialogflow\V2\SuggestionResult>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHumanAgentSuggestionResults($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\V2\SuggestionResult::class);
        $this->human_agent_suggestion_results = $arr;

        return $this;
    }

    /**
     * The suggestions for end user. The order is the same as
     * [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
     * of
     * [HumanAgentAssistantConfig.end_user_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.end_user_suggestion_config].
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.v2.SuggestionResult end_user_suggestion_results = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEndUserSuggestionResults()
    {
        return $this->end_user_suggestion_results;
    }

    /**
     * The suggestions for end user. The order is the same as
     * [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
     * of
     * [HumanAgentAssistantConfig.end_user_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.end_user_suggestion_config].
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.v2.SuggestionResult end_user_suggestion_results = 8;</code>
     * @param array<\Google\Cloud\Dialogflow\V2\SuggestionResult>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEndUserSuggestionResults($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\V2\SuggestionResult::class);
        $this->end_user_suggestion_results = $arr;

        return $this;
    }

    /**
     * Indicates the parameters of DTMF.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.DtmfParameters dtmf_parameters = 10;</code>
     * @return \Google\Cloud\Dialogflow\V2\DtmfParameters|null
     */
    public function getDtmfParameters()
    {
        return $this->dtmf_parameters;
    }

    public function hasDtmfParameters()
    {
        return isset($this->dtmf_parameters);
    }

    public function clearDtmfParameters()
    {
        unset($this->dtmf_parameters);
    }

    /**
     * Indicates the parameters of DTMF.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.DtmfParameters dtmf_parameters = 10;</code>
     * @param \Google\Cloud\Dialogflow\V2\DtmfParameters $var
     * @return $this
     */
    public function setDtmfParameters($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\V2\DtmfParameters::class);
        $this->dtmf_parameters = $var;

        return $this;
    }

    /**
     * Debugging info that would get populated when
     * `StreamingAnalyzeContentRequest.enable_debugging_info` is set to true.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.CloudConversationDebuggingInfo debugging_info = 11;</code>
     * @return \Google\Cloud\Dialogflow\V2\CloudConversationDebuggingInfo|null
     */
    public function getDebuggingInfo()
    {
        return $this->debugging_info;
    }

    public function hasDebuggingInfo()
    {
        return isset($this->debugging_info);
    }

    public function clearDebuggingInfo()
    {
        unset($this->debugging_info);
    }

    /**
     * Debugging info that would get populated when
     * `StreamingAnalyzeContentRequest.enable_debugging_info` is set to true.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.v2.CloudConversationDebuggingInfo debugging_info = 11;</code>
     * @param \Google\Cloud\Dialogflow\V2\CloudConversationDebuggingInfo $var
     * @return $this
     */
    public function setDebuggingInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\V2\CloudConversationDebuggingInfo::class);
        $this->debugging_info = $var;

        return $this;
    }

}

