<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1beta/search_service.proto

namespace Google\Cloud\DiscoveryEngine\V1beta\SearchRequest\ContentSearchSpec;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A specification for configuring a summary returned in a search
 * response.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec</code>
 */
class SummarySpec extends \Google\Protobuf\Internal\Message
{
    /**
     * The number of top results to generate the summary from. If the number
     * of results returned is less than `summaryResultCount`, the summary is
     * generated from all of the results.
     * At most five results can be used to generate a summary.
     *
     * Generated from protobuf field <code>int32 summary_result_count = 1;</code>
     */
    protected $summary_result_count = 0;
    /**
     * Specifies whether to include citations in the summary. The default
     * value is `false`.
     * When this field is set to `true`, summaries include in-line citation
     * numbers.
     * Example summary including citations:
     * BigQuery is Google Cloud's fully managed and completely serverless
     * enterprise data warehouse [1]. BigQuery supports all data types, works
     * across clouds, and has built-in machine learning and business
     * intelligence, all within a unified platform [2, 3].
     * The citation numbers refer to the returned search results and are
     * 1-indexed. For example, [1] means that the sentence is attributed to
     * the first search result. [2, 3] means that the sentence is attributed
     * to both the second and third search results.
     *
     * Generated from protobuf field <code>bool include_citations = 2;</code>
     */
    protected $include_citations = false;
    /**
     * Specifies whether to filter out adversarial queries. The default value
     * is `false`.
     * Google employs search-query classification to detect adversarial
     * queries. No summary is returned if the search query is classified as an
     * adversarial query. For example, a user might ask a question regarding
     * negative comments about the company or submit a query designed to
     * generate unsafe, policy-violating output. If this field is set to
     * `true`, we skip generating summaries for adversarial queries and return
     * fallback messages instead.
     *
     * Generated from protobuf field <code>bool ignore_adversarial_query = 3;</code>
     */
    protected $ignore_adversarial_query = false;
    /**
     * Specifies whether to filter out queries that are not summary-seeking.
     * The default value is `false`.
     * Google employs search-query classification to detect summary-seeking
     * queries. No summary is returned if the search query is classified as a
     * non-summary seeking query. For example, `why is the sky blue` and `Who
     * is the best soccer player in the world?` are summary-seeking queries,
     * but `SFO airport` and `world cup 2026` are not. They are most likely
     * navigational queries. If this field is set to `true`, we skip
     * generating summaries for non-summary seeking queries and return
     * fallback messages instead.
     *
     * Generated from protobuf field <code>bool ignore_non_summary_seeking_query = 4;</code>
     */
    protected $ignore_non_summary_seeking_query = false;
    /**
     * Language code for Summary. Use language tags defined by
     * [BCP47][https://www.rfc-editor.org/rfc/bcp/bcp47.txt].
     *
     * Generated from protobuf field <code>string language_code = 6;</code>
     */
    protected $language_code = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $summary_result_count
     *           The number of top results to generate the summary from. If the number
     *           of results returned is less than `summaryResultCount`, the summary is
     *           generated from all of the results.
     *           At most five results can be used to generate a summary.
     *     @type bool $include_citations
     *           Specifies whether to include citations in the summary. The default
     *           value is `false`.
     *           When this field is set to `true`, summaries include in-line citation
     *           numbers.
     *           Example summary including citations:
     *           BigQuery is Google Cloud's fully managed and completely serverless
     *           enterprise data warehouse [1]. BigQuery supports all data types, works
     *           across clouds, and has built-in machine learning and business
     *           intelligence, all within a unified platform [2, 3].
     *           The citation numbers refer to the returned search results and are
     *           1-indexed. For example, [1] means that the sentence is attributed to
     *           the first search result. [2, 3] means that the sentence is attributed
     *           to both the second and third search results.
     *     @type bool $ignore_adversarial_query
     *           Specifies whether to filter out adversarial queries. The default value
     *           is `false`.
     *           Google employs search-query classification to detect adversarial
     *           queries. No summary is returned if the search query is classified as an
     *           adversarial query. For example, a user might ask a question regarding
     *           negative comments about the company or submit a query designed to
     *           generate unsafe, policy-violating output. If this field is set to
     *           `true`, we skip generating summaries for adversarial queries and return
     *           fallback messages instead.
     *     @type bool $ignore_non_summary_seeking_query
     *           Specifies whether to filter out queries that are not summary-seeking.
     *           The default value is `false`.
     *           Google employs search-query classification to detect summary-seeking
     *           queries. No summary is returned if the search query is classified as a
     *           non-summary seeking query. For example, `why is the sky blue` and `Who
     *           is the best soccer player in the world?` are summary-seeking queries,
     *           but `SFO airport` and `world cup 2026` are not. They are most likely
     *           navigational queries. If this field is set to `true`, we skip
     *           generating summaries for non-summary seeking queries and return
     *           fallback messages instead.
     *     @type string $language_code
     *           Language code for Summary. Use language tags defined by
     *           [BCP47][https://www.rfc-editor.org/rfc/bcp/bcp47.txt].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1Beta\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * The number of top results to generate the summary from. If the number
     * of results returned is less than `summaryResultCount`, the summary is
     * generated from all of the results.
     * At most five results can be used to generate a summary.
     *
     * Generated from protobuf field <code>int32 summary_result_count = 1;</code>
     * @return int
     */
    public function getSummaryResultCount()
    {
        return $this->summary_result_count;
    }

    /**
     * The number of top results to generate the summary from. If the number
     * of results returned is less than `summaryResultCount`, the summary is
     * generated from all of the results.
     * At most five results can be used to generate a summary.
     *
     * Generated from protobuf field <code>int32 summary_result_count = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setSummaryResultCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->summary_result_count = $var;

        return $this;
    }

    /**
     * Specifies whether to include citations in the summary. The default
     * value is `false`.
     * When this field is set to `true`, summaries include in-line citation
     * numbers.
     * Example summary including citations:
     * BigQuery is Google Cloud's fully managed and completely serverless
     * enterprise data warehouse [1]. BigQuery supports all data types, works
     * across clouds, and has built-in machine learning and business
     * intelligence, all within a unified platform [2, 3].
     * The citation numbers refer to the returned search results and are
     * 1-indexed. For example, [1] means that the sentence is attributed to
     * the first search result. [2, 3] means that the sentence is attributed
     * to both the second and third search results.
     *
     * Generated from protobuf field <code>bool include_citations = 2;</code>
     * @return bool
     */
    public function getIncludeCitations()
    {
        return $this->include_citations;
    }

    /**
     * Specifies whether to include citations in the summary. The default
     * value is `false`.
     * When this field is set to `true`, summaries include in-line citation
     * numbers.
     * Example summary including citations:
     * BigQuery is Google Cloud's fully managed and completely serverless
     * enterprise data warehouse [1]. BigQuery supports all data types, works
     * across clouds, and has built-in machine learning and business
     * intelligence, all within a unified platform [2, 3].
     * The citation numbers refer to the returned search results and are
     * 1-indexed. For example, [1] means that the sentence is attributed to
     * the first search result. [2, 3] means that the sentence is attributed
     * to both the second and third search results.
     *
     * Generated from protobuf field <code>bool include_citations = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setIncludeCitations($var)
    {
        GPBUtil::checkBool($var);
        $this->include_citations = $var;

        return $this;
    }

    /**
     * Specifies whether to filter out adversarial queries. The default value
     * is `false`.
     * Google employs search-query classification to detect adversarial
     * queries. No summary is returned if the search query is classified as an
     * adversarial query. For example, a user might ask a question regarding
     * negative comments about the company or submit a query designed to
     * generate unsafe, policy-violating output. If this field is set to
     * `true`, we skip generating summaries for adversarial queries and return
     * fallback messages instead.
     *
     * Generated from protobuf field <code>bool ignore_adversarial_query = 3;</code>
     * @return bool
     */
    public function getIgnoreAdversarialQuery()
    {
        return $this->ignore_adversarial_query;
    }

    /**
     * Specifies whether to filter out adversarial queries. The default value
     * is `false`.
     * Google employs search-query classification to detect adversarial
     * queries. No summary is returned if the search query is classified as an
     * adversarial query. For example, a user might ask a question regarding
     * negative comments about the company or submit a query designed to
     * generate unsafe, policy-violating output. If this field is set to
     * `true`, we skip generating summaries for adversarial queries and return
     * fallback messages instead.
     *
     * Generated from protobuf field <code>bool ignore_adversarial_query = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreAdversarialQuery($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_adversarial_query = $var;

        return $this;
    }

    /**
     * Specifies whether to filter out queries that are not summary-seeking.
     * The default value is `false`.
     * Google employs search-query classification to detect summary-seeking
     * queries. No summary is returned if the search query is classified as a
     * non-summary seeking query. For example, `why is the sky blue` and `Who
     * is the best soccer player in the world?` are summary-seeking queries,
     * but `SFO airport` and `world cup 2026` are not. They are most likely
     * navigational queries. If this field is set to `true`, we skip
     * generating summaries for non-summary seeking queries and return
     * fallback messages instead.
     *
     * Generated from protobuf field <code>bool ignore_non_summary_seeking_query = 4;</code>
     * @return bool
     */
    public function getIgnoreNonSummarySeekingQuery()
    {
        return $this->ignore_non_summary_seeking_query;
    }

    /**
     * Specifies whether to filter out queries that are not summary-seeking.
     * The default value is `false`.
     * Google employs search-query classification to detect summary-seeking
     * queries. No summary is returned if the search query is classified as a
     * non-summary seeking query. For example, `why is the sky blue` and `Who
     * is the best soccer player in the world?` are summary-seeking queries,
     * but `SFO airport` and `world cup 2026` are not. They are most likely
     * navigational queries. If this field is set to `true`, we skip
     * generating summaries for non-summary seeking queries and return
     * fallback messages instead.
     *
     * Generated from protobuf field <code>bool ignore_non_summary_seeking_query = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreNonSummarySeekingQuery($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_non_summary_seeking_query = $var;

        return $this;
    }

    /**
     * Language code for Summary. Use language tags defined by
     * [BCP47][https://www.rfc-editor.org/rfc/bcp/bcp47.txt].
     *
     * Generated from protobuf field <code>string language_code = 6;</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * Language code for Summary. Use language tags defined by
     * [BCP47][https://www.rfc-editor.org/rfc/bcp/bcp47.txt].
     *
     * Generated from protobuf field <code>string language_code = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

}


