<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

namespace Google\Cloud\CloudDms\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The base entity type for all the database related entities.
 * The message contains the entity name, the name of its parent, the entity
 * type, and the specific details per entity type.
 *
 * Generated from protobuf message <code>google.cloud.clouddms.v1.DatabaseEntity</code>
 */
class DatabaseEntity extends \Google\Protobuf\Internal\Message
{
    /**
     * The short name (e.g. table name) of the entity.
     *
     * Generated from protobuf field <code>string short_name = 1;</code>
     */
    private $short_name = '';
    /**
     * The full name of the parent entity (e.g. schema name).
     *
     * Generated from protobuf field <code>string parent_entity = 2;</code>
     */
    private $parent_entity = '';
    /**
     * The type of tree the entity belongs to.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
     */
    private $tree = 0;
    /**
     * The type of the database entity (table, view, index, ...).
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     */
    private $entity_type = 0;
    /**
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     */
    private $mappings;
    /**
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     */
    private $entity_ddl;
    /**
     * Details about the various issues found for the entity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     */
    private $issues;
    protected $entity_body;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $short_name
     *           The short name (e.g. table name) of the entity.
     *     @type string $parent_entity
     *           The full name of the parent entity (e.g. schema name).
     *     @type int $tree
     *           The type of tree the entity belongs to.
     *     @type int $entity_type
     *           The type of the database entity (table, view, index, ...).
     *     @type array<\Google\Cloud\CloudDms\V1\EntityMapping>|\Google\Protobuf\Internal\RepeatedField $mappings
     *           Details about entity mappings.
     *           For source tree entities, this holds the draft entities which were
     *           generated by the mapping rules.
     *           For draft tree entities, this holds the source entities which were
     *           converted to form the draft entity.
     *           Destination entities will have no mapping details.
     *     @type array<\Google\Cloud\CloudDms\V1\EntityDdl>|\Google\Protobuf\Internal\RepeatedField $entity_ddl
     *           Details about the entity DDL script. Multiple DDL scripts are provided for
     *           child entities such as a table entity will have one DDL for the table with
     *           additional DDLs for each index, constraint and such.
     *     @type array<\Google\Cloud\CloudDms\V1\EntityIssue>|\Google\Protobuf\Internal\RepeatedField $issues
     *           Details about the various issues found for the entity.
     *     @type \Google\Cloud\CloudDms\V1\DatabaseInstanceEntity $database
     *           Database.
     *     @type \Google\Cloud\CloudDms\V1\SchemaEntity $schema
     *           Schema.
     *     @type \Google\Cloud\CloudDms\V1\TableEntity $table
     *           Table.
     *     @type \Google\Cloud\CloudDms\V1\ViewEntity $view
     *           View.
     *     @type \Google\Cloud\CloudDms\V1\SequenceEntity $sequence
     *           Sequence.
     *     @type \Google\Cloud\CloudDms\V1\StoredProcedureEntity $stored_procedure
     *           Stored procedure.
     *     @type \Google\Cloud\CloudDms\V1\FunctionEntity $database_function
     *           Function.
     *     @type \Google\Cloud\CloudDms\V1\SynonymEntity $synonym
     *           Synonym.
     *     @type \Google\Cloud\CloudDms\V1\PackageEntity $database_package
     *           Package.
     *     @type \Google\Cloud\CloudDms\V1\UDTEntity $udt
     *           UDT.
     *     @type \Google\Cloud\CloudDms\V1\MaterializedViewEntity $materialized_view
     *           Materialized view.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Clouddms\V1\ConversionworkspaceResources::initOnce();
        parent::__construct($data);
    }

    /**
     * The short name (e.g. table name) of the entity.
     *
     * Generated from protobuf field <code>string short_name = 1;</code>
     * @return string
     */
    public function getShortName()
    {
        return $this->short_name;
    }

    /**
     * The short name (e.g. table name) of the entity.
     *
     * Generated from protobuf field <code>string short_name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setShortName($var)
    {
        GPBUtil::checkString($var, True);
        $this->short_name = $var;

        return $this;
    }

    /**
     * The full name of the parent entity (e.g. schema name).
     *
     * Generated from protobuf field <code>string parent_entity = 2;</code>
     * @return string
     */
    public function getParentEntity()
    {
        return $this->parent_entity;
    }

    /**
     * The full name of the parent entity (e.g. schema name).
     *
     * Generated from protobuf field <code>string parent_entity = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setParentEntity($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent_entity = $var;

        return $this;
    }

    /**
     * The type of tree the entity belongs to.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
     * @return int
     */
    public function getTree()
    {
        return $this->tree;
    }

    /**
     * The type of tree the entity belongs to.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseEntity.TreeType tree = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setTree($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CloudDms\V1\DatabaseEntity\TreeType::class);
        $this->tree = $var;

        return $this;
    }

    /**
     * The type of the database entity (table, view, index, ...).
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     * @return int
     */
    public function getEntityType()
    {
        return $this->entity_type;
    }

    /**
     * The type of the database entity (table, view, index, ...).
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setEntityType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CloudDms\V1\DatabaseEntityType::class);
        $this->entity_type = $var;

        return $this;
    }

    /**
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMappings()
    {
        return $this->mappings;
    }

    /**
     * Details about entity mappings.
     * For source tree entities, this holds the draft entities which were
     * generated by the mapping rules.
     * For draft tree entities, this holds the source entities which were
     * converted to form the draft entity.
     * Destination entities will have no mapping details.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityMapping mappings = 5;</code>
     * @param array<\Google\Cloud\CloudDms\V1\EntityMapping>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMappings($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\CloudDms\V1\EntityMapping::class);
        $this->mappings = $arr;

        return $this;
    }

    /**
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntityDdl()
    {
        return $this->entity_ddl;
    }

    /**
     * Details about the entity DDL script. Multiple DDL scripts are provided for
     * child entities such as a table entity will have one DDL for the table with
     * additional DDLs for each index, constraint and such.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityDdl entity_ddl = 6;</code>
     * @param array<\Google\Cloud\CloudDms\V1\EntityDdl>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntityDdl($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\CloudDms\V1\EntityDdl::class);
        $this->entity_ddl = $arr;

        return $this;
    }

    /**
     * Details about the various issues found for the entity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIssues()
    {
        return $this->issues;
    }

    /**
     * Details about the various issues found for the entity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.clouddms.v1.EntityIssue issues = 7;</code>
     * @param array<\Google\Cloud\CloudDms\V1\EntityIssue>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIssues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\CloudDms\V1\EntityIssue::class);
        $this->issues = $arr;

        return $this;
    }

    /**
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     * @return \Google\Cloud\CloudDms\V1\DatabaseInstanceEntity|null
     */
    public function getDatabase()
    {
        return $this->readOneof(101);
    }

    public function hasDatabase()
    {
        return $this->hasOneof(101);
    }

    /**
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseInstanceEntity database = 101;</code>
     * @param \Google\Cloud\CloudDms\V1\DatabaseInstanceEntity $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\DatabaseInstanceEntity::class);
        $this->writeOneof(101, $var);

        return $this;
    }

    /**
     * Schema.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     * @return \Google\Cloud\CloudDms\V1\SchemaEntity|null
     */
    public function getSchema()
    {
        return $this->readOneof(102);
    }

    public function hasSchema()
    {
        return $this->hasOneof(102);
    }

    /**
     * Schema.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.SchemaEntity schema = 102;</code>
     * @param \Google\Cloud\CloudDms\V1\SchemaEntity $var
     * @return $this
     */
    public function setSchema($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\SchemaEntity::class);
        $this->writeOneof(102, $var);

        return $this;
    }

    /**
     * Table.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     * @return \Google\Cloud\CloudDms\V1\TableEntity|null
     */
    public function getTable()
    {
        return $this->readOneof(103);
    }

    public function hasTable()
    {
        return $this->hasOneof(103);
    }

    /**
     * Table.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.TableEntity table = 103;</code>
     * @param \Google\Cloud\CloudDms\V1\TableEntity $var
     * @return $this
     */
    public function setTable($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\TableEntity::class);
        $this->writeOneof(103, $var);

        return $this;
    }

    /**
     * View.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     * @return \Google\Cloud\CloudDms\V1\ViewEntity|null
     */
    public function getView()
    {
        return $this->readOneof(104);
    }

    public function hasView()
    {
        return $this->hasOneof(104);
    }

    /**
     * View.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ViewEntity view = 104;</code>
     * @param \Google\Cloud\CloudDms\V1\ViewEntity $var
     * @return $this
     */
    public function setView($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\ViewEntity::class);
        $this->writeOneof(104, $var);

        return $this;
    }

    /**
     * Sequence.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     * @return \Google\Cloud\CloudDms\V1\SequenceEntity|null
     */
    public function getSequence()
    {
        return $this->readOneof(105);
    }

    public function hasSequence()
    {
        return $this->hasOneof(105);
    }

    /**
     * Sequence.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.SequenceEntity sequence = 105;</code>
     * @param \Google\Cloud\CloudDms\V1\SequenceEntity $var
     * @return $this
     */
    public function setSequence($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\SequenceEntity::class);
        $this->writeOneof(105, $var);

        return $this;
    }

    /**
     * Stored procedure.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     * @return \Google\Cloud\CloudDms\V1\StoredProcedureEntity|null
     */
    public function getStoredProcedure()
    {
        return $this->readOneof(106);
    }

    public function hasStoredProcedure()
    {
        return $this->hasOneof(106);
    }

    /**
     * Stored procedure.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.StoredProcedureEntity stored_procedure = 106;</code>
     * @param \Google\Cloud\CloudDms\V1\StoredProcedureEntity $var
     * @return $this
     */
    public function setStoredProcedure($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\StoredProcedureEntity::class);
        $this->writeOneof(106, $var);

        return $this;
    }

    /**
     * Function.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     * @return \Google\Cloud\CloudDms\V1\FunctionEntity|null
     */
    public function getDatabaseFunction()
    {
        return $this->readOneof(107);
    }

    public function hasDatabaseFunction()
    {
        return $this->hasOneof(107);
    }

    /**
     * Function.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.FunctionEntity database_function = 107;</code>
     * @param \Google\Cloud\CloudDms\V1\FunctionEntity $var
     * @return $this
     */
    public function setDatabaseFunction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\FunctionEntity::class);
        $this->writeOneof(107, $var);

        return $this;
    }

    /**
     * Synonym.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     * @return \Google\Cloud\CloudDms\V1\SynonymEntity|null
     */
    public function getSynonym()
    {
        return $this->readOneof(108);
    }

    public function hasSynonym()
    {
        return $this->hasOneof(108);
    }

    /**
     * Synonym.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.SynonymEntity synonym = 108;</code>
     * @param \Google\Cloud\CloudDms\V1\SynonymEntity $var
     * @return $this
     */
    public function setSynonym($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\SynonymEntity::class);
        $this->writeOneof(108, $var);

        return $this;
    }

    /**
     * Package.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     * @return \Google\Cloud\CloudDms\V1\PackageEntity|null
     */
    public function getDatabasePackage()
    {
        return $this->readOneof(109);
    }

    public function hasDatabasePackage()
    {
        return $this->hasOneof(109);
    }

    /**
     * Package.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.PackageEntity database_package = 109;</code>
     * @param \Google\Cloud\CloudDms\V1\PackageEntity $var
     * @return $this
     */
    public function setDatabasePackage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\PackageEntity::class);
        $this->writeOneof(109, $var);

        return $this;
    }

    /**
     * UDT.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     * @return \Google\Cloud\CloudDms\V1\UDTEntity|null
     */
    public function getUdt()
    {
        return $this->readOneof(110);
    }

    public function hasUdt()
    {
        return $this->hasOneof(110);
    }

    /**
     * UDT.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.UDTEntity udt = 110;</code>
     * @param \Google\Cloud\CloudDms\V1\UDTEntity $var
     * @return $this
     */
    public function setUdt($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\UDTEntity::class);
        $this->writeOneof(110, $var);

        return $this;
    }

    /**
     * Materialized view.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     * @return \Google\Cloud\CloudDms\V1\MaterializedViewEntity|null
     */
    public function getMaterializedView()
    {
        return $this->readOneof(111);
    }

    public function hasMaterializedView()
    {
        return $this->hasOneof(111);
    }

    /**
     * Materialized view.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MaterializedViewEntity materialized_view = 111;</code>
     * @param \Google\Cloud\CloudDms\V1\MaterializedViewEntity $var
     * @return $this
     */
    public function setMaterializedView($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\MaterializedViewEntity::class);
        $this->writeOneof(111, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getEntityBody()
    {
        return $this->whichOneof("entity_body");
    }

}

