<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/clouddms/v1/clouddms_resources.proto

namespace Google\Cloud\CloudDms\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Database Migration Service migration job object.
 *
 * Generated from protobuf message <code>google.cloud.clouddms.v1.MigrationJob</code>
 */
class MigrationJob extends \Google\Protobuf\Internal\Message
{
    /**
     * The name (URI) of this migration job resource, in the form of:
     * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * The migration job display name.
     *
     * Generated from protobuf field <code>string display_name = 5;</code>
     */
    private $display_name = '';
    /**
     * The current migration job state.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
     */
    private $state = 0;
    /**
     * Output only. The current migration job phase.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $phase = 0;
    /**
     * Required. The migration job type.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $type = 0;
    /**
     * The path to the dump file in Google Cloud Storage,
     * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     * This field and the "dump_flags" field are mutually exclusive.
     *
     * Generated from protobuf field <code>string dump_path = 9;</code>
     */
    private $dump_path = '';
    /**
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     */
    private $dump_flags = null;
    /**
     * Required. The resource name (URI) of the source connection profile.
     *
     * Generated from protobuf field <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $source = '';
    /**
     * Required. The resource name (URI) of the destination connection profile.
     *
     * Generated from protobuf field <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $destination = '';
    /**
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $duration = null;
    /**
     * Output only. The error details in case of state FAILED.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $error = null;
    /**
     * The database engine type and provider of the source.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     */
    private $source_database = null;
    /**
     * The database engine type and provider of the destination.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     */
    private $destination_database = null;
    /**
     * Output only. If the migration job is completed, the time when it was
     * completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $end_time = null;
    /**
     * The conversion workspace used by the migration.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     */
    private $conversion_workspace = null;
    /**
     * This field can be used to select the entities to migrate as part of
     * the migration job. It uses AIP-160 notation to select a subset of the
     * entities configured on the associated conversion-workspace. This field
     * should not be set on migration-jobs that are not associated with a
     * conversion workspace.
     *
     * Generated from protobuf field <code>string filter = 20;</code>
     */
    private $filter = '';
    /**
     * The CMEK (customer-managed encryption key) fully qualified key name used
     * for the migration job.
     * This field supports all migration jobs types except for:
     * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     * instead).
     * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     * connection profile instead).
     * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     * connection profile instead).
     * Each Cloud CMEK key has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     *
     * Generated from protobuf field <code>string cmek_key_name = 21;</code>
     */
    private $cmek_key_name = '';
    /**
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $performance_config = null;
    protected $connectivity;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The name (URI) of this migration job resource, in the form of:
     *           projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the migration job resource was created.
     *           A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     *           Example: "2014-10-02T15:01:23.045123456Z".
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the migration job resource was last
     *           updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     *           Example: "2014-10-02T15:01:23.045123456Z".
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The resource labels for migration job to use to annotate any related
     *           underlying resources such as Compute Engine VMs. An object containing a
     *           list of "key": "value" pairs.
     *           Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     *     @type string $display_name
     *           The migration job display name.
     *     @type int $state
     *           The current migration job state.
     *     @type int $phase
     *           Output only. The current migration job phase.
     *     @type int $type
     *           Required. The migration job type.
     *     @type string $dump_path
     *           The path to the dump file in Google Cloud Storage,
     *           in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     *           This field and the "dump_flags" field are mutually exclusive.
     *     @type \Google\Cloud\CloudDms\V1\MigrationJob\DumpFlags $dump_flags
     *           The initial dump flags.
     *           This field and the "dump_path" field are mutually exclusive.
     *     @type string $source
     *           Required. The resource name (URI) of the source connection profile.
     *     @type string $destination
     *           Required. The resource name (URI) of the destination connection profile.
     *     @type \Google\Cloud\CloudDms\V1\ReverseSshConnectivity $reverse_ssh_connectivity
     *           The details needed to communicate to the source over Reverse SSH
     *           tunnel connectivity.
     *     @type \Google\Cloud\CloudDms\V1\VpcPeeringConnectivity $vpc_peering_connectivity
     *           The details of the VPC network that the source database is located in.
     *     @type \Google\Cloud\CloudDms\V1\StaticIpConnectivity $static_ip_connectivity
     *           static ip connectivity data (default, no additional details needed).
     *     @type \Google\Protobuf\Duration $duration
     *           Output only. The duration of the migration job (in seconds). A duration in
     *           seconds with up to nine fractional digits, terminated by 's'. Example:
     *           "3.5s".
     *     @type \Google\Rpc\Status $error
     *           Output only. The error details in case of state FAILED.
     *     @type \Google\Cloud\CloudDms\V1\DatabaseType $source_database
     *           The database engine type and provider of the source.
     *     @type \Google\Cloud\CloudDms\V1\DatabaseType $destination_database
     *           The database engine type and provider of the destination.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           Output only. If the migration job is completed, the time when it was
     *           completed.
     *     @type \Google\Cloud\CloudDms\V1\ConversionWorkspaceInfo $conversion_workspace
     *           The conversion workspace used by the migration.
     *     @type string $filter
     *           This field can be used to select the entities to migrate as part of
     *           the migration job. It uses AIP-160 notation to select a subset of the
     *           entities configured on the associated conversion-workspace. This field
     *           should not be set on migration-jobs that are not associated with a
     *           conversion workspace.
     *     @type string $cmek_key_name
     *           The CMEK (customer-managed encryption key) fully qualified key name used
     *           for the migration job.
     *           This field supports all migration jobs types except for:
     *           * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     *           instead).
     *           * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     *           connection profile instead).
     *           * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     *           connection profile instead).
     *           Each Cloud CMEK key has the following format:
     *           projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     *     @type \Google\Cloud\CloudDms\V1\MigrationJob\PerformanceConfig $performance_config
     *           Optional. Data dump parallelism settings used by the migration.
     *           Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Clouddms\V1\ClouddmsResources::initOnce();
        parent::__construct($data);
    }

    /**
     * The name (URI) of this migration job resource, in the form of:
     * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name (URI) of this migration job resource, in the form of:
     * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * The migration job display name.
     *
     * Generated from protobuf field <code>string display_name = 5;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The migration job display name.
     *
     * Generated from protobuf field <code>string display_name = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The current migration job state.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The current migration job state.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CloudDms\V1\MigrationJob\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The current migration job phase.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getPhase()
    {
        return $this->phase;
    }

    /**
     * Output only. The current migration job phase.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setPhase($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CloudDms\V1\MigrationJob\Phase::class);
        $this->phase = $var;

        return $this;
    }

    /**
     * Required. The migration job type.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Required. The migration job type.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CloudDms\V1\MigrationJob\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * The path to the dump file in Google Cloud Storage,
     * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     * This field and the "dump_flags" field are mutually exclusive.
     *
     * Generated from protobuf field <code>string dump_path = 9;</code>
     * @return string
     */
    public function getDumpPath()
    {
        return $this->dump_path;
    }

    /**
     * The path to the dump file in Google Cloud Storage,
     * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     * This field and the "dump_flags" field are mutually exclusive.
     *
     * Generated from protobuf field <code>string dump_path = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setDumpPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->dump_path = $var;

        return $this;
    }

    /**
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     * @return \Google\Cloud\CloudDms\V1\MigrationJob\DumpFlags|null
     */
    public function getDumpFlags()
    {
        return $this->dump_flags;
    }

    public function hasDumpFlags()
    {
        return isset($this->dump_flags);
    }

    public function clearDumpFlags()
    {
        unset($this->dump_flags);
    }

    /**
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     * @param \Google\Cloud\CloudDms\V1\MigrationJob\DumpFlags $var
     * @return $this
     */
    public function setDumpFlags($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\MigrationJob\DumpFlags::class);
        $this->dump_flags = $var;

        return $this;
    }

    /**
     * Required. The resource name (URI) of the source connection profile.
     *
     * Generated from protobuf field <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * Required. The resource name (URI) of the source connection profile.
     *
     * Generated from protobuf field <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setSource($var)
    {
        GPBUtil::checkString($var, True);
        $this->source = $var;

        return $this;
    }

    /**
     * Required. The resource name (URI) of the destination connection profile.
     *
     * Generated from protobuf field <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }

    /**
     * Required. The resource name (URI) of the destination connection profile.
     *
     * Generated from protobuf field <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDestination($var)
    {
        GPBUtil::checkString($var, True);
        $this->destination = $var;

        return $this;
    }

    /**
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     * @return \Google\Cloud\CloudDms\V1\ReverseSshConnectivity|null
     */
    public function getReverseSshConnectivity()
    {
        return $this->readOneof(101);
    }

    public function hasReverseSshConnectivity()
    {
        return $this->hasOneof(101);
    }

    /**
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     * @param \Google\Cloud\CloudDms\V1\ReverseSshConnectivity $var
     * @return $this
     */
    public function setReverseSshConnectivity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\ReverseSshConnectivity::class);
        $this->writeOneof(101, $var);

        return $this;
    }

    /**
     * The details of the VPC network that the source database is located in.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     * @return \Google\Cloud\CloudDms\V1\VpcPeeringConnectivity|null
     */
    public function getVpcPeeringConnectivity()
    {
        return $this->readOneof(102);
    }

    public function hasVpcPeeringConnectivity()
    {
        return $this->hasOneof(102);
    }

    /**
     * The details of the VPC network that the source database is located in.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     * @param \Google\Cloud\CloudDms\V1\VpcPeeringConnectivity $var
     * @return $this
     */
    public function setVpcPeeringConnectivity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\VpcPeeringConnectivity::class);
        $this->writeOneof(102, $var);

        return $this;
    }

    /**
     * static ip connectivity data (default, no additional details needed).
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     * @return \Google\Cloud\CloudDms\V1\StaticIpConnectivity|null
     */
    public function getStaticIpConnectivity()
    {
        return $this->readOneof(103);
    }

    public function hasStaticIpConnectivity()
    {
        return $this->hasOneof(103);
    }

    /**
     * static ip connectivity data (default, no additional details needed).
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     * @param \Google\Cloud\CloudDms\V1\StaticIpConnectivity $var
     * @return $this
     */
    public function setStaticIpConnectivity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\StaticIpConnectivity::class);
        $this->writeOneof(103, $var);

        return $this;
    }

    /**
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getDuration()
    {
        return $this->duration;
    }

    public function hasDuration()
    {
        return isset($this->duration);
    }

    public function clearDuration()
    {
        unset($this->duration);
    }

    /**
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->duration = $var;

        return $this;
    }

    /**
     * Output only. The error details in case of state FAILED.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * Output only. The error details in case of state FAILED.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * The database engine type and provider of the source.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     * @return \Google\Cloud\CloudDms\V1\DatabaseType|null
     */
    public function getSourceDatabase()
    {
        return $this->source_database;
    }

    public function hasSourceDatabase()
    {
        return isset($this->source_database);
    }

    public function clearSourceDatabase()
    {
        unset($this->source_database);
    }

    /**
     * The database engine type and provider of the source.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     * @param \Google\Cloud\CloudDms\V1\DatabaseType $var
     * @return $this
     */
    public function setSourceDatabase($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\DatabaseType::class);
        $this->source_database = $var;

        return $this;
    }

    /**
     * The database engine type and provider of the destination.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     * @return \Google\Cloud\CloudDms\V1\DatabaseType|null
     */
    public function getDestinationDatabase()
    {
        return $this->destination_database;
    }

    public function hasDestinationDatabase()
    {
        return isset($this->destination_database);
    }

    public function clearDestinationDatabase()
    {
        unset($this->destination_database);
    }

    /**
     * The database engine type and provider of the destination.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     * @param \Google\Cloud\CloudDms\V1\DatabaseType $var
     * @return $this
     */
    public function setDestinationDatabase($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\DatabaseType::class);
        $this->destination_database = $var;

        return $this;
    }

    /**
     * Output only. If the migration job is completed, the time when it was
     * completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * Output only. If the migration job is completed, the time when it was
     * completed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * The conversion workspace used by the migration.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     * @return \Google\Cloud\CloudDms\V1\ConversionWorkspaceInfo|null
     */
    public function getConversionWorkspace()
    {
        return $this->conversion_workspace;
    }

    public function hasConversionWorkspace()
    {
        return isset($this->conversion_workspace);
    }

    public function clearConversionWorkspace()
    {
        unset($this->conversion_workspace);
    }

    /**
     * The conversion workspace used by the migration.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     * @param \Google\Cloud\CloudDms\V1\ConversionWorkspaceInfo $var
     * @return $this
     */
    public function setConversionWorkspace($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\ConversionWorkspaceInfo::class);
        $this->conversion_workspace = $var;

        return $this;
    }

    /**
     * This field can be used to select the entities to migrate as part of
     * the migration job. It uses AIP-160 notation to select a subset of the
     * entities configured on the associated conversion-workspace. This field
     * should not be set on migration-jobs that are not associated with a
     * conversion workspace.
     *
     * Generated from protobuf field <code>string filter = 20;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * This field can be used to select the entities to migrate as part of
     * the migration job. It uses AIP-160 notation to select a subset of the
     * entities configured on the associated conversion-workspace. This field
     * should not be set on migration-jobs that are not associated with a
     * conversion workspace.
     *
     * Generated from protobuf field <code>string filter = 20;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * The CMEK (customer-managed encryption key) fully qualified key name used
     * for the migration job.
     * This field supports all migration jobs types except for:
     * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     * instead).
     * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     * connection profile instead).
     * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     * connection profile instead).
     * Each Cloud CMEK key has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     *
     * Generated from protobuf field <code>string cmek_key_name = 21;</code>
     * @return string
     */
    public function getCmekKeyName()
    {
        return $this->cmek_key_name;
    }

    /**
     * The CMEK (customer-managed encryption key) fully qualified key name used
     * for the migration job.
     * This field supports all migration jobs types except for:
     * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     * instead).
     * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     * connection profile instead).
     * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     * connection profile instead).
     * Each Cloud CMEK key has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     *
     * Generated from protobuf field <code>string cmek_key_name = 21;</code>
     * @param string $var
     * @return $this
     */
    public function setCmekKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->cmek_key_name = $var;

        return $this;
    }

    /**
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\CloudDms\V1\MigrationJob\PerformanceConfig|null
     */
    public function getPerformanceConfig()
    {
        return $this->performance_config;
    }

    public function hasPerformanceConfig()
    {
        return isset($this->performance_config);
    }

    public function clearPerformanceConfig()
    {
        unset($this->performance_config);
    }

    /**
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\CloudDms\V1\MigrationJob\PerformanceConfig $var
     * @return $this
     */
    public function setPerformanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\MigrationJob\PerformanceConfig::class);
        $this->performance_config = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getConnectivity()
    {
        return $this->whichOneof("connectivity");
    }

}

