<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/filestore/v1/cloud_filestore_service.proto

namespace Google\Cloud\Filestore\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Network configuration for the instance.
 *
 * Generated from protobuf message <code>google.cloud.filestore.v1.NetworkConfig</code>
 */
class NetworkConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the Google Compute Engine
     * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected.
     *
     * Generated from protobuf field <code>string network = 1;</code>
     */
    private $network = '';
    /**
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     */
    private $modes;
    /**
     * Optional, reserved_ip_range can have one of the following two types of
     * values.
     * * CIDR range value when using DIRECT_PEERING connect mode.
     * * [Allocated IP address
     * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     * when using PRIVATE_SERVICE_ACCESS connect mode.
     * When the name of an allocated IP address range is specified, it must be one
     * of the ranges associated with the private service access connection.
     * When specified as a direct CIDR value, it must be a /29 CIDR block for
     * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     * Enterprise tier in one of the [internal IP address
     * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     * that identifies the range of IP addresses reserved for this instance. For
     * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     * range you specify can't overlap with either existing subnets or assigned IP
     * address ranges for other Filestore instances in the selected VPC
     * network.
     *
     * Generated from protobuf field <code>string reserved_ip_range = 4;</code>
     */
    private $reserved_ip_range = '';
    /**
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     *
     * Generated from protobuf field <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $ip_addresses;
    /**
     * The network connect mode of the Filestore instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
     */
    private $connect_mode = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $network
     *           The name of the Google Compute Engine
     *           [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     *           instance is connected.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $modes
     *           Internet protocol versions for which the instance has IP addresses
     *           assigned. For this version, only MODE_IPV4 is supported.
     *     @type string $reserved_ip_range
     *           Optional, reserved_ip_range can have one of the following two types of
     *           values.
     *           * CIDR range value when using DIRECT_PEERING connect mode.
     *           * [Allocated IP address
     *           range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     *           when using PRIVATE_SERVICE_ACCESS connect mode.
     *           When the name of an allocated IP address range is specified, it must be one
     *           of the ranges associated with the private service access connection.
     *           When specified as a direct CIDR value, it must be a /29 CIDR block for
     *           Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     *           Enterprise tier in one of the [internal IP address
     *           ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     *           that identifies the range of IP addresses reserved for this instance. For
     *           example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     *           range you specify can't overlap with either existing subnets or assigned IP
     *           address ranges for other Filestore instances in the selected VPC
     *           network.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ip_addresses
     *           Output only. IPv4 addresses in the format
     *           `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     *           `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     *     @type int $connect_mode
     *           The network connect mode of the Filestore instance.
     *           If not provided, the connect mode defaults to DIRECT_PEERING.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Filestore\V1\CloudFilestoreService::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the Google Compute Engine
     * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected.
     *
     * Generated from protobuf field <code>string network = 1;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * The name of the Google Compute Engine
     * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected.
     *
     * Generated from protobuf field <code>string network = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getModes()
    {
        return $this->modes;
    }

    /**
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setModes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Filestore\V1\NetworkConfig\AddressMode::class);
        $this->modes = $arr;

        return $this;
    }

    /**
     * Optional, reserved_ip_range can have one of the following two types of
     * values.
     * * CIDR range value when using DIRECT_PEERING connect mode.
     * * [Allocated IP address
     * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     * when using PRIVATE_SERVICE_ACCESS connect mode.
     * When the name of an allocated IP address range is specified, it must be one
     * of the ranges associated with the private service access connection.
     * When specified as a direct CIDR value, it must be a /29 CIDR block for
     * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     * Enterprise tier in one of the [internal IP address
     * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     * that identifies the range of IP addresses reserved for this instance. For
     * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     * range you specify can't overlap with either existing subnets or assigned IP
     * address ranges for other Filestore instances in the selected VPC
     * network.
     *
     * Generated from protobuf field <code>string reserved_ip_range = 4;</code>
     * @return string
     */
    public function getReservedIpRange()
    {
        return $this->reserved_ip_range;
    }

    /**
     * Optional, reserved_ip_range can have one of the following two types of
     * values.
     * * CIDR range value when using DIRECT_PEERING connect mode.
     * * [Allocated IP address
     * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     * when using PRIVATE_SERVICE_ACCESS connect mode.
     * When the name of an allocated IP address range is specified, it must be one
     * of the ranges associated with the private service access connection.
     * When specified as a direct CIDR value, it must be a /29 CIDR block for
     * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     * Enterprise tier in one of the [internal IP address
     * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     * that identifies the range of IP addresses reserved for this instance. For
     * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     * range you specify can't overlap with either existing subnets or assigned IP
     * address ranges for other Filestore instances in the selected VPC
     * network.
     *
     * Generated from protobuf field <code>string reserved_ip_range = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setReservedIpRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->reserved_ip_range = $var;

        return $this;
    }

    /**
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     *
     * Generated from protobuf field <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIpAddresses()
    {
        return $this->ip_addresses;
    }

    /**
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     *
     * Generated from protobuf field <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIpAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ip_addresses = $arr;

        return $this;
    }

    /**
     * The network connect mode of the Filestore instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
     * @return int
     */
    public function getConnectMode()
    {
        return $this->connect_mode;
    }

    /**
     * The network connect mode of the Filestore instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     *
     * Generated from protobuf field <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setConnectMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Filestore\V1\NetworkConfig\ConnectMode::class);
        $this->connect_mode = $var;

        return $this;
    }

}

