<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/functions/v1/functions.proto

namespace Google\Cloud\Functions\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for a secret volume. It has the information necessary to fetch
 * the secret value from Secret Manager and make it available as files mounted
 * at the requested paths within the application container. Secret value is not
 * a part of the configuration. Every file system read operation performs a
 * lookup in Secret Manager to retrieve the secret value.
 *
 * Generated from protobuf message <code>google.cloud.functions.v1.SecretVolume</code>
 */
class SecretVolume extends \Google\Protobuf\Internal\Message
{
    /**
     * The path within the container to mount the secret volume. For example,
     * setting the mount_path as `/etc/secrets` mounts the secret value files
     * under the `/etc/secrets` directory. This directory is also completely
     * shadowed and unavailable to mount any other secrets.
     * Recommended mount paths: /etc/secrets
     * Restricted mount paths: /cloudsql, /dev/log, /pod, /proc, /var/log
     *
     * Generated from protobuf field <code>string mount_path = 1;</code>
     */
    private $mount_path = '';
    /**
     * Project identifier (preferrably project number but can also be the project
     * ID) of the project that contains the secret. If not set, it is
     * populated with the function's project, assuming that the secret exists in
     * the same project as the function.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     */
    private $project_id = '';
    /**
     * Name of the secret in Secret Manager (not the full resource name).
     *
     * Generated from protobuf field <code>string secret = 3;</code>
     */
    private $secret = '';
    /**
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret is made available in a file named after the
     * secret under the mount point.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretVolume.SecretVersion versions = 4;</code>
     */
    private $versions;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $mount_path
     *           The path within the container to mount the secret volume. For example,
     *           setting the mount_path as `/etc/secrets` mounts the secret value files
     *           under the `/etc/secrets` directory. This directory is also completely
     *           shadowed and unavailable to mount any other secrets.
     *           Recommended mount paths: /etc/secrets
     *           Restricted mount paths: /cloudsql, /dev/log, /pod, /proc, /var/log
     *     @type string $project_id
     *           Project identifier (preferrably project number but can also be the project
     *           ID) of the project that contains the secret. If not set, it is
     *           populated with the function's project, assuming that the secret exists in
     *           the same project as the function.
     *     @type string $secret
     *           Name of the secret in Secret Manager (not the full resource name).
     *     @type array<\Google\Cloud\Functions\V1\SecretVolume\SecretVersion>|\Google\Protobuf\Internal\RepeatedField $versions
     *           List of secret versions to mount for this secret. If empty, the `latest`
     *           version of the secret is made available in a file named after the
     *           secret under the mount point.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Functions\V1\Functions::initOnce();
        parent::__construct($data);
    }

    /**
     * The path within the container to mount the secret volume. For example,
     * setting the mount_path as `/etc/secrets` mounts the secret value files
     * under the `/etc/secrets` directory. This directory is also completely
     * shadowed and unavailable to mount any other secrets.
     * Recommended mount paths: /etc/secrets
     * Restricted mount paths: /cloudsql, /dev/log, /pod, /proc, /var/log
     *
     * Generated from protobuf field <code>string mount_path = 1;</code>
     * @return string
     */
    public function getMountPath()
    {
        return $this->mount_path;
    }

    /**
     * The path within the container to mount the secret volume. For example,
     * setting the mount_path as `/etc/secrets` mounts the secret value files
     * under the `/etc/secrets` directory. This directory is also completely
     * shadowed and unavailable to mount any other secrets.
     * Recommended mount paths: /etc/secrets
     * Restricted mount paths: /cloudsql, /dev/log, /pod, /proc, /var/log
     *
     * Generated from protobuf field <code>string mount_path = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setMountPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->mount_path = $var;

        return $this;
    }

    /**
     * Project identifier (preferrably project number but can also be the project
     * ID) of the project that contains the secret. If not set, it is
     * populated with the function's project, assuming that the secret exists in
     * the same project as the function.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Project identifier (preferrably project number but can also be the project
     * ID) of the project that contains the secret. If not set, it is
     * populated with the function's project, assuming that the secret exists in
     * the same project as the function.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Name of the secret in Secret Manager (not the full resource name).
     *
     * Generated from protobuf field <code>string secret = 3;</code>
     * @return string
     */
    public function getSecret()
    {
        return $this->secret;
    }

    /**
     * Name of the secret in Secret Manager (not the full resource name).
     *
     * Generated from protobuf field <code>string secret = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setSecret($var)
    {
        GPBUtil::checkString($var, True);
        $this->secret = $var;

        return $this;
    }

    /**
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret is made available in a file named after the
     * secret under the mount point.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretVolume.SecretVersion versions = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVersions()
    {
        return $this->versions;
    }

    /**
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret is made available in a file named after the
     * secret under the mount point.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretVolume.SecretVersion versions = 4;</code>
     * @param array<\Google\Cloud\Functions\V1\SecretVolume\SecretVersion>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Functions\V1\SecretVolume\SecretVersion::class);
        $this->versions = $arr;

        return $this;
    }

}

