<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ids/v1/ids.proto

namespace Google\Cloud\Ids\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Endpoint describes a single IDS endpoint. It defines a forwarding rule to
 * which packets can be sent for IDS inspection.
 *
 * Generated from protobuf message <code>google.cloud.ids.v1.Endpoint</code>
 */
class Endpoint extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The name of the endpoint.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Output only. The create time timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The update time timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * The labels of the endpoint.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Required. The fully qualified URL of the network to which the IDS Endpoint is
     * attached.
     *
     * Generated from protobuf field <code>string network = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $network = '';
    /**
     * Output only. The fully qualified URL of the endpoint's ILB Forwarding Rule.
     *
     * Generated from protobuf field <code>string endpoint_forwarding_rule = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $endpoint_forwarding_rule = '';
    /**
     * Output only. The IP address of the IDS Endpoint's ILB.
     *
     * Generated from protobuf field <code>string endpoint_ip = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $endpoint_ip = '';
    /**
     * User-provided description of the endpoint
     *
     * Generated from protobuf field <code>string description = 8;</code>
     */
    private $description = '';
    /**
     * Required. Lowest threat severity that this endpoint will alert on.
     *
     * Generated from protobuf field <code>.google.cloud.ids.v1.Endpoint.Severity severity = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $severity = 0;
    /**
     * Output only. Current state of the endpoint.
     *
     * Generated from protobuf field <code>.google.cloud.ids.v1.Endpoint.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Whether the endpoint should report traffic logs in addition to threat logs.
     *
     * Generated from protobuf field <code>bool traffic_logs = 13;</code>
     */
    private $traffic_logs = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The name of the endpoint.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The create time timestamp.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update time timestamp.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The labels of the endpoint.
     *     @type string $network
     *           Required. The fully qualified URL of the network to which the IDS Endpoint is
     *           attached.
     *     @type string $endpoint_forwarding_rule
     *           Output only. The fully qualified URL of the endpoint's ILB Forwarding Rule.
     *     @type string $endpoint_ip
     *           Output only. The IP address of the IDS Endpoint's ILB.
     *     @type string $description
     *           User-provided description of the endpoint
     *     @type int $severity
     *           Required. Lowest threat severity that this endpoint will alert on.
     *     @type int $state
     *           Output only. Current state of the endpoint.
     *     @type bool $traffic_logs
     *           Whether the endpoint should report traffic logs in addition to threat logs.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ids\V1\Ids::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The name of the endpoint.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The name of the endpoint.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The create time timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The create time timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The update time timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update time timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The labels of the endpoint.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The labels of the endpoint.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. The fully qualified URL of the network to which the IDS Endpoint is
     * attached.
     *
     * Generated from protobuf field <code>string network = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Required. The fully qualified URL of the network to which the IDS Endpoint is
     * attached.
     *
     * Generated from protobuf field <code>string network = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Output only. The fully qualified URL of the endpoint's ILB Forwarding Rule.
     *
     * Generated from protobuf field <code>string endpoint_forwarding_rule = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEndpointForwardingRule()
    {
        return $this->endpoint_forwarding_rule;
    }

    /**
     * Output only. The fully qualified URL of the endpoint's ILB Forwarding Rule.
     *
     * Generated from protobuf field <code>string endpoint_forwarding_rule = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEndpointForwardingRule($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint_forwarding_rule = $var;

        return $this;
    }

    /**
     * Output only. The IP address of the IDS Endpoint's ILB.
     *
     * Generated from protobuf field <code>string endpoint_ip = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEndpointIp()
    {
        return $this->endpoint_ip;
    }

    /**
     * Output only. The IP address of the IDS Endpoint's ILB.
     *
     * Generated from protobuf field <code>string endpoint_ip = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEndpointIp($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint_ip = $var;

        return $this;
    }

    /**
     * User-provided description of the endpoint
     *
     * Generated from protobuf field <code>string description = 8;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User-provided description of the endpoint
     *
     * Generated from protobuf field <code>string description = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Required. Lowest threat severity that this endpoint will alert on.
     *
     * Generated from protobuf field <code>.google.cloud.ids.v1.Endpoint.Severity severity = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getSeverity()
    {
        return $this->severity;
    }

    /**
     * Required. Lowest threat severity that this endpoint will alert on.
     *
     * Generated from protobuf field <code>.google.cloud.ids.v1.Endpoint.Severity severity = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setSeverity($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ids\V1\Endpoint\Severity::class);
        $this->severity = $var;

        return $this;
    }

    /**
     * Output only. Current state of the endpoint.
     *
     * Generated from protobuf field <code>.google.cloud.ids.v1.Endpoint.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. Current state of the endpoint.
     *
     * Generated from protobuf field <code>.google.cloud.ids.v1.Endpoint.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Ids\V1\Endpoint\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Whether the endpoint should report traffic logs in addition to threat logs.
     *
     * Generated from protobuf field <code>bool traffic_logs = 13;</code>
     * @return bool
     */
    public function getTrafficLogs()
    {
        return $this->traffic_logs;
    }

    /**
     * Whether the endpoint should report traffic logs in addition to threat logs.
     *
     * Generated from protobuf field <code>bool traffic_logs = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setTrafficLogs($var)
    {
        GPBUtil::checkBool($var);
        $this->traffic_logs = $var;

        return $this;
    }

}

