<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/notebooks/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Notebooks\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\Notebooks\V1\CreateEnvironmentRequest;
use Google\Cloud\Notebooks\V1\CreateExecutionRequest;
use Google\Cloud\Notebooks\V1\CreateInstanceRequest;
use Google\Cloud\Notebooks\V1\CreateScheduleRequest;
use Google\Cloud\Notebooks\V1\DeleteEnvironmentRequest;
use Google\Cloud\Notebooks\V1\DeleteExecutionRequest;
use Google\Cloud\Notebooks\V1\DeleteInstanceRequest;
use Google\Cloud\Notebooks\V1\DeleteScheduleRequest;
use Google\Cloud\Notebooks\V1\DiagnoseInstanceRequest;
use Google\Cloud\Notebooks\V1\Environment;
use Google\Cloud\Notebooks\V1\Execution;
use Google\Cloud\Notebooks\V1\GetEnvironmentRequest;
use Google\Cloud\Notebooks\V1\GetExecutionRequest;
use Google\Cloud\Notebooks\V1\GetInstanceHealthRequest;
use Google\Cloud\Notebooks\V1\GetInstanceHealthResponse;
use Google\Cloud\Notebooks\V1\GetInstanceRequest;
use Google\Cloud\Notebooks\V1\GetScheduleRequest;
use Google\Cloud\Notebooks\V1\Instance;
use Google\Cloud\Notebooks\V1\IsInstanceUpgradeableRequest;
use Google\Cloud\Notebooks\V1\IsInstanceUpgradeableResponse;
use Google\Cloud\Notebooks\V1\ListEnvironmentsRequest;
use Google\Cloud\Notebooks\V1\ListExecutionsRequest;
use Google\Cloud\Notebooks\V1\ListInstancesRequest;
use Google\Cloud\Notebooks\V1\ListSchedulesRequest;
use Google\Cloud\Notebooks\V1\RegisterInstanceRequest;
use Google\Cloud\Notebooks\V1\ReportInstanceInfoRequest;
use Google\Cloud\Notebooks\V1\ResetInstanceRequest;
use Google\Cloud\Notebooks\V1\RollbackInstanceRequest;
use Google\Cloud\Notebooks\V1\Schedule;
use Google\Cloud\Notebooks\V1\SetInstanceAcceleratorRequest;
use Google\Cloud\Notebooks\V1\SetInstanceLabelsRequest;
use Google\Cloud\Notebooks\V1\SetInstanceMachineTypeRequest;
use Google\Cloud\Notebooks\V1\StartInstanceRequest;
use Google\Cloud\Notebooks\V1\StopInstanceRequest;
use Google\Cloud\Notebooks\V1\TriggerScheduleRequest;
use Google\Cloud\Notebooks\V1\UpdateInstanceConfigRequest;
use Google\Cloud\Notebooks\V1\UpdateInstanceMetadataItemsRequest;
use Google\Cloud\Notebooks\V1\UpdateInstanceMetadataItemsResponse;
use Google\Cloud\Notebooks\V1\UpdateShieldedInstanceConfigRequest;
use Google\Cloud\Notebooks\V1\UpgradeInstanceInternalRequest;
use Google\Cloud\Notebooks\V1\UpgradeInstanceRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: API v1 service for Cloud AI Platform Notebooks.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @method PromiseInterface createEnvironmentAsync(CreateEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createExecutionAsync(CreateExecutionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createInstanceAsync(CreateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createScheduleAsync(CreateScheduleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteEnvironmentAsync(DeleteEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteExecutionAsync(DeleteExecutionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteInstanceAsync(DeleteInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteScheduleAsync(DeleteScheduleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface diagnoseInstanceAsync(DiagnoseInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEnvironmentAsync(GetEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getExecutionAsync(GetExecutionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getInstanceAsync(GetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getInstanceHealthAsync(GetInstanceHealthRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getScheduleAsync(GetScheduleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface isInstanceUpgradeableAsync(IsInstanceUpgradeableRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEnvironmentsAsync(ListEnvironmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listExecutionsAsync(ListExecutionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listInstancesAsync(ListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSchedulesAsync(ListSchedulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface registerInstanceAsync(RegisterInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface reportInstanceInfoAsync(ReportInstanceInfoRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resetInstanceAsync(ResetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface rollbackInstanceAsync(RollbackInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setInstanceAcceleratorAsync(SetInstanceAcceleratorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setInstanceLabelsAsync(SetInstanceLabelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setInstanceMachineTypeAsync(SetInstanceMachineTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface startInstanceAsync(StartInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface stopInstanceAsync(StopInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface triggerScheduleAsync(TriggerScheduleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateInstanceConfigAsync(UpdateInstanceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateInstanceMetadataItemsAsync(UpdateInstanceMetadataItemsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateShieldedInstanceConfigAsync(UpdateShieldedInstanceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface upgradeInstanceAsync(UpgradeInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface upgradeInstanceInternalAsync(UpgradeInstanceInternalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class NotebookServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.notebooks.v1.NotebookService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'notebooks.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/notebook_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/notebook_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/notebook_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/notebook_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a environment
     * resource.
     *
     * @param string $project
     * @param string $environment
     *
     * @return string The formatted environment resource.
     */
    public static function environmentName(string $project, string $environment): string
    {
        return self::getPathTemplate('environment')->render([
            'project' => $project,
            'environment' => $environment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a execution
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $execution
     *
     * @return string The formatted execution resource.
     */
    public static function executionName(string $project, string $location, string $execution): string
    {
        return self::getPathTemplate('execution')->render([
            'project' => $project,
            'location' => $location,
            'execution' => $execution,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a schedule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schedule
     *
     * @return string The formatted schedule resource.
     */
    public static function scheduleName(string $project, string $location, string $schedule): string
    {
        return self::getPathTemplate('schedule')->render([
            'project' => $project,
            'location' => $location,
            'schedule' => $schedule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tensorboard
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     *
     * @return string The formatted tensorboard resource.
     */
    public static function tensorboardName(string $project, string $location, string $tensorboard): string
    {
        return self::getPathTemplate('tensorboard')->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - environment: projects/{project}/environments/{environment}
     * - execution: projects/{project}/location/{location}/executions/{execution}
     * - instance: projects/{project}/instances/{instance}
     * - schedule: projects/{project}/location/{location}/schedules/{schedule}
     * - tensorboard: projects/{project}/locations/{location}/tensorboards/{tensorboard}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'notebooks.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new Environment.
     *
     * The async variant is {@see NotebookServiceClient::createEnvironmentAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/create_environment.php
     *
     * @param CreateEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEnvironment(CreateEnvironmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Execution in a given project and location.
     *
     * The async variant is {@see NotebookServiceClient::createExecutionAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/create_execution.php
     *
     * @param CreateExecutionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createExecution(CreateExecutionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateExecution', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Instance in a given project and location.
     *
     * The async variant is {@see NotebookServiceClient::createInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/create_instance.php
     *
     * @param CreateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInstance(CreateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Scheduled Notebook in a given project and location.
     *
     * The async variant is {@see NotebookServiceClient::createScheduleAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/create_schedule.php
     *
     * @param CreateScheduleRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSchedule(CreateScheduleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateSchedule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Environment.
     *
     * The async variant is {@see NotebookServiceClient::deleteEnvironmentAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/delete_environment.php
     *
     * @param DeleteEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEnvironment(DeleteEnvironmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Deletes execution
     *
     * The async variant is {@see NotebookServiceClient::deleteExecutionAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/delete_execution.php
     *
     * @param DeleteExecutionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteExecution(DeleteExecutionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteExecution', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Instance.
     *
     * The async variant is {@see NotebookServiceClient::deleteInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/delete_instance.php
     *
     * @param DeleteInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInstance(DeleteInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteInstance', $request, $callOptions)->wait();
    }

    /**
     * Deletes schedule and all underlying jobs
     *
     * The async variant is {@see NotebookServiceClient::deleteScheduleAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/delete_schedule.php
     *
     * @param DeleteScheduleRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSchedule(DeleteScheduleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSchedule', $request, $callOptions)->wait();
    }

    /**
     * Creates a Diagnostic File and runs Diagnostic Tool given an Instance.
     *
     * The async variant is {@see NotebookServiceClient::diagnoseInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/diagnose_instance.php
     *
     * @param DiagnoseInstanceRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function diagnoseInstance(DiagnoseInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DiagnoseInstance', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Environment.
     *
     * The async variant is {@see NotebookServiceClient::getEnvironmentAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_environment.php
     *
     * @param GetEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Environment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEnvironment(GetEnvironmentRequest $request, array $callOptions = []): Environment
    {
        return $this->startApiCall('GetEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Gets details of executions
     *
     * The async variant is {@see NotebookServiceClient::getExecutionAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_execution.php
     *
     * @param GetExecutionRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Execution
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getExecution(GetExecutionRequest $request, array $callOptions = []): Execution
    {
        return $this->startApiCall('GetExecution', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Instance.
     *
     * The async variant is {@see NotebookServiceClient::getInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_instance.php
     *
     * @param GetInstanceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInstance(GetInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('GetInstance', $request, $callOptions)->wait();
    }

    /**
     * Check if a notebook instance is healthy.
     *
     * The async variant is {@see NotebookServiceClient::getInstanceHealthAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_instance_health.php
     *
     * @param GetInstanceHealthRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GetInstanceHealthResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInstanceHealth(GetInstanceHealthRequest $request, array $callOptions = []): GetInstanceHealthResponse
    {
        return $this->startApiCall('GetInstanceHealth', $request, $callOptions)->wait();
    }

    /**
     * Gets details of schedule
     *
     * The async variant is {@see NotebookServiceClient::getScheduleAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_schedule.php
     *
     * @param GetScheduleRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Schedule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSchedule(GetScheduleRequest $request, array $callOptions = []): Schedule
    {
        return $this->startApiCall('GetSchedule', $request, $callOptions)->wait();
    }

    /**
     * Check if a notebook instance is upgradable.
     *
     * The async variant is {@see NotebookServiceClient::isInstanceUpgradeableAsync()}
     * .
     *
     * @example samples/V1/NotebookServiceClient/is_instance_upgradeable.php
     *
     * @param IsInstanceUpgradeableRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IsInstanceUpgradeableResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function isInstanceUpgradeable(IsInstanceUpgradeableRequest $request, array $callOptions = []): IsInstanceUpgradeableResponse
    {
        return $this->startApiCall('IsInstanceUpgradeable', $request, $callOptions)->wait();
    }

    /**
     * Lists environments in a project.
     *
     * The async variant is {@see NotebookServiceClient::listEnvironmentsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_environments.php
     *
     * @param ListEnvironmentsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEnvironments(ListEnvironmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEnvironments', $request, $callOptions);
    }

    /**
     * Lists executions in a given project and location
     *
     * The async variant is {@see NotebookServiceClient::listExecutionsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_executions.php
     *
     * @param ListExecutionsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listExecutions(ListExecutionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListExecutions', $request, $callOptions);
    }

    /**
     * Lists instances in a given project and location.
     *
     * The async variant is {@see NotebookServiceClient::listInstancesAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_instances.php
     *
     * @param ListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInstances(ListInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInstances', $request, $callOptions);
    }

    /**
     * Lists schedules in a given project and location.
     *
     * The async variant is {@see NotebookServiceClient::listSchedulesAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_schedules.php
     *
     * @param ListSchedulesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSchedules(ListSchedulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSchedules', $request, $callOptions);
    }

    /**
     * Registers an existing legacy notebook instance to the Notebooks API server.
     * Legacy instances are instances created with the legacy Compute Engine
     * calls. They are not manageable by the Notebooks API out of the box. This
     * call makes these instances manageable by the Notebooks API.
     *
     * The async variant is {@see NotebookServiceClient::registerInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/register_instance.php
     *
     * @param RegisterInstanceRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function registerInstance(RegisterInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RegisterInstance', $request, $callOptions)->wait();
    }

    /**
     * Allows notebook instances to
     * report their latest instance information to the Notebooks
     * API server. The server will merge the reported information to
     * the instance metadata store. Do not use this method directly.
     *
     * The async variant is {@see NotebookServiceClient::reportInstanceInfoAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/report_instance_info.php
     *
     * @param ReportInstanceInfoRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function reportInstanceInfo(ReportInstanceInfoRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ReportInstanceInfo', $request, $callOptions)->wait();
    }

    /**
     * Resets a notebook instance.
     *
     * The async variant is {@see NotebookServiceClient::resetInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/reset_instance.php
     *
     * @param ResetInstanceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resetInstance(ResetInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResetInstance', $request, $callOptions)->wait();
    }

    /**
     * Rollbacks a notebook instance to the previous version.
     *
     * The async variant is {@see NotebookServiceClient::rollbackInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/rollback_instance.php
     *
     * @param RollbackInstanceRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rollbackInstance(RollbackInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RollbackInstance', $request, $callOptions)->wait();
    }

    /**
     * Updates the guest accelerators of a single Instance.
     *
     * The async variant is {@see NotebookServiceClient::setInstanceAcceleratorAsync()}
     * .
     *
     * @example samples/V1/NotebookServiceClient/set_instance_accelerator.php
     *
     * @param SetInstanceAcceleratorRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setInstanceAccelerator(SetInstanceAcceleratorRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetInstanceAccelerator', $request, $callOptions)->wait();
    }

    /**
     * Replaces all the labels of an Instance.
     *
     * The async variant is {@see NotebookServiceClient::setInstanceLabelsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/set_instance_labels.php
     *
     * @param SetInstanceLabelsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setInstanceLabels(SetInstanceLabelsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetInstanceLabels', $request, $callOptions)->wait();
    }

    /**
     * Updates the machine type of a single Instance.
     *
     * The async variant is {@see NotebookServiceClient::setInstanceMachineTypeAsync()}
     * .
     *
     * @example samples/V1/NotebookServiceClient/set_instance_machine_type.php
     *
     * @param SetInstanceMachineTypeRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setInstanceMachineType(SetInstanceMachineTypeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetInstanceMachineType', $request, $callOptions)->wait();
    }

    /**
     * Starts a notebook instance.
     *
     * The async variant is {@see NotebookServiceClient::startInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/start_instance.php
     *
     * @param StartInstanceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startInstance(StartInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StartInstance', $request, $callOptions)->wait();
    }

    /**
     * Stops a notebook instance.
     *
     * The async variant is {@see NotebookServiceClient::stopInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/stop_instance.php
     *
     * @param StopInstanceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopInstance(StopInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StopInstance', $request, $callOptions)->wait();
    }

    /**
     * Triggers execution of an existing schedule.
     *
     * The async variant is {@see NotebookServiceClient::triggerScheduleAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/trigger_schedule.php
     *
     * @param TriggerScheduleRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function triggerSchedule(TriggerScheduleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('TriggerSchedule', $request, $callOptions)->wait();
    }

    /**
     * Update Notebook Instance configurations.
     *
     * The async variant is {@see NotebookServiceClient::updateInstanceConfigAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/update_instance_config.php
     *
     * @param UpdateInstanceConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateInstanceConfig(UpdateInstanceConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateInstanceConfig', $request, $callOptions)->wait();
    }

    /**
     * Add/update metadata items for an instance.
     *
     * The async variant is
     * {@see NotebookServiceClient::updateInstanceMetadataItemsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/update_instance_metadata_items.php
     *
     * @param UpdateInstanceMetadataItemsRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UpdateInstanceMetadataItemsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateInstanceMetadataItems(UpdateInstanceMetadataItemsRequest $request, array $callOptions = []): UpdateInstanceMetadataItemsResponse
    {
        return $this->startApiCall('UpdateInstanceMetadataItems', $request, $callOptions)->wait();
    }

    /**
     * Updates the Shielded instance configuration of a single Instance.
     *
     * The async variant is
     * {@see NotebookServiceClient::updateShieldedInstanceConfigAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/update_shielded_instance_config.php
     *
     * @param UpdateShieldedInstanceConfigRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateShieldedInstanceConfig(UpdateShieldedInstanceConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateShieldedInstanceConfig', $request, $callOptions)->wait();
    }

    /**
     * Upgrades a notebook instance to the latest version.
     *
     * The async variant is {@see NotebookServiceClient::upgradeInstanceAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/upgrade_instance.php
     *
     * @param UpgradeInstanceRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function upgradeInstance(UpgradeInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpgradeInstance', $request, $callOptions)->wait();
    }

    /**
     * Allows notebook instances to
     * call this endpoint to upgrade themselves. Do not use this method directly.
     *
     * The async variant is
     * {@see NotebookServiceClient::upgradeInstanceInternalAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/upgrade_instance_internal.php
     *
     * @param UpgradeInstanceInternalRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function upgradeInstanceInternal(UpgradeInstanceInternalRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpgradeInstanceInternal', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see NotebookServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see NotebookServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see NotebookServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see NotebookServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see NotebookServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/NotebookServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
