<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/notebooks/v2/gce_setup.proto

namespace Google\Cloud\Notebooks\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A set of Shielded Instance options.
 * See [Images using supported Shielded VM
 * features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
 * Not all combinations are valid.
 *
 * Generated from protobuf message <code>google.cloud.notebooks.v2.ShieldedInstanceConfig</code>
 */
class ShieldedInstanceConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Defines whether the VM instance has Secure Boot enabled.
     * Secure Boot helps ensure that the system only runs authentic software by
     * verifying the digital signature of all boot components, and halting the
     * boot process if signature verification fails. Disabled by default.
     *
     * Generated from protobuf field <code>bool enable_secure_boot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enable_secure_boot = false;
    /**
     * Optional. Defines whether the VM instance has the vTPM enabled. Enabled by
     * default.
     *
     * Generated from protobuf field <code>bool enable_vtpm = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enable_vtpm = false;
    /**
     * Optional. Defines whether the VM instance has integrity monitoring enabled.
     * Enables monitoring and attestation of the boot integrity of the VM
     * instance. The attestation is performed against the integrity policy
     * baseline. This baseline is initially derived from the implicitly trusted
     * boot image when the VM instance is created. Enabled by default.
     *
     * Generated from protobuf field <code>bool enable_integrity_monitoring = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enable_integrity_monitoring = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enable_secure_boot
     *           Optional. Defines whether the VM instance has Secure Boot enabled.
     *           Secure Boot helps ensure that the system only runs authentic software by
     *           verifying the digital signature of all boot components, and halting the
     *           boot process if signature verification fails. Disabled by default.
     *     @type bool $enable_vtpm
     *           Optional. Defines whether the VM instance has the vTPM enabled. Enabled by
     *           default.
     *     @type bool $enable_integrity_monitoring
     *           Optional. Defines whether the VM instance has integrity monitoring enabled.
     *           Enables monitoring and attestation of the boot integrity of the VM
     *           instance. The attestation is performed against the integrity policy
     *           baseline. This baseline is initially derived from the implicitly trusted
     *           boot image when the VM instance is created. Enabled by default.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Notebooks\V2\GceSetup::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Defines whether the VM instance has Secure Boot enabled.
     * Secure Boot helps ensure that the system only runs authentic software by
     * verifying the digital signature of all boot components, and halting the
     * boot process if signature verification fails. Disabled by default.
     *
     * Generated from protobuf field <code>bool enable_secure_boot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableSecureBoot()
    {
        return $this->enable_secure_boot;
    }

    /**
     * Optional. Defines whether the VM instance has Secure Boot enabled.
     * Secure Boot helps ensure that the system only runs authentic software by
     * verifying the digital signature of all boot components, and halting the
     * boot process if signature verification fails. Disabled by default.
     *
     * Generated from protobuf field <code>bool enable_secure_boot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableSecureBoot($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_secure_boot = $var;

        return $this;
    }

    /**
     * Optional. Defines whether the VM instance has the vTPM enabled. Enabled by
     * default.
     *
     * Generated from protobuf field <code>bool enable_vtpm = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableVtpm()
    {
        return $this->enable_vtpm;
    }

    /**
     * Optional. Defines whether the VM instance has the vTPM enabled. Enabled by
     * default.
     *
     * Generated from protobuf field <code>bool enable_vtpm = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableVtpm($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_vtpm = $var;

        return $this;
    }

    /**
     * Optional. Defines whether the VM instance has integrity monitoring enabled.
     * Enables monitoring and attestation of the boot integrity of the VM
     * instance. The attestation is performed against the integrity policy
     * baseline. This baseline is initially derived from the implicitly trusted
     * boot image when the VM instance is created. Enabled by default.
     *
     * Generated from protobuf field <code>bool enable_integrity_monitoring = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableIntegrityMonitoring()
    {
        return $this->enable_integrity_monitoring;
    }

    /**
     * Optional. Defines whether the VM instance has integrity monitoring enabled.
     * Enables monitoring and attestation of the boot integrity of the VM
     * instance. The attestation is performed against the integrity policy
     * baseline. This baseline is initially derived from the implicitly trusted
     * boot image when the VM instance is created. Enabled by default.
     *
     * Generated from protobuf field <code>bool enable_integrity_monitoring = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableIntegrityMonitoring($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_integrity_monitoring = $var;

        return $this;
    }

}

