<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/search_service.proto

namespace Google\Cloud\Retail\V2\SearchResponse;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents the search results.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.SearchResponse.SearchResult</code>
 */
class SearchResult extends \Google\Protobuf\Internal\Message
{
    /**
     * [Product.id][google.cloud.retail.v2.Product.id] of the searched
     * [Product][google.cloud.retail.v2.Product].
     *
     * Generated from protobuf field <code>string id = 1;</code>
     */
    private $id = '';
    /**
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product product = 2;</code>
     */
    private $product = null;
    /**
     * The count of matched
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Generated from protobuf field <code>int32 matching_variant_count = 3;</code>
     */
    private $matching_variant_count = 0;
    /**
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.FieldMask> matching_variant_fields = 4;</code>
     */
    private $matching_variant_fields;
    /**
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(\"red\")" and rollup "colorFamilies", only "red" is
     * returned.
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> variant_rollup_values = 5;</code>
     */
    private $variant_rollup_values;
    /**
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     * Possible values:
     * * `purchased`: Indicates that this product has been purchased before.
     *
     * Generated from protobuf field <code>repeated string personal_labels = 7;</code>
     */
    private $personal_labels;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           [Product.id][google.cloud.retail.v2.Product.id] of the searched
     *           [Product][google.cloud.retail.v2.Product].
     *     @type \Google\Cloud\Retail\V2\Product $product
     *           The product data snippet in the search response. Only
     *           [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     *           populated.
     *           [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     *           product variants that match the search query. If there are multiple
     *           product variants matching the query, top 5 most relevant product variants
     *           are returned and ordered by relevancy.
     *           If relevancy can be deternmined, use
     *           [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     *           to look up matched product variants fields. If relevancy cannot be
     *           determined, e.g. when searching "shoe" all products in a shoe product can
     *           be a match, 5 product variants are returned but order is meaningless.
     *     @type int $matching_variant_count
     *           The count of matched
     *           [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     *           [Product][google.cloud.retail.v2.Product]s.
     *     @type array|\Google\Protobuf\Internal\MapField $matching_variant_fields
     *           If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     *           [Product][google.cloud.retail.v2.Product] matches the search query, this
     *           map indicates which [Product][google.cloud.retail.v2.Product] fields are
     *           matched. The key is the
     *           [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     *           mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     *           matched attributes cannot be determined, this map will be empty.
     *           For example, a key "sku1" with field mask
     *           "products.color_info" indicates there is a match between
     *           "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     *     @type array|\Google\Protobuf\Internal\MapField $variant_rollup_values
     *           The rollup matching
     *           [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     *           [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     *           the
     *           [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     *           The values are the merged and de-duplicated
     *           [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     *           rollup values are respect filter. For example, when filtering by
     *           "colorFamilies:ANY(\"red\")" and rollup "colorFamilies", only "red" is
     *           returned.
     *           For textual and numerical attributes, the rollup values is a list of
     *           string or double values with type
     *           [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     *           there are two variants with colors "red" and "blue", the rollup values
     *           are
     *               { key: "colorFamilies"
     *                 value {
     *                   list_value {
     *                     values { string_value: "red" }
     *                     values { string_value: "blue" }
     *                    }
     *                 }
     *               }
     *           For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     *           values is a double value with type
     *           [google.protobuf.Value][google.protobuf.Value]. For example,
     *           `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     *           are 10 variants in this product are available in the store "store1".
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $personal_labels
     *           Specifies previous events related to this product for this user based on
     *           [UserEvent][google.cloud.retail.v2.UserEvent] with same
     *           [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     *           or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     *           This is set only when
     *           [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     *           is
     *           [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     *           Possible values:
     *           * `purchased`: Indicates that this product has been purchased before.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * [Product.id][google.cloud.retail.v2.Product.id] of the searched
     * [Product][google.cloud.retail.v2.Product].
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * [Product.id][google.cloud.retail.v2.Product.id] of the searched
     * [Product][google.cloud.retail.v2.Product].
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product product = 2;</code>
     * @return \Google\Cloud\Retail\V2\Product|null
     */
    public function getProduct()
    {
        return $this->product;
    }

    public function hasProduct()
    {
        return isset($this->product);
    }

    public function clearProduct()
    {
        unset($this->product);
    }

    /**
     * The product data snippet in the search response. Only
     * [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
     * populated.
     * [Product.variants][google.cloud.retail.v2.Product.variants] contains the
     * product variants that match the search query. If there are multiple
     * product variants matching the query, top 5 most relevant product variants
     * are returned and ordered by relevancy.
     * If relevancy can be deternmined, use
     * [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
     * to look up matched product variants fields. If relevancy cannot be
     * determined, e.g. when searching "shoe" all products in a shoe product can
     * be a match, 5 product variants are returned but order is meaningless.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product product = 2;</code>
     * @param \Google\Cloud\Retail\V2\Product $var
     * @return $this
     */
    public function setProduct($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\Product::class);
        $this->product = $var;

        return $this;
    }

    /**
     * The count of matched
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Generated from protobuf field <code>int32 matching_variant_count = 3;</code>
     * @return int
     */
    public function getMatchingVariantCount()
    {
        return $this->matching_variant_count;
    }

    /**
     * The count of matched
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     *
     * Generated from protobuf field <code>int32 matching_variant_count = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMatchingVariantCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->matching_variant_count = $var;

        return $this;
    }

    /**
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.FieldMask> matching_variant_fields = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMatchingVariantFields()
    {
        return $this->matching_variant_fields;
    }

    /**
     * If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] matches the search query, this
     * map indicates which [Product][google.cloud.retail.v2.Product] fields are
     * matched. The key is the
     * [Product.name][google.cloud.retail.v2.Product.name], the value is a field
     * mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
     * matched attributes cannot be determined, this map will be empty.
     * For example, a key "sku1" with field mask
     * "products.color_info" indicates there is a match between
     * "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.FieldMask> matching_variant_fields = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMatchingVariantFields($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\FieldMask::class);
        $this->matching_variant_fields = $arr;

        return $this;
    }

    /**
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(\"red\")" and rollup "colorFamilies", only "red" is
     * returned.
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> variant_rollup_values = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getVariantRollupValues()
    {
        return $this->variant_rollup_values;
    }

    /**
     * The rollup matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product] attributes. The key is one of
     * the
     * [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
     * The values are the merged and de-duplicated
     * [Product][google.cloud.retail.v2.Product] attributes. Notice that the
     * rollup values are respect filter. For example, when filtering by
     * "colorFamilies:ANY(\"red\")" and rollup "colorFamilies", only "red" is
     * returned.
     * For textual and numerical attributes, the rollup values is a list of
     * string or double values with type
     * [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
     * there are two variants with colors "red" and "blue", the rollup values
     * are
     *     { key: "colorFamilies"
     *       value {
     *         list_value {
     *           values { string_value: "red" }
     *           values { string_value: "blue" }
     *          }
     *       }
     *     }
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
     * values is a double value with type
     * [google.protobuf.Value][google.protobuf.Value]. For example,
     * `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
     * are 10 variants in this product are available in the store "store1".
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.Value> variant_rollup_values = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setVariantRollupValues($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Value::class);
        $this->variant_rollup_values = $arr;

        return $this;
    }

    /**
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     * Possible values:
     * * `purchased`: Indicates that this product has been purchased before.
     *
     * Generated from protobuf field <code>repeated string personal_labels = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPersonalLabels()
    {
        return $this->personal_labels;
    }

    /**
     * Specifies previous events related to this product for this user based on
     * [UserEvent][google.cloud.retail.v2.UserEvent] with same
     * [SearchRequest.visitor_id][google.cloud.retail.v2.SearchRequest.visitor_id]
     * or [UserInfo.user_id][google.cloud.retail.v2.UserInfo.user_id].
     * This is set only when
     * [SearchRequest.PersonalizationSpec.mode][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.mode]
     * is
     * [SearchRequest.PersonalizationSpec.Mode.AUTO][google.cloud.retail.v2.SearchRequest.PersonalizationSpec.Mode.AUTO].
     * Possible values:
     * * `purchased`: Indicates that this product has been purchased before.
     *
     * Generated from protobuf field <code>repeated string personal_labels = 7;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPersonalLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->personal_labels = $arr;

        return $this;
    }

}


