<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v1/security_health_analytics_custom_module.proto

namespace Google\Cloud\SecurityCenter\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an instance of a Security Health Analytics custom module,
 * including its full module name, display name, enablement state, and last
 * updated time. You can create a custom module at the organization, folder, or
 * project level. Custom modules that you create at the organization or folder
 * level are inherited by the child folders and projects.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule</code>
 */
class SecurityHealthAnalyticsCustomModule extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     * The id {customModule} is server-generated and is not user settable.
     * It will be a numeric id containing 1-20 digits.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $name = '';
    /**
     * The display name of the Security Health Analytics custom module. This
     * display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and
     * 128 characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    private $display_name = '';
    /**
     * The enablement state of the custom module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;</code>
     */
    private $enablement_state = 0;
    /**
     * Output only. The time at which the custom module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Output only. The editor that last updated the custom module.
     *
     * Generated from protobuf field <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $last_editor = '';
    /**
     * Output only. If empty, indicates that the custom module was created in the
     * organization, folder, or project in which you are viewing the custom
     * module. Otherwise, `ancestor_module` specifies the organization or folder
     * from which the custom module is inherited.
     *
     * Generated from protobuf field <code>string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $ancestor_module = '';
    /**
     * The user specified custom configuration for the module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     */
    private $custom_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. The resource name of the custom module.
     *           Its format is
     *           "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     *           or
     *           "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     *           or
     *           "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     *           The id {customModule} is server-generated and is not user settable.
     *           It will be a numeric id containing 1-20 digits.
     *     @type string $display_name
     *           The display name of the Security Health Analytics custom module. This
     *           display name becomes the finding category for all findings that are
     *           returned by this custom module. The display name must be between 1 and
     *           128 characters, start with a lowercase letter, and contain alphanumeric
     *           characters or underscores only.
     *     @type int $enablement_state
     *           The enablement state of the custom module.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time at which the custom module was last updated.
     *     @type string $last_editor
     *           Output only. The editor that last updated the custom module.
     *     @type string $ancestor_module
     *           Output only. If empty, indicates that the custom module was created in the
     *           organization, folder, or project in which you are viewing the custom
     *           module. Otherwise, `ancestor_module` specifies the organization or folder
     *           from which the custom module is inherited.
     *     @type \Google\Cloud\SecurityCenter\V1\CustomConfig $custom_config
     *           The user specified custom configuration for the module.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V1\SecurityHealthAnalyticsCustomModule::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     * The id {customModule} is server-generated and is not user settable.
     * It will be a numeric id containing 1-20 digits.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. The resource name of the custom module.
     * Its format is
     * "organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}",
     * or
     * "projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}"
     * The id {customModule} is server-generated and is not user settable.
     * It will be a numeric id containing 1-20 digits.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The display name of the Security Health Analytics custom module. This
     * display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and
     * 128 characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The display name of the Security Health Analytics custom module. This
     * display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and
     * 128 characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The enablement state of the custom module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;</code>
     * @return int
     */
    public function getEnablementState()
    {
        return $this->enablement_state;
    }

    /**
     * The enablement state of the custom module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setEnablementState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\SecurityHealthAnalyticsCustomModule\EnablementState::class);
        $this->enablement_state = $var;

        return $this;
    }

    /**
     * Output only. The time at which the custom module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time at which the custom module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The editor that last updated the custom module.
     *
     * Generated from protobuf field <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastEditor()
    {
        return $this->last_editor;
    }

    /**
     * Output only. The editor that last updated the custom module.
     *
     * Generated from protobuf field <code>string last_editor = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastEditor($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_editor = $var;

        return $this;
    }

    /**
     * Output only. If empty, indicates that the custom module was created in the
     * organization, folder, or project in which you are viewing the custom
     * module. Otherwise, `ancestor_module` specifies the organization or folder
     * from which the custom module is inherited.
     *
     * Generated from protobuf field <code>string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAncestorModule()
    {
        return $this->ancestor_module;
    }

    /**
     * Output only. If empty, indicates that the custom module was created in the
     * organization, folder, or project in which you are viewing the custom
     * module. Otherwise, `ancestor_module` specifies the organization or folder
     * from which the custom module is inherited.
     *
     * Generated from protobuf field <code>string ancestor_module = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAncestorModule($var)
    {
        GPBUtil::checkString($var, True);
        $this->ancestor_module = $var;

        return $this;
    }

    /**
     * The user specified custom configuration for the module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     * @return \Google\Cloud\SecurityCenter\V1\CustomConfig|null
     */
    public function getCustomConfig()
    {
        return $this->custom_config;
    }

    public function hasCustomConfig()
    {
        return isset($this->custom_config);
    }

    public function clearCustomConfig()
    {
        unset($this->custom_config);
    }

    /**
     * The user specified custom configuration for the module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.CustomConfig custom_config = 8;</code>
     * @param \Google\Cloud\SecurityCenter\V1\CustomConfig $var
     * @return $this
     */
    public function setCustomConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenter\V1\CustomConfig::class);
        $this->custom_config = $var;

        return $this;
    }

}

