<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/inventories/v1beta/localinventory.proto

namespace Google\Shopping\Merchant\Inventories\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Local inventory information for the product. Represents in-store information
 * for a specific product at the store specified by
 * [`storeCode`][google.shopping.merchant.inventories.v1beta.LocalInventory.store_code].
 * For a list of all accepted attribute values, see the [local product inventory
 * feed specification](https://support.google.com/merchants/answer/3061342).
 *
 * Generated from protobuf message <code>google.shopping.merchant.inventories.v1beta.LocalInventory</code>
 */
class LocalInventory extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The name of the `LocalInventory` resource.
     * Format:
     * `accounts/{account}/products/{product}/localInventories/{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. The account that owns the product. This field will be ignored
     * if set by the client.
     *
     * Generated from protobuf field <code>int64 account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $account = 0;
    /**
     * Required. Store code (the store ID from your Business Profile) of the
     * physical store the product is sold in. See the [Local product inventory
     * feed specification](https://support.google.com/merchants/answer/3061342)
     * for more information.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $store_code = '';
    /**
     * Price of the product at this store.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 4;</code>
     */
    protected $price = null;
    /**
     * Sale price of the product at this store. Mandatory if
     * [`salePriceEffectiveDate`][google.shopping.merchant.inventories.v1beta.LocalInventory.sale_price_effective_date]
     * is defined.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price sale_price = 5;</code>
     */
    protected $sale_price = null;
    /**
     * The `TimePeriod` of the
     * sale at this store.
     *
     * Generated from protobuf field <code>.google.type.Interval sale_price_effective_date = 6;</code>
     */
    protected $sale_price_effective_date = null;
    /**
     * Availability of the product at this store.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string availability = 7;</code>
     */
    protected $availability = null;
    /**
     * Quantity of the product available at this store. Must be greater than or
     * equal to zero.
     *
     * Generated from protobuf field <code>optional int64 quantity = 8;</code>
     */
    protected $quantity = null;
    /**
     * Supported pickup method for this product. Unless the value is `"not
     * supported"`, this field must be submitted together with
     * `pickupSla`.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string pickup_method = 9;</code>
     */
    protected $pickup_method = null;
    /**
     * Relative time period from the order date for an order for this product,
     * from this store, to be ready for pickup. Must be submitted with
     * `pickupMethod`.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string pickup_sla = 10;</code>
     */
    protected $pickup_sla = null;
    /**
     * Location of the product inside the store. Maximum length is 20 bytes.
     *
     * Generated from protobuf field <code>optional string instore_product_location = 11;</code>
     */
    protected $instore_product_location = null;
    /**
     * A list of custom (merchant-provided) attributes. You can also use
     * `CustomAttribute` to submit any attribute of the feed specification in its
     * generic form.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 12;</code>
     */
    private $custom_attributes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The name of the `LocalInventory` resource.
     *           Format:
     *           `accounts/{account}/products/{product}/localInventories/{store_code}`
     *     @type int|string $account
     *           Output only. The account that owns the product. This field will be ignored
     *           if set by the client.
     *     @type string $store_code
     *           Required. Store code (the store ID from your Business Profile) of the
     *           physical store the product is sold in. See the [Local product inventory
     *           feed specification](https://support.google.com/merchants/answer/3061342)
     *           for more information.
     *     @type \Google\Shopping\Type\Price $price
     *           Price of the product at this store.
     *     @type \Google\Shopping\Type\Price $sale_price
     *           Sale price of the product at this store. Mandatory if
     *           [`salePriceEffectiveDate`][google.shopping.merchant.inventories.v1beta.LocalInventory.sale_price_effective_date]
     *           is defined.
     *     @type \Google\Type\Interval $sale_price_effective_date
     *           The `TimePeriod` of the
     *           sale at this store.
     *     @type string $availability
     *           Availability of the product at this store.
     *           For accepted attribute values, see the [local product inventory feed
     *           specification](https://support.google.com/merchants/answer/3061342)
     *     @type int|string $quantity
     *           Quantity of the product available at this store. Must be greater than or
     *           equal to zero.
     *     @type string $pickup_method
     *           Supported pickup method for this product. Unless the value is `"not
     *           supported"`, this field must be submitted together with
     *           `pickupSla`.
     *           For accepted attribute values, see the [local product inventory feed
     *           specification](https://support.google.com/merchants/answer/3061342)
     *     @type string $pickup_sla
     *           Relative time period from the order date for an order for this product,
     *           from this store, to be ready for pickup. Must be submitted with
     *           `pickupMethod`.
     *           For accepted attribute values, see the [local product inventory feed
     *           specification](https://support.google.com/merchants/answer/3061342)
     *     @type string $instore_product_location
     *           Location of the product inside the store. Maximum length is 20 bytes.
     *     @type array<\Google\Shopping\Type\CustomAttribute>|\Google\Protobuf\Internal\RepeatedField $custom_attributes
     *           A list of custom (merchant-provided) attributes. You can also use
     *           `CustomAttribute` to submit any attribute of the feed specification in its
     *           generic form.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Inventories\V1Beta\Localinventory::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The name of the `LocalInventory` resource.
     * Format:
     * `accounts/{account}/products/{product}/localInventories/{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The name of the `LocalInventory` resource.
     * Format:
     * `accounts/{account}/products/{product}/localInventories/{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The account that owns the product. This field will be ignored
     * if set by the client.
     *
     * Generated from protobuf field <code>int64 account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Output only. The account that owns the product. This field will be ignored
     * if set by the client.
     *
     * Generated from protobuf field <code>int64 account = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setAccount($var)
    {
        GPBUtil::checkInt64($var);
        $this->account = $var;

        return $this;
    }

    /**
     * Required. Store code (the store ID from your Business Profile) of the
     * physical store the product is sold in. See the [Local product inventory
     * feed specification](https://support.google.com/merchants/answer/3061342)
     * for more information.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getStoreCode()
    {
        return $this->store_code;
    }

    /**
     * Required. Store code (the store ID from your Business Profile) of the
     * physical store the product is sold in. See the [Local product inventory
     * feed specification](https://support.google.com/merchants/answer/3061342)
     * for more information.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setStoreCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->store_code = $var;

        return $this;
    }

    /**
     * Price of the product at this store.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 4;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function hasPrice()
    {
        return isset($this->price);
    }

    public function clearPrice()
    {
        unset($this->price);
    }

    /**
     * Price of the product at this store.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 4;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->price = $var;

        return $this;
    }

    /**
     * Sale price of the product at this store. Mandatory if
     * [`salePriceEffectiveDate`][google.shopping.merchant.inventories.v1beta.LocalInventory.sale_price_effective_date]
     * is defined.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price sale_price = 5;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getSalePrice()
    {
        return $this->sale_price;
    }

    public function hasSalePrice()
    {
        return isset($this->sale_price);
    }

    public function clearSalePrice()
    {
        unset($this->sale_price);
    }

    /**
     * Sale price of the product at this store. Mandatory if
     * [`salePriceEffectiveDate`][google.shopping.merchant.inventories.v1beta.LocalInventory.sale_price_effective_date]
     * is defined.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price sale_price = 5;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setSalePrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->sale_price = $var;

        return $this;
    }

    /**
     * The `TimePeriod` of the
     * sale at this store.
     *
     * Generated from protobuf field <code>.google.type.Interval sale_price_effective_date = 6;</code>
     * @return \Google\Type\Interval|null
     */
    public function getSalePriceEffectiveDate()
    {
        return $this->sale_price_effective_date;
    }

    public function hasSalePriceEffectiveDate()
    {
        return isset($this->sale_price_effective_date);
    }

    public function clearSalePriceEffectiveDate()
    {
        unset($this->sale_price_effective_date);
    }

    /**
     * The `TimePeriod` of the
     * sale at this store.
     *
     * Generated from protobuf field <code>.google.type.Interval sale_price_effective_date = 6;</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setSalePriceEffectiveDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->sale_price_effective_date = $var;

        return $this;
    }

    /**
     * Availability of the product at this store.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string availability = 7;</code>
     * @return string
     */
    public function getAvailability()
    {
        return isset($this->availability) ? $this->availability : '';
    }

    public function hasAvailability()
    {
        return isset($this->availability);
    }

    public function clearAvailability()
    {
        unset($this->availability);
    }

    /**
     * Availability of the product at this store.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string availability = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setAvailability($var)
    {
        GPBUtil::checkString($var, True);
        $this->availability = $var;

        return $this;
    }

    /**
     * Quantity of the product available at this store. Must be greater than or
     * equal to zero.
     *
     * Generated from protobuf field <code>optional int64 quantity = 8;</code>
     * @return int|string
     */
    public function getQuantity()
    {
        return isset($this->quantity) ? $this->quantity : 0;
    }

    public function hasQuantity()
    {
        return isset($this->quantity);
    }

    public function clearQuantity()
    {
        unset($this->quantity);
    }

    /**
     * Quantity of the product available at this store. Must be greater than or
     * equal to zero.
     *
     * Generated from protobuf field <code>optional int64 quantity = 8;</code>
     * @param int|string $var
     * @return $this
     */
    public function setQuantity($var)
    {
        GPBUtil::checkInt64($var);
        $this->quantity = $var;

        return $this;
    }

    /**
     * Supported pickup method for this product. Unless the value is `"not
     * supported"`, this field must be submitted together with
     * `pickupSla`.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string pickup_method = 9;</code>
     * @return string
     */
    public function getPickupMethod()
    {
        return isset($this->pickup_method) ? $this->pickup_method : '';
    }

    public function hasPickupMethod()
    {
        return isset($this->pickup_method);
    }

    public function clearPickupMethod()
    {
        unset($this->pickup_method);
    }

    /**
     * Supported pickup method for this product. Unless the value is `"not
     * supported"`, this field must be submitted together with
     * `pickupSla`.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string pickup_method = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setPickupMethod($var)
    {
        GPBUtil::checkString($var, True);
        $this->pickup_method = $var;

        return $this;
    }

    /**
     * Relative time period from the order date for an order for this product,
     * from this store, to be ready for pickup. Must be submitted with
     * `pickupMethod`.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string pickup_sla = 10;</code>
     * @return string
     */
    public function getPickupSla()
    {
        return isset($this->pickup_sla) ? $this->pickup_sla : '';
    }

    public function hasPickupSla()
    {
        return isset($this->pickup_sla);
    }

    public function clearPickupSla()
    {
        unset($this->pickup_sla);
    }

    /**
     * Relative time period from the order date for an order for this product,
     * from this store, to be ready for pickup. Must be submitted with
     * `pickupMethod`.
     * For accepted attribute values, see the [local product inventory feed
     * specification](https://support.google.com/merchants/answer/3061342)
     *
     * Generated from protobuf field <code>optional string pickup_sla = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setPickupSla($var)
    {
        GPBUtil::checkString($var, True);
        $this->pickup_sla = $var;

        return $this;
    }

    /**
     * Location of the product inside the store. Maximum length is 20 bytes.
     *
     * Generated from protobuf field <code>optional string instore_product_location = 11;</code>
     * @return string
     */
    public function getInstoreProductLocation()
    {
        return isset($this->instore_product_location) ? $this->instore_product_location : '';
    }

    public function hasInstoreProductLocation()
    {
        return isset($this->instore_product_location);
    }

    public function clearInstoreProductLocation()
    {
        unset($this->instore_product_location);
    }

    /**
     * Location of the product inside the store. Maximum length is 20 bytes.
     *
     * Generated from protobuf field <code>optional string instore_product_location = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setInstoreProductLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->instore_product_location = $var;

        return $this;
    }

    /**
     * A list of custom (merchant-provided) attributes. You can also use
     * `CustomAttribute` to submit any attribute of the feed specification in its
     * generic form.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomAttributes()
    {
        return $this->custom_attributes;
    }

    /**
     * A list of custom (merchant-provided) attributes. You can also use
     * `CustomAttribute` to submit any attribute of the feed specification in its
     * generic form.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 12;</code>
     * @param array<\Google\Shopping\Type\CustomAttribute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Type\CustomAttribute::class);
        $this->custom_attributes = $arr;

        return $this;
    }

}

