<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1/cloud_sql_resources.proto

namespace Google\Cloud\Sql\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Database instance settings.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1.Settings</code>
 */
class Settings extends \Google\Protobuf\Internal\Message
{
    /**
     * The version of instance settings. This is a required field for update
     * method to make sure concurrent updates are handled properly. During update,
     * use the most recent settingsVersion value for this instance and do not try
     * to update this value.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value settings_version = 1;</code>
     */
    private $settings_version = null;
    /**
     * The App Engine app IDs that can access this instance.
     * (Deprecated) Applied to First Generation instances only.
     *
     * Generated from protobuf field <code>repeated string authorized_gae_applications = 2 [deprecated = true];</code>
     * @deprecated
     */
    private $authorized_gae_applications;
    /**
     * The tier (or machine type) for this instance, for example
     * `db-custom-1-3840`. WARNING: Changing this restarts the instance.
     *
     * Generated from protobuf field <code>string tier = 3;</code>
     */
    private $tier = '';
    /**
     * This is always `sql#settings`.
     *
     * Generated from protobuf field <code>string kind = 4;</code>
     */
    private $kind = '';
    /**
     * User-provided labels, represented as a dictionary where each label is a
     * single key value pair.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 5;</code>
     */
    private $user_labels;
    /**
     * Availability type. Potential values:
     * *  `ZONAL`: The instance serves data from only one zone. Outages in that
     * zone affect data accessibility.
     * *  `REGIONAL`: The instance can serve data from more than one zone in a
     * region (it is highly available)./
     * For more information, see [Overview of the High Availability
     * Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlAvailabilityType availability_type = 6;</code>
     */
    private $availability_type = 0;
    /**
     * The pricing plan for this instance. This can be either `PER_USE` or
     * `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlPricingPlan pricing_plan = 7;</code>
     */
    private $pricing_plan = 0;
    /**
     * The type of replication this instance uses. This can be either
     * `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only
     * applicable to First Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlReplicationType replication_type = 8 [deprecated = true];</code>
     * @deprecated
     */
    protected $replication_type = 0;
    /**
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value storage_auto_resize_limit = 9;</code>
     */
    private $storage_auto_resize_limit = null;
    /**
     * The activation policy specifies when the instance is activated; it is
     * applicable only when the instance state is RUNNABLE. Valid values:
     * *  `ALWAYS`: The instance is on, and remains so even in the absence of
     * connection requests.
     * *  `NEVER`: The instance is off; it is not activated, even if a
     * connection request arrives.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.SqlActivationPolicy activation_policy = 10;</code>
     */
    private $activation_policy = 0;
    /**
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled for Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.IpConfiguration ip_configuration = 11;</code>
     */
    private $ip_configuration = null;
    /**
     * Configuration to increase storage size automatically. The default value is
     * true.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue storage_auto_resize = 12;</code>
     */
    private $storage_auto_resize = null;
    /**
     * The location preference settings. This allows the instance to be located as
     * near as possible to either an App Engine app or Compute Engine zone for
     * better performance. App Engine co-location was only applicable to First
     * Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.LocationPreference location_preference = 13;</code>
     */
    private $location_preference = null;
    /**
     * The database flags passed to the instance at startup.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.DatabaseFlags database_flags = 14;</code>
     */
    private $database_flags;
    /**
     * The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for
     * First Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDataDiskType data_disk_type = 15;</code>
     */
    private $data_disk_type = 0;
    /**
     * The maintenance window for this instance. This specifies when the instance
     * can be restarted for maintenance purposes.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.MaintenanceWindow maintenance_window = 16;</code>
     */
    private $maintenance_window = null;
    /**
     * The daily backup configuration for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.BackupConfiguration backup_configuration = 17;</code>
     */
    private $backup_configuration = null;
    /**
     * Configuration specific to read replica instances. Indicates whether
     * replication is enabled or not. WARNING: Changing this restarts the
     * instance.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue database_replication_enabled = 18;</code>
     */
    private $database_replication_enabled = null;
    /**
     * Configuration specific to read replica instances. Indicates whether
     * database flags for crash-safe replication are enabled. This property was
     * only applicable to First Generation instances.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue crash_safe_replication_enabled = 19 [deprecated = true];</code>
     * @deprecated
     */
    protected $crash_safe_replication_enabled = null;
    /**
     * The size of data disk, in GB. The data disk size minimum is 10GB.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value data_disk_size_gb = 20;</code>
     */
    private $data_disk_size_gb = null;
    /**
     * Active Directory configuration, relevant only for Cloud SQL for SQL Server.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlActiveDirectoryConfig active_directory_config = 22;</code>
     */
    private $active_directory_config = null;
    /**
     * The name of server Instance collation.
     *
     * Generated from protobuf field <code>string collation = 23;</code>
     */
    private $collation = '';
    /**
     * Deny maintenance periods
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.DenyMaintenancePeriod deny_maintenance_periods = 24;</code>
     */
    private $deny_maintenance_periods;
    /**
     * Insights configuration, for now relevant only for Postgres.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.InsightsConfig insights_config = 25;</code>
     */
    private $insights_config = null;
    /**
     * The local user password validation policy of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.PasswordValidationPolicy password_validation_policy = 27;</code>
     */
    private $password_validation_policy = null;
    /**
     * SQL Server specific audit configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlServerAuditConfig sql_server_audit_config = 29;</code>
     */
    private $sql_server_audit_config = null;
    /**
     * Optional. The edition of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.Edition edition = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $edition = 0;
    /**
     * Specifies if connections must use Cloud SQL connectors.
     * Option values include the following: `NOT_REQUIRED` (Cloud SQL instances
     * can be connected without Cloud SQL
     * Connectors) and `REQUIRED` (Only allow connections that use Cloud SQL
     * Connectors).
     * Note that using REQUIRED disables all existing authorized networks. If
     * this field is not specified when creating a new instance, NOT_REQUIRED is
     * used. If this field is not specified when patching or updating an existing
     * instance, it is left unchanged in the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.ConnectorEnforcement connector_enforcement = 32;</code>
     */
    private $connector_enforcement = 0;
    /**
     * Configuration to protect against accidental instance deletion.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue deletion_protection_enabled = 33;</code>
     */
    private $deletion_protection_enabled = null;
    /**
     * Server timezone, relevant only for Cloud SQL for SQL Server.
     *
     * Generated from protobuf field <code>string time_zone = 34;</code>
     */
    private $time_zone = '';
    /**
     * Specifies advance machine configuration for the instance
     * relevant only for SQL Server.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.AdvancedMachineFeatures advanced_machine_features = 35;</code>
     */
    private $advanced_machine_features = null;
    /**
     * Configuration for data cache.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DataCacheConfig data_cache_config = 37;</code>
     */
    private $data_cache_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Int64Value $settings_version
     *           The version of instance settings. This is a required field for update
     *           method to make sure concurrent updates are handled properly. During update,
     *           use the most recent settingsVersion value for this instance and do not try
     *           to update this value.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $authorized_gae_applications
     *           The App Engine app IDs that can access this instance.
     *           (Deprecated) Applied to First Generation instances only.
     *     @type string $tier
     *           The tier (or machine type) for this instance, for example
     *           `db-custom-1-3840`. WARNING: Changing this restarts the instance.
     *     @type string $kind
     *           This is always `sql#settings`.
     *     @type array|\Google\Protobuf\Internal\MapField $user_labels
     *           User-provided labels, represented as a dictionary where each label is a
     *           single key value pair.
     *     @type int $availability_type
     *           Availability type. Potential values:
     *           *  `ZONAL`: The instance serves data from only one zone. Outages in that
     *           zone affect data accessibility.
     *           *  `REGIONAL`: The instance can serve data from more than one zone in a
     *           region (it is highly available)./
     *           For more information, see [Overview of the High Availability
     *           Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).
     *     @type int $pricing_plan
     *           The pricing plan for this instance. This can be either `PER_USE` or
     *           `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.
     *     @type int $replication_type
     *           The type of replication this instance uses. This can be either
     *           `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only
     *           applicable to First Generation instances.
     *     @type \Google\Protobuf\Int64Value $storage_auto_resize_limit
     *           The maximum size to which storage capacity can be automatically increased.
     *           The default value is 0, which specifies that there is no limit.
     *     @type int $activation_policy
     *           The activation policy specifies when the instance is activated; it is
     *           applicable only when the instance state is RUNNABLE. Valid values:
     *           *  `ALWAYS`: The instance is on, and remains so even in the absence of
     *           connection requests.
     *           *  `NEVER`: The instance is off; it is not activated, even if a
     *           connection request arrives.
     *     @type \Google\Cloud\Sql\V1\IpConfiguration $ip_configuration
     *           The settings for IP Management. This allows to enable or disable the
     *           instance IP and manage which external networks can connect to the instance.
     *           The IPv4 address cannot be disabled for Second Generation instances.
     *     @type \Google\Protobuf\BoolValue $storage_auto_resize
     *           Configuration to increase storage size automatically. The default value is
     *           true.
     *     @type \Google\Cloud\Sql\V1\LocationPreference $location_preference
     *           The location preference settings. This allows the instance to be located as
     *           near as possible to either an App Engine app or Compute Engine zone for
     *           better performance. App Engine co-location was only applicable to First
     *           Generation instances.
     *     @type array<\Google\Cloud\Sql\V1\DatabaseFlags>|\Google\Protobuf\Internal\RepeatedField $database_flags
     *           The database flags passed to the instance at startup.
     *     @type int $data_disk_type
     *           The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for
     *           First Generation instances.
     *     @type \Google\Cloud\Sql\V1\MaintenanceWindow $maintenance_window
     *           The maintenance window for this instance. This specifies when the instance
     *           can be restarted for maintenance purposes.
     *     @type \Google\Cloud\Sql\V1\BackupConfiguration $backup_configuration
     *           The daily backup configuration for the instance.
     *     @type \Google\Protobuf\BoolValue $database_replication_enabled
     *           Configuration specific to read replica instances. Indicates whether
     *           replication is enabled or not. WARNING: Changing this restarts the
     *           instance.
     *     @type \Google\Protobuf\BoolValue $crash_safe_replication_enabled
     *           Configuration specific to read replica instances. Indicates whether
     *           database flags for crash-safe replication are enabled. This property was
     *           only applicable to First Generation instances.
     *     @type \Google\Protobuf\Int64Value $data_disk_size_gb
     *           The size of data disk, in GB. The data disk size minimum is 10GB.
     *     @type \Google\Cloud\Sql\V1\SqlActiveDirectoryConfig $active_directory_config
     *           Active Directory configuration, relevant only for Cloud SQL for SQL Server.
     *     @type string $collation
     *           The name of server Instance collation.
     *     @type array<\Google\Cloud\Sql\V1\DenyMaintenancePeriod>|\Google\Protobuf\Internal\RepeatedField $deny_maintenance_periods
     *           Deny maintenance periods
     *     @type \Google\Cloud\Sql\V1\InsightsConfig $insights_config
     *           Insights configuration, for now relevant only for Postgres.
     *     @type \Google\Cloud\Sql\V1\PasswordValidationPolicy $password_validation_policy
     *           The local user password validation policy of the instance.
     *     @type \Google\Cloud\Sql\V1\SqlServerAuditConfig $sql_server_audit_config
     *           SQL Server specific audit configuration.
     *     @type int $edition
     *           Optional. The edition of the instance.
     *     @type int $connector_enforcement
     *           Specifies if connections must use Cloud SQL connectors.
     *           Option values include the following: `NOT_REQUIRED` (Cloud SQL instances
     *           can be connected without Cloud SQL
     *           Connectors) and `REQUIRED` (Only allow connections that use Cloud SQL
     *           Connectors).
     *           Note that using REQUIRED disables all existing authorized networks. If
     *           this field is not specified when creating a new instance, NOT_REQUIRED is
     *           used. If this field is not specified when patching or updating an existing
     *           instance, it is left unchanged in the instance.
     *     @type \Google\Protobuf\BoolValue $deletion_protection_enabled
     *           Configuration to protect against accidental instance deletion.
     *     @type string $time_zone
     *           Server timezone, relevant only for Cloud SQL for SQL Server.
     *     @type \Google\Cloud\Sql\V1\AdvancedMachineFeatures $advanced_machine_features
     *           Specifies advance machine configuration for the instance
     *           relevant only for SQL Server.
     *     @type \Google\Cloud\Sql\V1\DataCacheConfig $data_cache_config
     *           Configuration for data cache.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1\CloudSqlResources::initOnce();
        parent::__construct($data);
    }

    /**
     * The version of instance settings. This is a required field for update
     * method to make sure concurrent updates are handled properly. During update,
     * use the most recent settingsVersion value for this instance and do not try
     * to update this value.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value settings_version = 1;</code>
     * @return \Google\Protobuf\Int64Value|null
     */
    public function getSettingsVersion()
    {
        return $this->settings_version;
    }

    public function hasSettingsVersion()
    {
        return isset($this->settings_version);
    }

    public function clearSettingsVersion()
    {
        unset($this->settings_version);
    }

    /**
     * Returns the unboxed value from <code>getSettingsVersion()</code>

     * The version of instance settings. This is a required field for update
     * method to make sure concurrent updates are handled properly. During update,
     * use the most recent settingsVersion value for this instance and do not try
     * to update this value.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value settings_version = 1;</code>
     * @return int|string|null
     */
    public function getSettingsVersionValue()
    {
        return $this->readWrapperValue("settings_version");
    }

    /**
     * The version of instance settings. This is a required field for update
     * method to make sure concurrent updates are handled properly. During update,
     * use the most recent settingsVersion value for this instance and do not try
     * to update this value.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value settings_version = 1;</code>
     * @param \Google\Protobuf\Int64Value $var
     * @return $this
     */
    public function setSettingsVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int64Value::class);
        $this->settings_version = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int64Value object.

     * The version of instance settings. This is a required field for update
     * method to make sure concurrent updates are handled properly. During update,
     * use the most recent settingsVersion value for this instance and do not try
     * to update this value.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value settings_version = 1;</code>
     * @param int|string|null $var
     * @return $this
     */
    public function setSettingsVersionValue($var)
    {
        $this->writeWrapperValue("settings_version", $var);
        return $this;}

    /**
     * The App Engine app IDs that can access this instance.
     * (Deprecated) Applied to First Generation instances only.
     *
     * Generated from protobuf field <code>repeated string authorized_gae_applications = 2 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getAuthorizedGaeApplications()
    {
        @trigger_error('authorized_gae_applications is deprecated.', E_USER_DEPRECATED);
        return $this->authorized_gae_applications;
    }

    /**
     * The App Engine app IDs that can access this instance.
     * (Deprecated) Applied to First Generation instances only.
     *
     * Generated from protobuf field <code>repeated string authorized_gae_applications = 2 [deprecated = true];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setAuthorizedGaeApplications($var)
    {
        @trigger_error('authorized_gae_applications is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->authorized_gae_applications = $arr;

        return $this;
    }

    /**
     * The tier (or machine type) for this instance, for example
     * `db-custom-1-3840`. WARNING: Changing this restarts the instance.
     *
     * Generated from protobuf field <code>string tier = 3;</code>
     * @return string
     */
    public function getTier()
    {
        return $this->tier;
    }

    /**
     * The tier (or machine type) for this instance, for example
     * `db-custom-1-3840`. WARNING: Changing this restarts the instance.
     *
     * Generated from protobuf field <code>string tier = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setTier($var)
    {
        GPBUtil::checkString($var, True);
        $this->tier = $var;

        return $this;
    }

    /**
     * This is always `sql#settings`.
     *
     * Generated from protobuf field <code>string kind = 4;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * This is always `sql#settings`.
     *
     * Generated from protobuf field <code>string kind = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * User-provided labels, represented as a dictionary where each label is a
     * single key value pair.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getUserLabels()
    {
        return $this->user_labels;
    }

    /**
     * User-provided labels, represented as a dictionary where each label is a
     * single key value pair.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setUserLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->user_labels = $arr;

        return $this;
    }

    /**
     * Availability type. Potential values:
     * *  `ZONAL`: The instance serves data from only one zone. Outages in that
     * zone affect data accessibility.
     * *  `REGIONAL`: The instance can serve data from more than one zone in a
     * region (it is highly available)./
     * For more information, see [Overview of the High Availability
     * Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlAvailabilityType availability_type = 6;</code>
     * @return int
     */
    public function getAvailabilityType()
    {
        return $this->availability_type;
    }

    /**
     * Availability type. Potential values:
     * *  `ZONAL`: The instance serves data from only one zone. Outages in that
     * zone affect data accessibility.
     * *  `REGIONAL`: The instance can serve data from more than one zone in a
     * region (it is highly available)./
     * For more information, see [Overview of the High Availability
     * Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlAvailabilityType availability_type = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setAvailabilityType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlAvailabilityType::class);
        $this->availability_type = $var;

        return $this;
    }

    /**
     * The pricing plan for this instance. This can be either `PER_USE` or
     * `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlPricingPlan pricing_plan = 7;</code>
     * @return int
     */
    public function getPricingPlan()
    {
        return $this->pricing_plan;
    }

    /**
     * The pricing plan for this instance. This can be either `PER_USE` or
     * `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlPricingPlan pricing_plan = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setPricingPlan($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlPricingPlan::class);
        $this->pricing_plan = $var;

        return $this;
    }

    /**
     * The type of replication this instance uses. This can be either
     * `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only
     * applicable to First Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlReplicationType replication_type = 8 [deprecated = true];</code>
     * @return int
     * @deprecated
     */
    public function getReplicationType()
    {
        @trigger_error('replication_type is deprecated.', E_USER_DEPRECATED);
        return $this->replication_type;
    }

    /**
     * The type of replication this instance uses. This can be either
     * `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only
     * applicable to First Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlReplicationType replication_type = 8 [deprecated = true];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setReplicationType($var)
    {
        @trigger_error('replication_type is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlReplicationType::class);
        $this->replication_type = $var;

        return $this;
    }

    /**
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value storage_auto_resize_limit = 9;</code>
     * @return \Google\Protobuf\Int64Value|null
     */
    public function getStorageAutoResizeLimit()
    {
        return $this->storage_auto_resize_limit;
    }

    public function hasStorageAutoResizeLimit()
    {
        return isset($this->storage_auto_resize_limit);
    }

    public function clearStorageAutoResizeLimit()
    {
        unset($this->storage_auto_resize_limit);
    }

    /**
     * Returns the unboxed value from <code>getStorageAutoResizeLimit()</code>

     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value storage_auto_resize_limit = 9;</code>
     * @return int|string|null
     */
    public function getStorageAutoResizeLimitValue()
    {
        return $this->readWrapperValue("storage_auto_resize_limit");
    }

    /**
     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value storage_auto_resize_limit = 9;</code>
     * @param \Google\Protobuf\Int64Value $var
     * @return $this
     */
    public function setStorageAutoResizeLimit($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int64Value::class);
        $this->storage_auto_resize_limit = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int64Value object.

     * The maximum size to which storage capacity can be automatically increased.
     * The default value is 0, which specifies that there is no limit.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value storage_auto_resize_limit = 9;</code>
     * @param int|string|null $var
     * @return $this
     */
    public function setStorageAutoResizeLimitValue($var)
    {
        $this->writeWrapperValue("storage_auto_resize_limit", $var);
        return $this;}

    /**
     * The activation policy specifies when the instance is activated; it is
     * applicable only when the instance state is RUNNABLE. Valid values:
     * *  `ALWAYS`: The instance is on, and remains so even in the absence of
     * connection requests.
     * *  `NEVER`: The instance is off; it is not activated, even if a
     * connection request arrives.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.SqlActivationPolicy activation_policy = 10;</code>
     * @return int
     */
    public function getActivationPolicy()
    {
        return $this->activation_policy;
    }

    /**
     * The activation policy specifies when the instance is activated; it is
     * applicable only when the instance state is RUNNABLE. Valid values:
     * *  `ALWAYS`: The instance is on, and remains so even in the absence of
     * connection requests.
     * *  `NEVER`: The instance is off; it is not activated, even if a
     * connection request arrives.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.SqlActivationPolicy activation_policy = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setActivationPolicy($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\Settings\SqlActivationPolicy::class);
        $this->activation_policy = $var;

        return $this;
    }

    /**
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled for Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.IpConfiguration ip_configuration = 11;</code>
     * @return \Google\Cloud\Sql\V1\IpConfiguration|null
     */
    public function getIpConfiguration()
    {
        return $this->ip_configuration;
    }

    public function hasIpConfiguration()
    {
        return isset($this->ip_configuration);
    }

    public function clearIpConfiguration()
    {
        unset($this->ip_configuration);
    }

    /**
     * The settings for IP Management. This allows to enable or disable the
     * instance IP and manage which external networks can connect to the instance.
     * The IPv4 address cannot be disabled for Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.IpConfiguration ip_configuration = 11;</code>
     * @param \Google\Cloud\Sql\V1\IpConfiguration $var
     * @return $this
     */
    public function setIpConfiguration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\IpConfiguration::class);
        $this->ip_configuration = $var;

        return $this;
    }

    /**
     * Configuration to increase storage size automatically. The default value is
     * true.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue storage_auto_resize = 12;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getStorageAutoResize()
    {
        return $this->storage_auto_resize;
    }

    public function hasStorageAutoResize()
    {
        return isset($this->storage_auto_resize);
    }

    public function clearStorageAutoResize()
    {
        unset($this->storage_auto_resize);
    }

    /**
     * Returns the unboxed value from <code>getStorageAutoResize()</code>

     * Configuration to increase storage size automatically. The default value is
     * true.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue storage_auto_resize = 12;</code>
     * @return bool|null
     */
    public function getStorageAutoResizeValue()
    {
        return $this->readWrapperValue("storage_auto_resize");
    }

    /**
     * Configuration to increase storage size automatically. The default value is
     * true.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue storage_auto_resize = 12;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setStorageAutoResize($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->storage_auto_resize = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Configuration to increase storage size automatically. The default value is
     * true.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue storage_auto_resize = 12;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setStorageAutoResizeValue($var)
    {
        $this->writeWrapperValue("storage_auto_resize", $var);
        return $this;}

    /**
     * The location preference settings. This allows the instance to be located as
     * near as possible to either an App Engine app or Compute Engine zone for
     * better performance. App Engine co-location was only applicable to First
     * Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.LocationPreference location_preference = 13;</code>
     * @return \Google\Cloud\Sql\V1\LocationPreference|null
     */
    public function getLocationPreference()
    {
        return $this->location_preference;
    }

    public function hasLocationPreference()
    {
        return isset($this->location_preference);
    }

    public function clearLocationPreference()
    {
        unset($this->location_preference);
    }

    /**
     * The location preference settings. This allows the instance to be located as
     * near as possible to either an App Engine app or Compute Engine zone for
     * better performance. App Engine co-location was only applicable to First
     * Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.LocationPreference location_preference = 13;</code>
     * @param \Google\Cloud\Sql\V1\LocationPreference $var
     * @return $this
     */
    public function setLocationPreference($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\LocationPreference::class);
        $this->location_preference = $var;

        return $this;
    }

    /**
     * The database flags passed to the instance at startup.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.DatabaseFlags database_flags = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDatabaseFlags()
    {
        return $this->database_flags;
    }

    /**
     * The database flags passed to the instance at startup.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.DatabaseFlags database_flags = 14;</code>
     * @param array<\Google\Cloud\Sql\V1\DatabaseFlags>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDatabaseFlags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Sql\V1\DatabaseFlags::class);
        $this->database_flags = $arr;

        return $this;
    }

    /**
     * The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for
     * First Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDataDiskType data_disk_type = 15;</code>
     * @return int
     */
    public function getDataDiskType()
    {
        return $this->data_disk_type;
    }

    /**
     * The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for
     * First Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDataDiskType data_disk_type = 15;</code>
     * @param int $var
     * @return $this
     */
    public function setDataDiskType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlDataDiskType::class);
        $this->data_disk_type = $var;

        return $this;
    }

    /**
     * The maintenance window for this instance. This specifies when the instance
     * can be restarted for maintenance purposes.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.MaintenanceWindow maintenance_window = 16;</code>
     * @return \Google\Cloud\Sql\V1\MaintenanceWindow|null
     */
    public function getMaintenanceWindow()
    {
        return $this->maintenance_window;
    }

    public function hasMaintenanceWindow()
    {
        return isset($this->maintenance_window);
    }

    public function clearMaintenanceWindow()
    {
        unset($this->maintenance_window);
    }

    /**
     * The maintenance window for this instance. This specifies when the instance
     * can be restarted for maintenance purposes.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.MaintenanceWindow maintenance_window = 16;</code>
     * @param \Google\Cloud\Sql\V1\MaintenanceWindow $var
     * @return $this
     */
    public function setMaintenanceWindow($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\MaintenanceWindow::class);
        $this->maintenance_window = $var;

        return $this;
    }

    /**
     * The daily backup configuration for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.BackupConfiguration backup_configuration = 17;</code>
     * @return \Google\Cloud\Sql\V1\BackupConfiguration|null
     */
    public function getBackupConfiguration()
    {
        return $this->backup_configuration;
    }

    public function hasBackupConfiguration()
    {
        return isset($this->backup_configuration);
    }

    public function clearBackupConfiguration()
    {
        unset($this->backup_configuration);
    }

    /**
     * The daily backup configuration for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.BackupConfiguration backup_configuration = 17;</code>
     * @param \Google\Cloud\Sql\V1\BackupConfiguration $var
     * @return $this
     */
    public function setBackupConfiguration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\BackupConfiguration::class);
        $this->backup_configuration = $var;

        return $this;
    }

    /**
     * Configuration specific to read replica instances. Indicates whether
     * replication is enabled or not. WARNING: Changing this restarts the
     * instance.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue database_replication_enabled = 18;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getDatabaseReplicationEnabled()
    {
        return $this->database_replication_enabled;
    }

    public function hasDatabaseReplicationEnabled()
    {
        return isset($this->database_replication_enabled);
    }

    public function clearDatabaseReplicationEnabled()
    {
        unset($this->database_replication_enabled);
    }

    /**
     * Returns the unboxed value from <code>getDatabaseReplicationEnabled()</code>

     * Configuration specific to read replica instances. Indicates whether
     * replication is enabled or not. WARNING: Changing this restarts the
     * instance.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue database_replication_enabled = 18;</code>
     * @return bool|null
     */
    public function getDatabaseReplicationEnabledValue()
    {
        return $this->readWrapperValue("database_replication_enabled");
    }

    /**
     * Configuration specific to read replica instances. Indicates whether
     * replication is enabled or not. WARNING: Changing this restarts the
     * instance.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue database_replication_enabled = 18;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setDatabaseReplicationEnabled($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->database_replication_enabled = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Configuration specific to read replica instances. Indicates whether
     * replication is enabled or not. WARNING: Changing this restarts the
     * instance.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue database_replication_enabled = 18;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setDatabaseReplicationEnabledValue($var)
    {
        $this->writeWrapperValue("database_replication_enabled", $var);
        return $this;}

    /**
     * Configuration specific to read replica instances. Indicates whether
     * database flags for crash-safe replication are enabled. This property was
     * only applicable to First Generation instances.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue crash_safe_replication_enabled = 19 [deprecated = true];</code>
     * @return \Google\Protobuf\BoolValue|null
     * @deprecated
     */
    public function getCrashSafeReplicationEnabled()
    {
        @trigger_error('crash_safe_replication_enabled is deprecated.', E_USER_DEPRECATED);
        return $this->crash_safe_replication_enabled;
    }

    public function hasCrashSafeReplicationEnabled()
    {
        @trigger_error('crash_safe_replication_enabled is deprecated.', E_USER_DEPRECATED);
        return isset($this->crash_safe_replication_enabled);
    }

    public function clearCrashSafeReplicationEnabled()
    {
        @trigger_error('crash_safe_replication_enabled is deprecated.', E_USER_DEPRECATED);
        unset($this->crash_safe_replication_enabled);
    }

    /**
     * Returns the unboxed value from <code>getCrashSafeReplicationEnabled()</code>

     * Configuration specific to read replica instances. Indicates whether
     * database flags for crash-safe replication are enabled. This property was
     * only applicable to First Generation instances.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue crash_safe_replication_enabled = 19 [deprecated = true];</code>
     * @return bool|null
     */
    public function getCrashSafeReplicationEnabledValue()
    {
        @trigger_error('crash_safe_replication_enabled is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("crash_safe_replication_enabled");
    }

    /**
     * Configuration specific to read replica instances. Indicates whether
     * database flags for crash-safe replication are enabled. This property was
     * only applicable to First Generation instances.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue crash_safe_replication_enabled = 19 [deprecated = true];</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     * @deprecated
     */
    public function setCrashSafeReplicationEnabled($var)
    {
        @trigger_error('crash_safe_replication_enabled is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->crash_safe_replication_enabled = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Configuration specific to read replica instances. Indicates whether
     * database flags for crash-safe replication are enabled. This property was
     * only applicable to First Generation instances.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue crash_safe_replication_enabled = 19 [deprecated = true];</code>
     * @param bool|null $var
     * @return $this
     */
    public function setCrashSafeReplicationEnabledValue($var)
    {
        $this->writeWrapperValue("crash_safe_replication_enabled", $var);
        return $this;}

    /**
     * The size of data disk, in GB. The data disk size minimum is 10GB.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value data_disk_size_gb = 20;</code>
     * @return \Google\Protobuf\Int64Value|null
     */
    public function getDataDiskSizeGb()
    {
        return $this->data_disk_size_gb;
    }

    public function hasDataDiskSizeGb()
    {
        return isset($this->data_disk_size_gb);
    }

    public function clearDataDiskSizeGb()
    {
        unset($this->data_disk_size_gb);
    }

    /**
     * Returns the unboxed value from <code>getDataDiskSizeGb()</code>

     * The size of data disk, in GB. The data disk size minimum is 10GB.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value data_disk_size_gb = 20;</code>
     * @return int|string|null
     */
    public function getDataDiskSizeGbValue()
    {
        return $this->readWrapperValue("data_disk_size_gb");
    }

    /**
     * The size of data disk, in GB. The data disk size minimum is 10GB.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value data_disk_size_gb = 20;</code>
     * @param \Google\Protobuf\Int64Value $var
     * @return $this
     */
    public function setDataDiskSizeGb($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int64Value::class);
        $this->data_disk_size_gb = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int64Value object.

     * The size of data disk, in GB. The data disk size minimum is 10GB.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value data_disk_size_gb = 20;</code>
     * @param int|string|null $var
     * @return $this
     */
    public function setDataDiskSizeGbValue($var)
    {
        $this->writeWrapperValue("data_disk_size_gb", $var);
        return $this;}

    /**
     * Active Directory configuration, relevant only for Cloud SQL for SQL Server.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlActiveDirectoryConfig active_directory_config = 22;</code>
     * @return \Google\Cloud\Sql\V1\SqlActiveDirectoryConfig|null
     */
    public function getActiveDirectoryConfig()
    {
        return $this->active_directory_config;
    }

    public function hasActiveDirectoryConfig()
    {
        return isset($this->active_directory_config);
    }

    public function clearActiveDirectoryConfig()
    {
        unset($this->active_directory_config);
    }

    /**
     * Active Directory configuration, relevant only for Cloud SQL for SQL Server.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlActiveDirectoryConfig active_directory_config = 22;</code>
     * @param \Google\Cloud\Sql\V1\SqlActiveDirectoryConfig $var
     * @return $this
     */
    public function setActiveDirectoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\SqlActiveDirectoryConfig::class);
        $this->active_directory_config = $var;

        return $this;
    }

    /**
     * The name of server Instance collation.
     *
     * Generated from protobuf field <code>string collation = 23;</code>
     * @return string
     */
    public function getCollation()
    {
        return $this->collation;
    }

    /**
     * The name of server Instance collation.
     *
     * Generated from protobuf field <code>string collation = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setCollation($var)
    {
        GPBUtil::checkString($var, True);
        $this->collation = $var;

        return $this;
    }

    /**
     * Deny maintenance periods
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.DenyMaintenancePeriod deny_maintenance_periods = 24;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDenyMaintenancePeriods()
    {
        return $this->deny_maintenance_periods;
    }

    /**
     * Deny maintenance periods
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.DenyMaintenancePeriod deny_maintenance_periods = 24;</code>
     * @param array<\Google\Cloud\Sql\V1\DenyMaintenancePeriod>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDenyMaintenancePeriods($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Sql\V1\DenyMaintenancePeriod::class);
        $this->deny_maintenance_periods = $arr;

        return $this;
    }

    /**
     * Insights configuration, for now relevant only for Postgres.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.InsightsConfig insights_config = 25;</code>
     * @return \Google\Cloud\Sql\V1\InsightsConfig|null
     */
    public function getInsightsConfig()
    {
        return $this->insights_config;
    }

    public function hasInsightsConfig()
    {
        return isset($this->insights_config);
    }

    public function clearInsightsConfig()
    {
        unset($this->insights_config);
    }

    /**
     * Insights configuration, for now relevant only for Postgres.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.InsightsConfig insights_config = 25;</code>
     * @param \Google\Cloud\Sql\V1\InsightsConfig $var
     * @return $this
     */
    public function setInsightsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\InsightsConfig::class);
        $this->insights_config = $var;

        return $this;
    }

    /**
     * The local user password validation policy of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.PasswordValidationPolicy password_validation_policy = 27;</code>
     * @return \Google\Cloud\Sql\V1\PasswordValidationPolicy|null
     */
    public function getPasswordValidationPolicy()
    {
        return $this->password_validation_policy;
    }

    public function hasPasswordValidationPolicy()
    {
        return isset($this->password_validation_policy);
    }

    public function clearPasswordValidationPolicy()
    {
        unset($this->password_validation_policy);
    }

    /**
     * The local user password validation policy of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.PasswordValidationPolicy password_validation_policy = 27;</code>
     * @param \Google\Cloud\Sql\V1\PasswordValidationPolicy $var
     * @return $this
     */
    public function setPasswordValidationPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\PasswordValidationPolicy::class);
        $this->password_validation_policy = $var;

        return $this;
    }

    /**
     * SQL Server specific audit configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlServerAuditConfig sql_server_audit_config = 29;</code>
     * @return \Google\Cloud\Sql\V1\SqlServerAuditConfig|null
     */
    public function getSqlServerAuditConfig()
    {
        return $this->sql_server_audit_config;
    }

    public function hasSqlServerAuditConfig()
    {
        return isset($this->sql_server_audit_config);
    }

    public function clearSqlServerAuditConfig()
    {
        unset($this->sql_server_audit_config);
    }

    /**
     * SQL Server specific audit configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlServerAuditConfig sql_server_audit_config = 29;</code>
     * @param \Google\Cloud\Sql\V1\SqlServerAuditConfig $var
     * @return $this
     */
    public function setSqlServerAuditConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\SqlServerAuditConfig::class);
        $this->sql_server_audit_config = $var;

        return $this;
    }

    /**
     * Optional. The edition of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.Edition edition = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getEdition()
    {
        return $this->edition;
    }

    /**
     * Optional. The edition of the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.Edition edition = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setEdition($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\Settings\Edition::class);
        $this->edition = $var;

        return $this;
    }

    /**
     * Specifies if connections must use Cloud SQL connectors.
     * Option values include the following: `NOT_REQUIRED` (Cloud SQL instances
     * can be connected without Cloud SQL
     * Connectors) and `REQUIRED` (Only allow connections that use Cloud SQL
     * Connectors).
     * Note that using REQUIRED disables all existing authorized networks. If
     * this field is not specified when creating a new instance, NOT_REQUIRED is
     * used. If this field is not specified when patching or updating an existing
     * instance, it is left unchanged in the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.ConnectorEnforcement connector_enforcement = 32;</code>
     * @return int
     */
    public function getConnectorEnforcement()
    {
        return $this->connector_enforcement;
    }

    /**
     * Specifies if connections must use Cloud SQL connectors.
     * Option values include the following: `NOT_REQUIRED` (Cloud SQL instances
     * can be connected without Cloud SQL
     * Connectors) and `REQUIRED` (Only allow connections that use Cloud SQL
     * Connectors).
     * Note that using REQUIRED disables all existing authorized networks. If
     * this field is not specified when creating a new instance, NOT_REQUIRED is
     * used. If this field is not specified when patching or updating an existing
     * instance, it is left unchanged in the instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings.ConnectorEnforcement connector_enforcement = 32;</code>
     * @param int $var
     * @return $this
     */
    public function setConnectorEnforcement($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\Settings\ConnectorEnforcement::class);
        $this->connector_enforcement = $var;

        return $this;
    }

    /**
     * Configuration to protect against accidental instance deletion.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue deletion_protection_enabled = 33;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getDeletionProtectionEnabled()
    {
        return $this->deletion_protection_enabled;
    }

    public function hasDeletionProtectionEnabled()
    {
        return isset($this->deletion_protection_enabled);
    }

    public function clearDeletionProtectionEnabled()
    {
        unset($this->deletion_protection_enabled);
    }

    /**
     * Returns the unboxed value from <code>getDeletionProtectionEnabled()</code>

     * Configuration to protect against accidental instance deletion.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue deletion_protection_enabled = 33;</code>
     * @return bool|null
     */
    public function getDeletionProtectionEnabledValue()
    {
        return $this->readWrapperValue("deletion_protection_enabled");
    }

    /**
     * Configuration to protect against accidental instance deletion.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue deletion_protection_enabled = 33;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setDeletionProtectionEnabled($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->deletion_protection_enabled = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Configuration to protect against accidental instance deletion.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue deletion_protection_enabled = 33;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setDeletionProtectionEnabledValue($var)
    {
        $this->writeWrapperValue("deletion_protection_enabled", $var);
        return $this;}

    /**
     * Server timezone, relevant only for Cloud SQL for SQL Server.
     *
     * Generated from protobuf field <code>string time_zone = 34;</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * Server timezone, relevant only for Cloud SQL for SQL Server.
     *
     * Generated from protobuf field <code>string time_zone = 34;</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * Specifies advance machine configuration for the instance
     * relevant only for SQL Server.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.AdvancedMachineFeatures advanced_machine_features = 35;</code>
     * @return \Google\Cloud\Sql\V1\AdvancedMachineFeatures|null
     */
    public function getAdvancedMachineFeatures()
    {
        return $this->advanced_machine_features;
    }

    public function hasAdvancedMachineFeatures()
    {
        return isset($this->advanced_machine_features);
    }

    public function clearAdvancedMachineFeatures()
    {
        unset($this->advanced_machine_features);
    }

    /**
     * Specifies advance machine configuration for the instance
     * relevant only for SQL Server.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.AdvancedMachineFeatures advanced_machine_features = 35;</code>
     * @param \Google\Cloud\Sql\V1\AdvancedMachineFeatures $var
     * @return $this
     */
    public function setAdvancedMachineFeatures($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\AdvancedMachineFeatures::class);
        $this->advanced_machine_features = $var;

        return $this;
    }

    /**
     * Configuration for data cache.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DataCacheConfig data_cache_config = 37;</code>
     * @return \Google\Cloud\Sql\V1\DataCacheConfig|null
     */
    public function getDataCacheConfig()
    {
        return $this->data_cache_config;
    }

    public function hasDataCacheConfig()
    {
        return isset($this->data_cache_config);
    }

    public function clearDataCacheConfig()
    {
        unset($this->data_cache_config);
    }

    /**
     * Configuration for data cache.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DataCacheConfig data_cache_config = 37;</code>
     * @param \Google\Cloud\Sql\V1\DataCacheConfig $var
     * @return $this
     */
    public function setDataCacheConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\DataCacheConfig::class);
        $this->data_cache_config = $var;

        return $this;
    }

}

