<?php

return [
    'interfaces' => [
        'google.cloud.sql.v1.SqlBackupRunsService' => [
            'Delete' => [
                'method' => 'delete',
                'uriTemplate' => '/v1/projects/{project}/instances/{instance}/backupRuns/{id}',
                'placeholders' => [
                    'id' => [
                        'getters' => [
                            'getId',
                        ],
                    ],
                    'instance' => [
                        'getters' => [
                            'getInstance',
                        ],
                    ],
                    'project' => [
                        'getters' => [
                            'getProject',
                        ],
                    ],
                ],
            ],
            'Get' => [
                'method' => 'get',
                'uriTemplate' => '/v1/projects/{project}/instances/{instance}/backupRuns/{id}',
                'placeholders' => [
                    'id' => [
                        'getters' => [
                            'getId',
                        ],
                    ],
                    'instance' => [
                        'getters' => [
                            'getInstance',
                        ],
                    ],
                    'project' => [
                        'getters' => [
                            'getProject',
                        ],
                    ],
                ],
            ],
            'Insert' => [
                'method' => 'post',
                'uriTemplate' => '/v1/projects/{project}/instances/{instance}/backupRuns',
                'body' => 'body',
                'placeholders' => [
                    'instance' => [
                        'getters' => [
                            'getInstance',
                        ],
                    ],
                    'project' => [
                        'getters' => [
                            'getProject',
                        ],
                    ],
                ],
            ],
            'List' => [
                'method' => 'get',
                'uriTemplate' => '/v1/projects/{project}/instances/{instance}/backupRuns',
                'placeholders' => [
                    'instance' => [
                        'getters' => [
                            'getInstance',
                        ],
                    ],
                    'project' => [
                        'getters' => [
                            'getProject',
                        ],
                    ],
                ],
            ],
        ],
    ],
    'numericEnums' => true,
];
