<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/tasks/v2beta2/target.proto

namespace Google\Cloud\Tasks\V2beta2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Uri Override.
 * When specified, all the HTTP tasks inside the queue will be partially or
 * fully overridden depending on the configured values.
 *
 * Generated from protobuf message <code>google.cloud.tasks.v2beta2.UriOverride</code>
 */
class UriOverride extends \Google\Protobuf\Internal\Message
{
    /**
     * Scheme override.
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     *
     * Generated from protobuf field <code>optional .google.cloud.tasks.v2beta2.UriOverride.Scheme scheme = 1;</code>
     */
    private $scheme = null;
    /**
     * Host override.
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     *
     * Generated from protobuf field <code>optional string host = 2;</code>
     */
    private $host = null;
    /**
     * Port override.
     * When specified, replaces the port part of the task URI. For instance,
     * for a URI http://www.google.com/foo and port=123, the overridden URI
     * becomes http://www.google.com:123/foo. Note that the port value must be a
     * positive integer. Setting the port to 0 (Zero) clears the URI port.
     *
     * Generated from protobuf field <code>optional int64 port = 3;</code>
     */
    private $port = null;
    /**
     * URI path.
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.PathOverride path_override = 4;</code>
     */
    private $path_override = null;
    /**
     * URI Query.
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.QueryOverride query_override = 5;</code>
     */
    private $query_override = null;
    /**
     * URI Override Enforce Mode
     * When specified, determines the Target UriOverride mode. If not specified,
     * it defaults to ALWAYS.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;</code>
     */
    private $uri_override_enforce_mode = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $scheme
     *           Scheme override.
     *           When specified, the task URI scheme is replaced by the provided value (HTTP
     *           or HTTPS).
     *     @type string $host
     *           Host override.
     *           When specified, replaces the host part of the task URL. For example,
     *           if the task URL is "https://www.google.com," and host value is set to
     *           "example.net", the overridden URI will be changed to "https://example.net."
     *           Host value cannot be an empty string (INVALID_ARGUMENT).
     *     @type int|string $port
     *           Port override.
     *           When specified, replaces the port part of the task URI. For instance,
     *           for a URI http://www.google.com/foo and port=123, the overridden URI
     *           becomes http://www.google.com:123/foo. Note that the port value must be a
     *           positive integer. Setting the port to 0 (Zero) clears the URI port.
     *     @type \Google\Cloud\Tasks\V2beta2\PathOverride $path_override
     *           URI path.
     *           When specified, replaces the existing path of the task URL. Setting the
     *           path value to an empty string clears the URI path segment.
     *     @type \Google\Cloud\Tasks\V2beta2\QueryOverride $query_override
     *           URI Query.
     *           When specified, replaces the query part of the task URI. Setting the
     *           query value to an empty string clears the URI query segment.
     *     @type int $uri_override_enforce_mode
     *           URI Override Enforce Mode
     *           When specified, determines the Target UriOverride mode. If not specified,
     *           it defaults to ALWAYS.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Tasks\V2Beta2\Target::initOnce();
        parent::__construct($data);
    }

    /**
     * Scheme override.
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     *
     * Generated from protobuf field <code>optional .google.cloud.tasks.v2beta2.UriOverride.Scheme scheme = 1;</code>
     * @return int
     */
    public function getScheme()
    {
        return isset($this->scheme) ? $this->scheme : 0;
    }

    public function hasScheme()
    {
        return isset($this->scheme);
    }

    public function clearScheme()
    {
        unset($this->scheme);
    }

    /**
     * Scheme override.
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     *
     * Generated from protobuf field <code>optional .google.cloud.tasks.v2beta2.UriOverride.Scheme scheme = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setScheme($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Tasks\V2beta2\UriOverride\Scheme::class);
        $this->scheme = $var;

        return $this;
    }

    /**
     * Host override.
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     *
     * Generated from protobuf field <code>optional string host = 2;</code>
     * @return string
     */
    public function getHost()
    {
        return isset($this->host) ? $this->host : '';
    }

    public function hasHost()
    {
        return isset($this->host);
    }

    public function clearHost()
    {
        unset($this->host);
    }

    /**
     * Host override.
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     *
     * Generated from protobuf field <code>optional string host = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setHost($var)
    {
        GPBUtil::checkString($var, True);
        $this->host = $var;

        return $this;
    }

    /**
     * Port override.
     * When specified, replaces the port part of the task URI. For instance,
     * for a URI http://www.google.com/foo and port=123, the overridden URI
     * becomes http://www.google.com:123/foo. Note that the port value must be a
     * positive integer. Setting the port to 0 (Zero) clears the URI port.
     *
     * Generated from protobuf field <code>optional int64 port = 3;</code>
     * @return int|string
     */
    public function getPort()
    {
        return isset($this->port) ? $this->port : 0;
    }

    public function hasPort()
    {
        return isset($this->port);
    }

    public function clearPort()
    {
        unset($this->port);
    }

    /**
     * Port override.
     * When specified, replaces the port part of the task URI. For instance,
     * for a URI http://www.google.com/foo and port=123, the overridden URI
     * becomes http://www.google.com:123/foo. Note that the port value must be a
     * positive integer. Setting the port to 0 (Zero) clears the URI port.
     *
     * Generated from protobuf field <code>optional int64 port = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt64($var);
        $this->port = $var;

        return $this;
    }

    /**
     * URI path.
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.PathOverride path_override = 4;</code>
     * @return \Google\Cloud\Tasks\V2beta2\PathOverride|null
     */
    public function getPathOverride()
    {
        return $this->path_override;
    }

    public function hasPathOverride()
    {
        return isset($this->path_override);
    }

    public function clearPathOverride()
    {
        unset($this->path_override);
    }

    /**
     * URI path.
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.PathOverride path_override = 4;</code>
     * @param \Google\Cloud\Tasks\V2beta2\PathOverride $var
     * @return $this
     */
    public function setPathOverride($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta2\PathOverride::class);
        $this->path_override = $var;

        return $this;
    }

    /**
     * URI Query.
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.QueryOverride query_override = 5;</code>
     * @return \Google\Cloud\Tasks\V2beta2\QueryOverride|null
     */
    public function getQueryOverride()
    {
        return $this->query_override;
    }

    public function hasQueryOverride()
    {
        return isset($this->query_override);
    }

    public function clearQueryOverride()
    {
        unset($this->query_override);
    }

    /**
     * URI Query.
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.QueryOverride query_override = 5;</code>
     * @param \Google\Cloud\Tasks\V2beta2\QueryOverride $var
     * @return $this
     */
    public function setQueryOverride($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta2\QueryOverride::class);
        $this->query_override = $var;

        return $this;
    }

    /**
     * URI Override Enforce Mode
     * When specified, determines the Target UriOverride mode. If not specified,
     * it defaults to ALWAYS.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;</code>
     * @return int
     */
    public function getUriOverrideEnforceMode()
    {
        return $this->uri_override_enforce_mode;
    }

    /**
     * URI Override Enforce Mode
     * When specified, determines the Target UriOverride mode. If not specified,
     * it defaults to ALWAYS.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setUriOverrideEnforceMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Tasks\V2beta2\UriOverride\UriOverrideEnforceMode::class);
        $this->uri_override_enforce_mode = $var;

        return $this;
    }

}

