<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/video/livestream/v1/resources.proto

namespace Google\Cloud\Video\LiveStream\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An asset represents a video or an image.
 *
 * Generated from protobuf message <code>google.cloud.video.livestream.v1.Asset</code>
 */
class Asset extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the asset, in the form of:
     * `projects/{project}/locations/{location}/assets/{assetId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Based64-encoded CRC32c checksum of the asset file. For more information,
     * see the crc32c checksum of the [Cloud Storage Objects
     * resource](https://cloud.google.com/storage/docs/json_api/v1/objects).
     * If crc32c is omitted or left empty when the asset is created, this field is
     * filled by the crc32c checksum of the Cloud Storage object indicated by
     * [VideoAsset.uri] or [ImageAsset.uri].
     * If crc32c is set, the asset can't be created if the crc32c value does not
     * match with the crc32c checksum of the Cloud Storage object indicated by
     * [VideoAsset.uri] or [ImageAsset.uri].
     *
     * Generated from protobuf field <code>string crc32c = 7;</code>
     */
    private $crc32c = '';
    /**
     * Output only. The state of the asset resource.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Asset.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Only present when `state` is `ERROR`. The reason for the error
     * state of the asset.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $error = null;
    protected $resource;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the asset, in the form of:
     *           `projects/{project}/locations/{location}/assets/{assetId}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update time.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User-defined key/value metadata.
     *     @type \Google\Cloud\Video\LiveStream\V1\Asset\VideoAsset $video
     *           VideoAsset represents a video.
     *     @type \Google\Cloud\Video\LiveStream\V1\Asset\ImageAsset $image
     *           ImageAsset represents an image.
     *     @type string $crc32c
     *           Based64-encoded CRC32c checksum of the asset file. For more information,
     *           see the crc32c checksum of the [Cloud Storage Objects
     *           resource](https://cloud.google.com/storage/docs/json_api/v1/objects).
     *           If crc32c is omitted or left empty when the asset is created, this field is
     *           filled by the crc32c checksum of the Cloud Storage object indicated by
     *           [VideoAsset.uri] or [ImageAsset.uri].
     *           If crc32c is set, the asset can't be created if the crc32c value does not
     *           match with the crc32c checksum of the Cloud Storage object indicated by
     *           [VideoAsset.uri] or [ImageAsset.uri].
     *     @type int $state
     *           Output only. The state of the asset resource.
     *     @type \Google\Rpc\Status $error
     *           Output only. Only present when `state` is `ERROR`. The reason for the error
     *           state of the asset.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Video\Livestream\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the asset, in the form of:
     * `projects/{project}/locations/{location}/assets/{assetId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the asset, in the form of:
     * `projects/{project}/locations/{location}/assets/{assetId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * VideoAsset represents a video.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Asset.VideoAsset video = 5;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Asset\VideoAsset|null
     */
    public function getVideo()
    {
        return $this->readOneof(5);
    }

    public function hasVideo()
    {
        return $this->hasOneof(5);
    }

    /**
     * VideoAsset represents a video.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Asset.VideoAsset video = 5;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Asset\VideoAsset $var
     * @return $this
     */
    public function setVideo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Asset\VideoAsset::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * ImageAsset represents an image.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Asset.ImageAsset image = 6;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Asset\ImageAsset|null
     */
    public function getImage()
    {
        return $this->readOneof(6);
    }

    public function hasImage()
    {
        return $this->hasOneof(6);
    }

    /**
     * ImageAsset represents an image.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Asset.ImageAsset image = 6;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Asset\ImageAsset $var
     * @return $this
     */
    public function setImage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Asset\ImageAsset::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Based64-encoded CRC32c checksum of the asset file. For more information,
     * see the crc32c checksum of the [Cloud Storage Objects
     * resource](https://cloud.google.com/storage/docs/json_api/v1/objects).
     * If crc32c is omitted or left empty when the asset is created, this field is
     * filled by the crc32c checksum of the Cloud Storage object indicated by
     * [VideoAsset.uri] or [ImageAsset.uri].
     * If crc32c is set, the asset can't be created if the crc32c value does not
     * match with the crc32c checksum of the Cloud Storage object indicated by
     * [VideoAsset.uri] or [ImageAsset.uri].
     *
     * Generated from protobuf field <code>string crc32c = 7;</code>
     * @return string
     */
    public function getCrc32C()
    {
        return $this->crc32c;
    }

    /**
     * Based64-encoded CRC32c checksum of the asset file. For more information,
     * see the crc32c checksum of the [Cloud Storage Objects
     * resource](https://cloud.google.com/storage/docs/json_api/v1/objects).
     * If crc32c is omitted or left empty when the asset is created, this field is
     * filled by the crc32c checksum of the Cloud Storage object indicated by
     * [VideoAsset.uri] or [ImageAsset.uri].
     * If crc32c is set, the asset can't be created if the crc32c value does not
     * match with the crc32c checksum of the Cloud Storage object indicated by
     * [VideoAsset.uri] or [ImageAsset.uri].
     *
     * Generated from protobuf field <code>string crc32c = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setCrc32C($var)
    {
        GPBUtil::checkString($var, True);
        $this->crc32c = $var;

        return $this;
    }

    /**
     * Output only. The state of the asset resource.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Asset.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the asset resource.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Asset.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Video\LiveStream\V1\Asset\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Only present when `state` is `ERROR`. The reason for the error
     * state of the asset.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * Output only. Only present when `state` is `ERROR`. The reason for the error
     * state of the asset.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getResource()
    {
        return $this->whichOneof("resource");
    }

}

